/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jpos.DlgMessage;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.pay.PayDialog;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import jpos.voucher.Voucher;
import jpos.voucher.VoucherUtils;

public class VoucherPinDlg
extends PayDialog {
    private LabelSubHeading lPinNum = new LabelSubHeading();
    private TouchTextField tfPinNum = new TouchTextField();
    private DialogButton bOk = new DialogButton("", this);
    private DialogButton bCancel = new DialogButton("", this);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    Voucher voucher;

    public VoucherPinDlg(Frame parentFrame, String title) {
        this(parentFrame, title, null);
    }

    public VoucherPinDlg(Frame parentFrame, String title, Voucher voucher) {
        super(parentFrame, title);
        this.voucher = voucher;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayout1);
        this.lPinNum.setText("");
        this.tfPinNum.setText("");
        this.tfPinNum.setFieldWidth(100);
        this.tfPinNum.setHorizontalAlignment(4);
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.getContentPane().add(this.panelAll);
        this.panelAll.add((Component)this.lPinNum, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelAll.add((Component)this.tfPinNum, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 20, 10, 20), 100, 0));
        this.panelAll.add((Component)this.bOk, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelAll.add((Component)this.bCancel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfPinNum);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    @Override
    public boolean initDialog() {
        this.tfPinNum.setText("");
        this.lPinNum.setText(SP.getRS("enter_pin"));
        this.setTitle(SP.getRS("enter_pin"));
        this.pack();
        return super.initDialog();
    }

    @Override
    public void okDialog() {
        if (this.validatePinNum()) {
            super.okDialog();
        }
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public String getPin() {
        return this.tfPinNum.getText();
    }

    private boolean validatePinNum() {
        boolean bOk = true;
        if (this.voucher != null) {
            if (!VoucherUtils.decryptPin(this.voucher.getPin()).equals(this.tfPinNum.getText())) {
                bOk = false;
                DlgMessage.showMessage(this.frSales, StoreParams.res.getString("voucher_pin_invalid"), StoreParams.res.getString("Stop"), 0);
            }
        } else if (!this.tfPinNum.getText().matches("^[0-9]{4}$")) {
            bOk = false;
            DlgMessage.showMessage(this.frSales, StoreParams.res.getString("voucher_pin_invalid"), StoreParams.res.getString("Stop"), 0);
        }
        if (!bOk) {
            this.tfPinNum.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VoucherPinDlg.this.tfPinNum.selectAll();
                }
            });
        }
        return bOk;
    }
}

