/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.afterpay;

import java.util.Arrays;
import java.util.List;
import jpos.SP;
import jpos.StringUtils;
import jpos.pay.afterpay.AfterpayOnlineAPIEntity;

public class AfterpayOnlineAPIErrorException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final List<Integer> UNKNOWN_RESULT_HTTP_STATUS_CODES = Arrays.asList(409, -1);
    private AfterpayOnlineAPIEntity.ErrorResponse apiError;

    public AfterpayOnlineAPIErrorException(String message, AfterpayOnlineAPIEntity.ErrorResponse apiError) {
        super(message);
        this.apiError = apiError;
    }

    public AfterpayOnlineAPIErrorException(String message, Exception e) {
        super(message, e);
    }

    public AfterpayOnlineAPIErrorException(String message) {
        super(message);
    }

    public String getErrorCode() {
        return this.apiError != null ? this.apiError.errorCode : "";
    }

    public String getErrorId() {
        return this.apiError != null ? this.apiError.errorId : "";
    }

    public int getHttpStatusCode() {
        return this.apiError != null ? this.apiError.httpStatusCode : -1;
    }

    public boolean isResultUnknown() {
        return UNKNOWN_RESULT_HTTP_STATUS_CODES.contains(this.getHttpStatusCode());
    }

    public String getErrorMessage() {
        if (this.apiError != null) {
            if (!StringUtils.isNullOrEmpty(this.apiError.message)) {
                return this.apiError.message;
            }
            return SP.getRS("afterpay_missing_error", "\n", this.apiError.errorCode, this.apiError.httpStatusCode);
        }
        return this.getCause() != null ? this.getCause().getMessage() : this.getMessage();
    }
}

