/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import com.teamdev.jxbrowser.js.JsAccessible;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jpos.Currency;
import jpos.PosDateFormatter;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.basscom.utils.Utils;
import jpos.browser.JSMap;
import jpos.browser.ListWrapper;
import jpos.person.PersonAttributes;
import jpos.rewards.RewardsAccount;
import org.jdom.Element;

@JsAccessible
public class PersonContext {
    public boolean loadedOffline = true;
    public String perIdx;
    public String custIdx;
    public String accountCode;
    public String title;
    public String firstName;
    public String surname;
    public String dob;
    public String jobTitle;
    public long sendMarketing;
    public String sex;
    public String taxExemptionReasonIdx;
    public String taxExemptionCertificate;
    public boolean guestAccount;
    public String address1;
    public String address2;
    public String city;
    public String state;
    public String postcode;
    public String country;
    public String mainPhone;
    public String mainPhoneError;
    public String workPhone;
    public String otherPhone;
    public String email;
    public String emailError;
    public int emailStatus;
    public JSMap references = new JSMap();
    public JSMap customData = new JSMap();
    public ListWrapper<SummaryItem> summaries = new ListWrapper(new ArrayList());
    public String summaryDateStart;
    public String summaryDateEnd;
    public double summaryTotal;
    public ListWrapper<Transaction> transactions = new ListWrapper(new ArrayList());
    public ListWrapper<RewardsTransaction> rewardRedemptionTransactions = new ListWrapper(new ArrayList());
    public String memIdx;
    public String memName;
    public ListWrapper<Loyalty> loyalties = new ListWrapper(new ArrayList());
    public boolean rewardsAccountPending;
    public boolean rewardsAccountOffline;
    public String rewardsProgramIdx;
    public String rewardsProgramName;
    public String rewardsAccountIdx;
    public String rewardsTierName;
    public double rewardsBalance;
    public Integer rewardsGiftCount;
    public Integer rewardsCouponCount;
    public double rewardsTierMinimumSpend;
    public String rewardsNextTier;
    public long rewardsNextTierQualifySpend;
    public long rewardsSpendToNextTier;
    public long rewardsSpendToRewardTotal;
    public long rewardsSpendToNextReward;
    private Currency rewardsCurrency;

    public Currency getRewardsCurrency() {
        if (this.rewardsCurrency != null) {
            return this.rewardsCurrency;
        }
        return SP.sParams.storeCurrency;
    }

    public boolean isRewardsAndStoreCurrencyEqual() {
        if (this.getRewardsCurrency() == null || SP.sParams.storeCurrency == null) {
            return true;
        }
        return this.getRewardsCurrency().getIdx() == SP.sParams.storeCurrency.getIdx();
    }

    public String formatRewardAmount(double amount) {
        if (this.rewardsCurrency != null) {
            return this.rewardsCurrency.formatTotal(amount);
        }
        return SP.sParams.storeCurrency.formatTotal(amount);
    }

    public String prependRewardCurrencySymbol(String value) {
        if (this.rewardsCurrency != null) {
            return this.rewardsCurrency.prependSymbol(value);
        }
        return SP.sParams.storeCurrency.prependSymbol(value);
    }

    public static void updateContextFromPersonXml(Element person, PersonContext context, PersonAttributes attributes) {
        try {
            context.perIdx = XMLUtils.getValue(person, "peridx");
            context.loadedOffline = !StringUtils.isNullOrEmpty(XMLUtils.getValue(person, "loaded_offline"));
            context.custIdx = XMLUtils.getValue(person, "custidx");
            boolean isAccountCust = false;
            if (!StringUtils.isNullOrEmpty(context.custIdx)) {
                isAccountCust = true;
                for (int i = 0; i < SP.sParams.vMailOrderCustidxs.size(); ++i) {
                    if (!context.custIdx.equals(SP.sParams.vMailOrderCustidxs.elementAt(i))) continue;
                    isAccountCust = false;
                    break;
                }
            }
            context.accountCode = isAccountCust ? XMLUtils.getValue(person, "custcode") : "";
            context.title = XMLUtils.getValue(person, "title");
            context.firstName = XMLUtils.getValue(person, "firstname");
            context.surname = XMLUtils.getValue(person, "surname");
            context.dob = XMLUtils.getValue(person, "dob");
            context.jobTitle = XMLUtils.getValue(person, "jobtitle");
            context.sendMarketing = XMLUtils.getLongValue(person, "privacy");
            context.sex = XMLUtils.getValue(person, "sex");
            context.taxExemptionReasonIdx = XMLUtils.getValue(person, "tax_exemptidx");
            context.taxExemptionCertificate = XMLUtils.getValue(person, "tax_exempt_certificate");
            context.guestAccount = XMLUtils.getLongValue(person, "guest_account") == 1L;
            context.address1 = "";
            context.address2 = "";
            context.city = "";
            context.state = "";
            context.postcode = "";
            context.country = "";
            context.mainPhone = "";
            context.mainPhoneError = "";
            context.workPhone = "";
            context.otherPhone = "";
            context.email = "";
            context.emailError = "";
            context.emailStatus = 0;
            Element locn = person.getChild("locn");
            if (locn != null) {
                context.address1 = XMLUtils.getValue(locn, "adrs1");
                context.address2 = XMLUtils.getValue(locn, "adrs2");
                context.city = XMLUtils.getValue(locn, "city");
                context.state = XMLUtils.getValue(locn, "state");
                context.postcode = XMLUtils.getValue(locn, "postcode");
                context.country = XMLUtils.getValue(locn, "country");
                List phonenums = locn.getChildren("phonenum");
                for (Object child : phonenums) {
                    Element phonenum = (Element)child;
                    int phoneTypeIdx = (int)XMLUtils.getLongValue(phonenum, "phonetyidx");
                    switch (phoneTypeIdx) {
                        case 154: {
                            String error = XMLUtils.getValue(phonenum, "encrypted_state");
                            if (error.isEmpty()) {
                                context.mainPhone = phonenum.getText();
                                break;
                            }
                            context.mainPhoneError = SP.getRS(error);
                            break;
                        }
                        case 631: {
                            context.otherPhone = phonenum.getText();
                            break;
                        }
                        case 536: {
                            context.workPhone = phonenum.getText();
                            break;
                        }
                        case 159: {
                            String error = XMLUtils.getValue(phonenum, "encrypted_state");
                            if (error.isEmpty()) {
                                context.email = phonenum.getText();
                                context.emailStatus = (int)XMLUtils.getLongValue(phonenum, "email_state");
                                break;
                            }
                            context.emailError = SP.getRS(error);
                            break;
                        }
                    }
                }
            }
            context.memIdx = "";
            context.memName = "";
            Element member = person.getChild("member");
            if (member != null) {
                context.memIdx = XMLUtils.getValue(member, "memidx");
                context.memName = XMLUtils.getValue(member, "memname").toUpperCase();
            }
            context.loyalties.getList().clear();
            List loyals = person.getChildren("perloyalty");
            for (int i = 0; i < loyals.size(); ++i) {
                Loyalty loyalty = new Loyalty();
                Reference loyaltyReference = new Reference(((Element)loyals.get(i)).getAttribute("rcidx").getLongValue());
                Vector<String> toks = new Vector<String>();
                Utils.stringTokenize(loyaltyReference.getBlobText(), "\u0003", toks);
                loyalty.loyaltyIdx = loyaltyReference.getIdx();
                loyalty.loyaltyCode = loyaltyReference.getCode();
                if (loyalty.loyaltyIdx == 0L) continue;
                loyalty.cardId = PosUtils.longVal(((Element)loyals.get(i)).getAttribute("loyalidx").getValue());
                loyalty.programName = loyaltyReference.getName();
                boolean bl = loyalty.managerOnly = toks.size() > 6 ? PosUtils.booleanVal(toks.get(6)) : false;
                if (((Element)loyals.get(i)).getAttribute("widx") != null) {
                    loyalty.widx = PosUtils.longVal(((Element)loyals.get(i)).getAttribute("widx").getValue());
                }
                if (((Element)loyals.get(i)).getAttribute("pos_idx") != null) {
                    loyalty.pos_idx = PosUtils.longVal(((Element)loyals.get(i)).getAttribute("pos_idx").getValue());
                }
                if (((Element)loyals.get(i)).getAttribute("expiry") != null && !((Element)loyals.get(i)).getAttribute("expiry").getValue().equals("")) {
                    loyalty.expiryDate.setTimestampInternal(((Element)loyals.get(i)).getAttribute("expiry").getValue());
                    loyalty.expiryDateStr = loyalty.expiryDate.toString();
                } else {
                    loyalty.expiryDateStr = "";
                }
                if (((Element)loyals.get(i)).getAttribute("cardno") != null) {
                    loyalty.cardNumber = ((Element)loyals.get(i)).getAttribute("cardno").getValue();
                }
                if (((Element)loyals.get(i)).getAttribute("ltot") != null) {
                    loyalty.balance = PosUtils.doubleValInternal(((Element)loyals.get(i)).getAttribute("ltot").getValue());
                }
                if (((Element)loyals.get(i)).getAttribute("credit_status") != null) {
                    loyalty.creditStatusBalance = PosUtils.doubleValInternal(((Element)loyals.get(i)).getAttribute("credit_status").getValue());
                }
                context.loyalties.getList().add(loyalty);
            }
            context.references.clear();
            Element referencesElement = person.getChild("references");
            for (int i = 1; i <= 10; ++i) {
                PersonAttributes.ReferenceGroup group = attributes.getReferenceGroup(String.valueOf(i));
                if (group == null) continue;
                context.references.set(String.valueOf(i), XMLUtils.getValue(referencesElement, "ref" + i));
            }
            context.customData.clear();
            Element customDataElement = person.getChild("custom_data");
            for (PersonAttributes.CustomDataTemplate template : attributes.getCustomDataTemplates().getList()) {
                Element templateElement = XMLUtils.getFirstMatchingChild(customDataElement, "template_idx", template.getId());
                for (PersonAttributes.CustomDataField field : template.getFields().getList()) {
                    Element fieldElement = XMLUtils.getFirstMatchingChild(templateElement, "field_idx", field.getId());
                    if ("TagList".equals(field.getType())) {
                        context.customData.setEmpty(field.getId());
                        if (fieldElement == null) continue;
                        List tags = fieldElement.getChildren();
                        for (Object tag : tags) {
                            String idx = XMLUtils.getValue((Element)tag, "idx");
                            if (StringUtils.isNullOrEmpty(idx)) continue;
                            context.customData.add(field.getId(), idx);
                        }
                        continue;
                    }
                    context.customData.set(field.getId(), XMLUtils.getValue(fieldElement, "value"));
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static void updateContextFromHistoryXml(Element root, PersonContext context) {
        try {
            if (root.getChild("summaries") != null) {
                Element total;
                List summaryItems = root.getChild("summaries").getChildren();
                for (int i = 0; i < summaryItems.size(); ++i) {
                    Element summary = (Element)summaryItems.get(i);
                    if (summary.getAttribute("period") == null || summary.getAttribute("spend") == null) continue;
                    context.summaries.getList().add(new SummaryItem(summary.getAttributeValue("period"), XMLUtils.getDoubleValue(summary, "spend")));
                }
                if (root.getChild("total") != null && (total = root.getChild("total")).getAttribute("dateStart") != null && total.getAttribute("dateEnd") != null) {
                    PosDateFormatter formatter = new PosDateFormatter(null, 3, 3, 0);
                    formatter.setTimestampInternal(total.getAttributeValue("dateStart"));
                    context.summaryDateStart = formatter.toString();
                    formatter.setTimestampInternal(total.getAttributeValue("dateEnd"));
                    context.summaryDateEnd = formatter.toString();
                    context.summaryTotal = XMLUtils.getDoubleValue(total, "total");
                }
            }
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    public static void updateContextFromTransactionsXml(Element root, PersonContext context) {
        try {
            Element trans = root.getChild("trans");
            if (trans != null) {
                List details;
                List transactions = trans.getChildren();
                PosDateFormatter dateFormatter = new PosDateFormatter(null);
                if (transactions.size() > 0) {
                    for (int i = 0; i < transactions.size(); ++i) {
                        Element transaction = (Element)transactions.get(i);
                        Transaction tran = new Transaction();
                        if (transaction.getAttribute("trans_number") != null) {
                            tran.transNum = transaction.getAttribute("trans_number").getIntValue();
                        }
                        if (transaction.getAttribute("trans_date") != null) {
                            dateFormatter.setTimestampInternal(transaction.getAttribute("trans_date").getValue());
                            tran.transDate = dateFormatter.toString();
                        }
                        if (transaction.getAttribute("trans_store") != null) {
                            tran.store = transaction.getAttribute("trans_store").getValue();
                        }
                        if (transaction.getAttribute("trans_name") != null) {
                            tran.type = transaction.getAttribute("trans_name").getValue();
                        }
                        if (transaction.getAttribute("trans_total") != null) {
                            tran.total = transaction.getAttribute("trans_total").getDoubleValue();
                        }
                        if (transaction.getAttribute("trans_docket") != null) {
                            tran.docket = transaction.getAttribute("trans_docket").getValue();
                        }
                        if (transaction.getAttribute("tr_type") != null) {
                            tran.trType = transaction.getAttribute("tr_type").getIntValue();
                        }
                        context.transactions.getList().add(tran);
                    }
                }
                if (root.getChild("details") != null && (details = root.getChild("details").getChildren()).size() > 0) {
                    for (int i = 0; i < details.size(); ++i) {
                        Element detail = (Element)details.get(i);
                        TransDetail det = new TransDetail();
                        if (detail.getAttribute("vhidx") != null) {
                            det.vhidx = detail.getAttribute("vhidx").getIntValue();
                        }
                        if (detail.getAttribute("vshidx") != null) {
                            det.vshidx = detail.getAttribute("vshidx").getIntValue();
                        }
                        if (detail.getAttribute("sku") != null) {
                            det.sku = detail.getAttribute("sku").getValue();
                        }
                        if (detail.getAttribute("description") != null) {
                            det.description = detail.getAttribute("description").getValue();
                        }
                        if (detail.getAttribute("qty") != null) {
                            det.qty = detail.getAttribute("qty").getIntValue();
                        }
                        if (detail.getAttribute("net") != null) {
                            det.net = detail.getAttribute("net").getDoubleValue();
                        }
                        int index = PersonContext.getTransactionIndex(det.vhidx, context);
                        if (det.vhidx == 0 || index == -1) continue;
                        context.transactions.get((int)index).details.getList().add(det);
                    }
                }
            }
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    public static void updateContextFromRewardsAccount(RewardsAccount rewardsAccount, PersonContext context) {
        context.rewardsAccountPending = rewardsAccount.getAccountState() == RewardsAccount.AccountState.PENDING_OFFLINE;
        context.rewardsAccountOffline = rewardsAccount.getAccountState() == RewardsAccount.AccountState.LOADED_OFFLINE;
        context.rewardsProgramIdx = rewardsAccount.getRewardsProgram().getId() != 0L ? String.valueOf(rewardsAccount.getRewardsProgram().getId()) : "";
        context.rewardsProgramName = rewardsAccount.getRewardsProgram().toString();
        context.rewardsAccountIdx = String.valueOf(rewardsAccount.getAccountId());
        context.rewardsTierName = rewardsAccount.getCurrentTier().toString();
        context.rewardsNextTier = rewardsAccount.getNextTier().toString();
        context.rewardsBalance = rewardsAccount.getCurrentRewardsBalance();
        Integer n = context.rewardsGiftCount = rewardsAccount.getAvailableGifts().size() > 0 ? Integer.valueOf(rewardsAccount.getAvailableGifts().size()) : null;
        if (rewardsAccount.getAvailableCoupons() != null) {
            context.rewardsCouponCount = rewardsAccount.getAvailableCoupons().size() > 0 ? Integer.valueOf(rewardsAccount.getAvailableCoupons().size()) : null;
        }
        context.rewardsTierMinimumSpend = rewardsAccount.getCurrentTierMinimumSpend();
        context.rewardsNextTierQualifySpend = Math.round(rewardsAccount.getNextTierQualifySpend());
        context.rewardsSpendToNextTier = Math.max(0L, Math.round(rewardsAccount.getSpendToNextTier()));
        context.rewardsSpendToRewardTotal = Math.round(rewardsAccount.getSpendToRewardTotal());
        context.rewardsSpendToNextReward = Math.max(0L, Math.round(rewardsAccount.getSpendToNextReward()));
        context.rewardsCurrency = rewardsAccount.getRewardsProgram().getCurrency();
    }

    public static void updateContextFromRedemptionHistoryXml(Element root, PersonContext context) {
        try {
            if (root != null) {
                List redemptionElementsList = root.getChildren("redemption");
                PosDateFormatter dateFormatter = new PosDateFormatter(null);
                if (redemptionElementsList.size() > 0) {
                    for (int i = 0; i < redemptionElementsList.size(); ++i) {
                        Element redemptionElement = (Element)redemptionElementsList.get(i);
                        RewardsTransaction redemptionTransaction = new RewardsTransaction();
                        redemptionTransaction.children = new ListWrapper(new ArrayList());
                        redemptionTransaction.id = XMLUtils.getValue(redemptionElement, "id");
                        if (redemptionElement.getAttribute("date") != null) {
                            dateFormatter.setTimestampInternal(redemptionElement.getAttribute("date").getValue());
                            redemptionTransaction.transDate = dateFormatter.toString();
                        }
                        redemptionTransaction.store = XMLUtils.getValue(redemptionElement, "store");
                        redemptionTransaction.amount = XMLUtils.getDoubleValue(redemptionElement, "amount");
                        redemptionTransaction.description = XMLUtils.getValue(redemptionElement, "description");
                        redemptionTransaction.reference = XMLUtils.getValue(redemptionElement, "reference");
                        List reissueElements = redemptionElement.getChildren("reissue");
                        if (reissueElements.size() > 0) {
                            for (int k = 0; k < reissueElements.size(); ++k) {
                                Element reissueElement = (Element)reissueElements.get(k);
                                RewardsTransaction reissueTransaction = new RewardsTransaction();
                                reissueTransaction.id = XMLUtils.getValue(reissueElement, "id");
                                if (reissueElement.getAttribute("date") != null) {
                                    dateFormatter.setTimestampInternal(reissueElement.getAttribute("date").getValue());
                                    reissueTransaction.transDate = dateFormatter.toString();
                                }
                                reissueTransaction.store = XMLUtils.getValue(reissueElement, "store");
                                reissueTransaction.amount = XMLUtils.getDoubleValue(reissueElement, "amount");
                                reissueTransaction.description = XMLUtils.getValue(reissueElement, "description");
                                reissueTransaction.reference = XMLUtils.getValue(reissueElement, "reference");
                                redemptionTransaction.children.getList().add(reissueTransaction);
                            }
                        }
                        context.rewardRedemptionTransactions.getList().add(redemptionTransaction);
                    }
                }
            }
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private static int getTransactionIndex(int vhidx, PersonContext context) {
        for (int i = 0; i < context.transactions.size(); ++i) {
            if (context.transactions.get((int)i).transNum != vhidx) continue;
            return i;
        }
        return -1;
    }

    @JsAccessible
    public static class Loyalty {
        public long loyaltyIdx = 0L;
        public String loyaltyCode = "";
        public long cardId = 0L;
        public String programName;
        public String cardNumber = "";
        public PosDateFormatter expiryDate = new PosDateFormatter(null, 3, 3, 0);
        public String expiryDateStr;
        public double balance = 0.0;
        public double creditStatusBalance = 0.0;
        public boolean managerOnly = false;
        public long widx = 0L;
        public long pos_idx = 0L;
    }

    @JsAccessible
    public static class RewardsTransaction {
        public String id;
        public String transDate;
        public String store;
        public double amount;
        public String description;
        public String reference;
        public ListWrapper<RewardsTransaction> children;
    }

    @JsAccessible
    public static class TransDetail {
        public int vhidx;
        public int vshidx;
        public String sku;
        public String description;
        public int qty;
        public double net;
    }

    @JsAccessible
    public static class Transaction {
        public int transNum;
        public String transDate;
        public String store;
        public String type;
        public double total;
        public String docket;
        public int trType;
        public ListWrapper<TransDetail> details = new ListWrapper(new ArrayList());
    }

    @JsAccessible
    public static class SummaryItem {
        public String desc;
        public double spend;

        public SummaryItem(String desc, double spend) {
            this.desc = desc;
            this.spend = spend;
        }
    }
}

