/*
 * Decompiled with CFR 0.152.
 */
package jpos.pointspartner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StringUtils;
import jpos.pointspartner.IMembershipStrategy;
import jpos.ui.DialogButton;
import jpos.ui.Fonts;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextArea;
import jpos.ui.TouchTextField;

public class DlgMembershipNumber
extends PosDialog {
    public static final int DEFAULT_MAX_VISIBLE_LIST_LENGTH = 5;
    private static final String TEXT_OK = SP.getRS("ok");
    private static final String TEXT_SKIP = SP.getRS("Skip");
    private IMembershipStrategy strategy;
    private String label;
    private String partnerList;
    protected static final int PAD0 = 0;
    protected static final int PAD1 = 5;
    protected static final int PAD2 = 10;
    protected static final int PAD3 = 20;
    private JPanel panel = new JPanel();
    private LabelSubHeading lMembershipPrompt = new LabelSubHeading();
    private TouchTextField tfMembershipNum = new TouchTextField();
    private TouchTextArea taPrograms = new TouchTextArea();
    private DialogButton bOk = new DialogButton("", this);

    public DlgMembershipNumber(PosFrame frame, String title, String label, IMembershipStrategy strategy, String partnerList) {
        super(frame, title, true);
        this.strategy = strategy;
        this.label = label;
        this.partnerList = partnerList;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panel.setLayout(new GridBagLayout());
        this.lMembershipPrompt.setText(this.label);
        this.tfMembershipNum.setHorizontalAlignment(2);
        this.tfMembershipNum.setFieldWidth(300);
        this.tfMembershipNum.setHint(SP.getRS("points_partner_prompt_hint"));
        this.getContentPane().add((Component)this.panel, "Center");
        this.tfMembershipNum.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DlgMembershipNumber.this.setButtonText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DlgMembershipNumber.this.setButtonText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DlgMembershipNumber.this.setButtonText();
            }
        });
        this.taPrograms.setEditable(false);
        this.taPrograms.setFocusable(false);
        this.taPrograms.setFont(Fonts.SmallPlainText);
        this.taPrograms.setBackground(UIManager.getColor("Panel.background"));
        this.taPrograms.setLineWrap(true);
        this.taPrograms.setWrapStyleWord(true);
        this.taPrograms.setText(this.partnerList);
        this.setButtonText();
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgMembershipNumber.this.okDialog();
            }
        });
        this.panel.add((Component)this.lMembershipPrompt, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 20, 5, 20), 0, 0));
        this.panel.add((Component)this.tfMembershipNum, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 20, 5, 20), 0, 0));
        if (!StringUtils.isNullOrEmpty(this.partnerList)) {
            this.panel.add((Component)this.taPrograms, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 5, 20), 0, 0));
        }
        this.panel.add((Component)this.bOk, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 15, 0, new Insets(5, 20, 10, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfMembershipNum);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        if (!StringUtils.isNullOrEmpty(this.partnerList)) {
            this.pack();
        }
        PosUtils.centreWindow(this);
    }

    private void setButtonText() {
        if (this.tfMembershipNum.getText().isEmpty()) {
            this.bOk.setText(TEXT_SKIP);
        } else {
            this.bOk.setText(TEXT_OK);
        }
    }

    @Override
    public void cancelDialog() {
        this.setVisible(false);
    }

    @Override
    public void okDialog() {
        String membershipNum;
        if (this.strategy != null && (membershipNum = this.tfMembershipNum.getText()) != null && membershipNum.length() > 0) {
            StringBuilder message = new StringBuilder();
            boolean success = this.strategy.setMembership(null, membershipNum, message);
            if (!success) {
                this.frParent.paHead.showErrorMessage(message.toString());
                this.tfMembershipNum.setText("");
                return;
            }
            this.frParent.paHead.showSuccessMessage(message.toString());
        }
        this.setVisible(false);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

