/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import jpos.SP;
import jpos.XMLUtils;
import jpos.rewards.GiftSku;
import jpos.rewards.RewardsAccount;
import org.jdom.Element;

class RetailRewardsApi {
    private RewardsAccount rewardsAccount;
    private String lastError;

    protected RetailRewardsApi() {
    }

    protected boolean requestBalance(long peridx) {
        return this.loadAccount(peridx);
    }

    protected boolean loadAccount(long peridx) {
        if (!this.checkOnlineStatus()) {
            this.rewardsAccount = new RewardsAccount();
            return this.rewardsAccount.loadOffline(peridx);
        }
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("rewards_account_summary", String.format("%s,%s", SP.sParams.getStoreIdx(), String.valueOf(peridx))).getXML();
        if (response != null) {
            String result = XMLUtils.getValue(response, "result");
            if (result.equals("true")) {
                this.rewardsAccount = new RewardsAccount();
                this.rewardsAccount.loadFromXml(peridx, response);
                return true;
            }
            this.lastError = XMLUtils.getValue(response, "message");
            return false;
        }
        return false;
    }

    protected boolean requestRedeem(long peridx, long staffId, String requestId, Double amount, GiftSku giftSku) {
        if (!this.checkOnlineStatus()) {
            return false;
        }
        String giftIdx = giftSku != null && giftSku.getGift() != null ? String.valueOf(giftSku.getGift().getGiftId()) : "";
        String redeemedSkuIdx = giftSku != null ? String.valueOf(giftSku.getSkuidx()) : "";
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("rewards_redemption_request", String.format("%s,%s,%s,%s,%s,%s,%s", SP.sParams.getStoreIdx(), String.valueOf(peridx), requestId, amount.toString(), String.valueOf(staffId), giftIdx, redeemedSkuIdx)).getXML();
        if (response != null) {
            String result = XMLUtils.getValue(response, "result");
            String message = XMLUtils.getValue(response, "message");
            if (result.equals("true")) {
                return true;
            }
            this.lastError = message;
            return false;
        }
        return false;
    }

    protected boolean requestReverse(long peridx, String requestId) {
        if (!this.checkOnlineStatus()) {
            return false;
        }
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("rewards_redemption_cancel", String.format("%s,%s,%s", SP.sParams.getStoreIdx(), String.valueOf(peridx), requestId)).getXML();
        if (response != null) {
            String result = XMLUtils.getValue(response, "result");
            String message = XMLUtils.getValue(response, "message");
            if (result.equals("true")) {
                return true;
            }
            this.lastError = message;
            return false;
        }
        return false;
    }

    protected boolean requestConfirm(long peridx, String requestId) {
        if (!this.checkOnlineStatus()) {
            return false;
        }
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("rewards_redemption_confirm", String.format("%s,%s,%s", SP.sParams.getStoreIdx(), String.valueOf(peridx), requestId)).getXML();
        if (response != null) {
            String result = XMLUtils.getValue(response, "result");
            String message = XMLUtils.getValue(response, "message");
            if (result.equals("true")) {
                return true;
            }
            this.lastError = message;
            return false;
        }
        return false;
    }

    public boolean signUp(long peridx, long programId, long staffId) {
        if (!this.checkOnlineStatus()) {
            this.rewardsAccount = new RewardsAccount();
            return this.rewardsAccount.signUpOffline(peridx, programId, staffId);
        }
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("rewards_program_sign_up", String.format("%s,%s,%s,%s", SP.sParams.getStoreIdx(), String.valueOf(peridx), String.valueOf(programId), String.valueOf(staffId))).getXML();
        if (response != null) {
            String result = XMLUtils.getValue(response, "result");
            String message = XMLUtils.getValue(response, "message");
            if (result.equals("true") && response.getChild("rewards_account") != null) {
                this.rewardsAccount = new RewardsAccount();
                this.rewardsAccount.loadFromXml(peridx, response.getChild("rewards_account"));
                this.rewardsAccount.activateAccountLocally();
                return true;
            }
            this.lastError = message;
            return false;
        }
        return false;
    }

    protected double getBalance() {
        if (this.rewardsAccount != null) {
            return this.rewardsAccount.getCurrentRewardsBalance();
        }
        return 0.0;
    }

    protected double getCurrentTierMinimumSpend() {
        if (this.rewardsAccount != null) {
            return this.rewardsAccount.getCurrentTierMinimumSpend();
        }
        return 0.0;
    }

    protected long getAccountId() {
        if (this.rewardsAccount != null) {
            return this.rewardsAccount.getAccountId();
        }
        return 0L;
    }

    protected String getLastError() {
        return this.lastError;
    }

    private boolean checkOnlineStatus() {
        if (!SP.sParams.checkIConn()) {
            this.lastError = SP.getRS("Rewards_Offline");
            return false;
        }
        return true;
    }

    public RewardsAccount getAccount() {
        return this.rewardsAccount;
    }
}

