/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.awt.Color;
import java.text.MessageFormat;
import java.text.NumberFormat;
import jpos.SP;
import jpos.rewards.RewardsAccount;
import jpos.ui.CircularProgressBar;
import jpos.ui.Colours;

public class RewardsProgressBar
extends CircularProgressBar {
    private DisplayType displayType;
    private static String tierProgressText = String.format("<html>%s</html>", SP.getRS("Rewards_Progress_Next_Tier_Html"));
    private static String rewardProgressText = String.format("<html>%s</html>", SP.getRS("Rewards_Progress_Next_Reward_Html"));

    public RewardsProgressBar(DisplayType displayType) {
        this.displayType = displayType;
        this.init();
    }

    private void init() {
        this.setBarColors(new Color[]{Colours.PROGRESS_GREEN, Colours.PROGRESS_LIGHT_GREEN});
    }

    public boolean updateProgressBar(RewardsAccount rewardsAccount, double currentSaleTotal, boolean pointsCapped) {
        int saleTotal = (int)Math.round(currentSaleTotal);
        if (rewardsAccount != null && rewardsAccount.getAccountState() == RewardsAccount.AccountState.LOADED_ONLINE) {
            int tierQualifySpend = (int)Math.round(rewardsAccount.getNextTierQualifySpend());
            int spendToNextTier = Math.max(0, (int)Math.round(rewardsAccount.getSpendToNextTier()));
            int tierProgress = tierQualifySpend - spendToNextTier;
            int spendToRewardTotal = (int)Math.round(rewardsAccount.getSpendToRewardTotal());
            int spendToNextReward = Math.max(0, (int)Math.round(rewardsAccount.getSpendToNextReward()));
            int rewardProgress = spendToRewardTotal - spendToNextReward;
            DisplayType finalDisplay = DisplayType.NONE;
            if (this.displayType == DisplayType.NEAREST_MILESTONE) {
                if (tierQualifySpend > 0 && rewardsAccount.getNextTier().getId() > 0L && (spendToNextTier <= spendToNextReward || spendToRewardTotal <= 0)) {
                    finalDisplay = DisplayType.NEXT_TIER;
                } else if (spendToRewardTotal > 0) {
                    finalDisplay = DisplayType.NEXT_REWARD;
                }
            } else if (this.displayType == DisplayType.NEXT_TIER && tierQualifySpend > 0 && rewardsAccount.getNextTier().getId() > 0L) {
                finalDisplay = DisplayType.NEXT_TIER;
            } else if (this.displayType == DisplayType.NEXT_REWARD && spendToRewardTotal > 0) {
                finalDisplay = DisplayType.NEXT_REWARD;
            }
            if (finalDisplay == DisplayType.NEXT_TIER) {
                this.setRange(0, tierQualifySpend);
                String value = pointsCapped ? "--" : NumberFormat.getInstance().format(Math.max(0, spendToNextTier - saleTotal));
                this.updateProgress(new int[]{tierProgress, saleTotal}, MessageFormat.format(tierProgressText, rewardsAccount.getRewardsProgram().getCurrency().prependSymbol(value), rewardsAccount.getNextTier().getName()));
                return true;
            }
            if (finalDisplay == DisplayType.NEXT_REWARD) {
                this.setRange(0, spendToRewardTotal);
                String value = pointsCapped ? "--" : NumberFormat.getInstance().format(Math.max(0, spendToNextReward - saleTotal));
                this.updateProgress(new int[]{rewardProgress, saleTotal}, MessageFormat.format(rewardProgressText, rewardsAccount.getRewardsProgram().getCurrency().prependSymbol(value)));
                return true;
            }
        }
        return false;
    }

    public static enum DisplayType {
        NONE,
        NEXT_TIER,
        NEXT_REWARD,
        NEAREST_MILESTONE;

    }
}

