/*
 * Decompiled with CFR 0.152.
 */
package jpos.tillbalance;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.Tender;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.pay.PayType;
import jpos.pay.PayTypes;
import jpos.tillbalance.ComponentKeyEventHelper;
import jpos.tillbalance.Denomination;
import jpos.tillbalance.DlgTillBalanceCount;
import jpos.tillbalance.DlgTillBalanceFloat;
import jpos.tillbalance.FrTillBalance;
import jpos.tillbalance.TenDets;
import jpos.ui.Colours;
import jpos.ui.FormButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import org.jdom.Element;

public class PaTillBalance
extends JPanel {
    private static final int TENDER_CODE_COLUMN = 0;
    private static final int EXPECTED_COLUMN = 1;
    private static final int COUNTED_COLUMN = 2;
    private static final int VARIANCE_COLUMN = 3;
    private static final int COUNT_BUTTON_COLUMN = 4;
    private static final int COL_COUNT = 5;
    private static final String sTENDER = SP.getRS("tender");
    private static final String sEXPECTED = SP.getRS("Expected");
    private static final String sCOUNTED = SP.getRS("Counted");
    private static final String sVARIANCE = SP.getRS("Variance");
    private static final String sCOUNT_BUTTON = SP.getRS("Count");
    private static final int MAX_COLUMN_WIDTH = 700;
    private static final int MIN_COLUMN_WIDTH = 95;
    private static final int PREFERRED_COLUMN_WIDTH = 200;
    private static final String sTendersTableStatusMessage = SP.getRS("tenders_table_status_message");
    private boolean bEditable = false;
    private boolean bShowingVariances = false;
    protected PosTable tblTenders;
    private TotalsTable tblTotals;
    ImageIcon countIcon;
    ImageIcon disabledCountIcon;
    private Vector<Denomination> vDenom = new Vector();
    private TenderTableModel tendersModel;
    private StoreParams sParams;
    private PosFrame frParent;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    protected LabelSubHeading lFeedBack = new LabelSubHeading();
    private LabelSubHeading lFloat = new LabelSubHeading();
    private LabelSubHeading lBank = new LabelSubHeading();
    private LabelSubHeading lBankBagNumber = new LabelSubHeading();
    private DecimalField tfFloat;
    protected DecimalField tfBank;
    protected TouchTextField tfBankBagNumber;
    protected FormButton bChangeFloat = new FormButton(StoreParams.res.getString("Change_float_descrip"));

    public PaTillBalance(StoreParams psParams, PosFrame pfrParent) {
        try {
            this.frParent = pfrParent;
            this.sParams = psParams;
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void setTot() {
        double nCash = 0.0;
        for (int i = 0; i < this.tendersModel.data.size(); ++i) {
            if (!this.tendersModel.data.elementAt((int)i).payType.isCash) continue;
            nCash = this.tendersModel.data.elementAt((int)i).nCounted;
            break;
        }
        if (this.tfFloat.getDouble() < this.sParams.EODFloat || nCash < this.sParams.EODFloat || this.tfFloat.getDouble() > nCash) {
            if (this.sParams.EODFloat > nCash) {
                this.tfFloat.setText(nCash);
            } else {
                this.tfFloat.setText(this.sParams.EODFloat);
            }
        }
        this.tfBank.setText(nCash - this.tfFloat.getDouble());
    }

    protected void db_updateVariances(boolean postVar) throws Exception {
        try {
            Throwable throwable;
            Object stmt;
            Object stmt2;
            String sMaxCashTbidx;
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT MAX(TBIDX) FROM TILL_BALANCES WHERE TYPEIDX = " + SP.getCashPayType() + " AND TILL_NUMBER = " + PosUtils.StringToSqlString(this.sParams.tillnum));){
                sMaxCashTbidx = sql.next() && sql.getString(1) != null ? " = " + sql.getString(1) : "IS NULL";
            }
            TenDets tdCash = null;
            for (int i = 0; i < this.tendersModel.data.size(); ++i) {
                if (!this.tendersModel.data.elementAt((int)i).payType.isCash) continue;
                tdCash = this.tendersModel.data.elementAt(i);
                break;
            }
            if (tdCash == null) {
                throw new Exception("No cash tender is setup");
            }
            String sInsertCash = "INSERT INTO TILL_BALANCES(TYPEIDX, TILL_NUMBER, BALANCE, FLOATAMT, VARIANCE, BANKED, UPDT, TBIDX, DOCKET_NUMBER, LAST_FLOAT, LAST_BALANCE, LAST_UPDT) SELECT " + tdCash.payType.idx + ", " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", " + tdCash.nCounted + ", " + this.tfFloat.getDouble() + ", " + tdCash.getVariance() + ", " + this.tfBank.getDouble() + ",  CURRENT_TIMESTAMP, " + this.sParams.nextVal("XTILL_BALANCES") + ", " + PosUtils.StringToSqlString(this.frParent.docknum) + ", T.FLOATAMT, T.BALANCE, T.UPDT FROM RET_TRANH H LEFT JOIN TILL_BALANCES T ON T.TBIDX " + sMaxCashTbidx + " WHERE H.DOCKET_NUMBER = " + PosUtils.StringToSqlString(this.frParent.docknum) + " AND H.WIDX = " + this.sParams.getStoreIdx();
            try (Statement stmt3 = this.sParams.conn.createStatement();){
                stmt3.executeUpdate(sInsertCash);
            }
            for (int i = 0; i < tdCash.data.size(); ++i) {
                if (((Denomination)tdCash.data.elementAt((int)i)).nCount <= 0) continue;
                stmt2 = this.sParams.conn.createStatement();
                Throwable throwable2 = null;
                try {
                    stmt2.executeUpdate("INSERT INTO TENDER_BALANCES(TBIDX, \"VALUE\", \"COUNT\") VALUES (" + this.sParams.currVal("XTILL_BALANCES") + ", " + ((Denomination)tdCash.data.elementAt((int)i)).nValue + ", " + ((Denomination)tdCash.data.elementAt((int)i)).nCount + ")");
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (stmt2 != null) {
                        if (throwable2 != null) {
                            try {
                                stmt2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            stmt2.close();
                        }
                    }
                }
            }
            if (tdCash.getVariance() != 0.0 && postVar) {
                Tender varTender = new Tender(tdCash.payType.idx, tdCash.getVariance(), this.sParams);
                varTender.db_insert_tender();
            }
            stmt = this.sParams.conn.createStatement();
            stmt2 = null;
            try {
                stmt.executeUpdate("INSERT INTO RET_TRAND(VSHIDX, VHIDX, \"ACTIVE\", LINE_CODE, NET, SEQUENCE_NUMBER, LINE_TYPE, STKFLAG, PRICE, DISCOUNT) SELECT " + this.sParams.nextVal("XRET_TRAND") + ", " + this.sParams.currVal("XRET_TRANH") + ", 1, " + tdCash.payType.idx + ", " + tdCash.nCounted + ", COALESCE(MAX(SEQUENCE_NUMBER), -1) + 1, 10, 0, " + this.tfFloat.getDouble() + ", " + this.tfBank.getDouble() + " FROM RET_TRAND WHERE VHIDX = " + this.sParams.currVal("XRET_TRANH") + "");
            }
            catch (Throwable throwable5) {
                stmt2 = throwable5;
                throw throwable5;
            }
            finally {
                if (stmt != null) {
                    if (stmt2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable6) {
                            ((Throwable)stmt2).addSuppressed(throwable6);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            TenDets tdOther = null;
            for (int i = 0; i < this.tendersModel.data.size(); ++i) {
                String sMaxOtherTbidx;
                tdOther = this.tendersModel.data.elementAt(i);
                if (!tdOther.payType.isTillCounting() || tdOther.payType.isCash) continue;
                try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT MAX(TBIDX) FROM TILL_BALANCES WHERE TYPEIDX = " + tdOther.payType.idx + " AND TILL_NUMBER = " + PosUtils.StringToSqlString(this.sParams.tillnum));){
                    sMaxOtherTbidx = sql.next() && sql.getString(1) != null ? " = " + sql.getString(1) : "IS NULL";
                }
                var9_32 = null;
                try (Statement stmt4 = this.sParams.conn.createStatement();){
                    stmt4.executeUpdate("INSERT INTO TILL_BALANCES(TYPEIDX, TILL_NUMBER, BALANCE, FLOATAMT, VARIANCE, BANKED, UPDT, TBIDX, DOCKET_NUMBER, LAST_FLOAT, LAST_BALANCE, LAST_UPDT) SELECT " + tdOther.payType.idx + ", " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", " + tdOther.nCounted + ", 0, " + tdOther.getVariance() + ", " + tdOther.nCounted + ",  CURRENT_TIMESTAMP, " + this.sParams.nextVal("XTILL_BALANCES") + ", " + PosUtils.StringToSqlString(this.frParent.docknum) + ", T.FLOATAMT, T.BALANCE, T.UPDT FROM RET_TRANH H LEFT JOIN TILL_BALANCES T ON T.TBIDX " + sMaxOtherTbidx + " WHERE H.DOCKET_NUMBER = " + PosUtils.StringToSqlString(this.frParent.docknum) + " AND H.WIDX = " + this.sParams.getStoreIdx());
                }
                catch (Throwable throwable7) {
                    var9_32 = throwable7;
                    throw throwable7;
                }
                for (int j = 0; j < tdOther.data.size(); ++j) {
                    if (((PosDouble)tdOther.data.elementAt(j)).doubleValue() == 0.0) continue;
                    stmt = this.sParams.conn.createStatement();
                    throwable = null;
                    try {
                        stmt.executeUpdate("INSERT INTO TENDER_BALANCES(TBIDX, \"VALUE\", \"COUNT\") VALUES (" + this.sParams.currVal("XTILL_BALANCES") + ", " + ((PosDouble)tdOther.data.elementAt(j)).doubleValue() + ", 1)");
                        continue;
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (stmt != null) {
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                if (tdOther.getVariance() != 0.0 && postVar) {
                    Tender varTender = new Tender(tdOther.payType.idx, tdOther.getVariance(), this.sParams);
                    varTender.db_insert_tender();
                }
                stmt4 = this.sParams.conn.createStatement();
                stmt = null;
                try {
                    stmt4.executeUpdate("INSERT INTO RET_TRAND(VSHIDX, VHIDX, \"ACTIVE\", LINE_CODE, NET, SEQUENCE_NUMBER, LINE_TYPE, STKFLAG, PRICE, DISCOUNT) SELECT " + this.sParams.nextVal("XRET_TRAND") + ", " + this.sParams.currVal("XRET_TRANH") + ", 1, " + tdOther.payType.idx + ", " + tdOther.nCounted + ", COALESCE(MAX(SEQUENCE_NUMBER), -1)+1, 10, 0, 0, " + tdOther.nCounted + " FROM RET_TRAND WHERE VHIDX = " + this.sParams.currVal("XRET_TRANH") + "");
                    continue;
                }
                catch (Throwable throwable10) {
                    stmt = throwable10;
                    throw throwable10;
                }
                finally {
                    if (stmt4 != null) {
                        if (stmt != null) {
                            try {
                                stmt4.close();
                            }
                            catch (Throwable throwable11) {
                                ((Throwable)stmt).addSuppressed(throwable11);
                            }
                        } else {
                            stmt4.close();
                        }
                    }
                }
            }
            TenDets tdNonCounted = null;
            for (int i = 0; i < this.tendersModel.data.size(); ++i) {
                tdNonCounted = this.tendersModel.data.elementAt(i);
                if (tdNonCounted.payType.isTillCounting() || tdNonCounted.payType.isCash) continue;
                stmt = this.sParams.conn.createStatement();
                throwable = null;
                try {
                    stmt.executeUpdate("INSERT INTO RET_TRAND(VSHIDX, VHIDX, \"ACTIVE\", LINE_CODE, NET, SEQUENCE_NUMBER, LINE_TYPE, STKFLAG, PRICE, DISCOUNT) SELECT " + this.sParams.nextVal("XRET_TRAND") + ", " + this.sParams.currVal("XRET_TRANH") + ", 1, " + tdNonCounted.payType.idx + ", " + tdNonCounted.nExpected + ", COALESCE(MAX(SEQUENCE_NUMBER), -1)+1, 10, 0, 0, 0 FROM RET_TRAND WHERE VHIDX = " + this.sParams.currVal("XRET_TRANH") + "");
                    continue;
                }
                catch (Throwable throwable12) {
                    throwable = throwable12;
                    throw throwable12;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable13) {
                                throwable.addSuppressed(throwable13);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    protected void load() {
        this.populateDenominations();
        try (PreparedStatement psCount = SP.sParams.conn.prepareStatement("SELECT SUM(PAYMENT_AMOUNT) FROM RET_TRANP P, RET_TRANH H WHERE P.PAYMENT_TYPEIDX = ? AND H.VHIDX = P.VHIDX AND H.COMPLETE IN (1, 4) AND H.TILL_NUMBER = ? AND H.DOCKET_NUMBER IS NOT NULL AND P.\"ACTIVE\" = 1 AND H.\"ACTIVE\" = 1");
             PreparedStatement psFloat = SP.sParams.conn.prepareStatement("SELECT FLOATAMT FROM TILL_BALANCES WHERE TYPEIDX = ? AND TILL_NUMBER = ? ORDER BY UPDT DESC");){
            this.tendersModel.data.clear();
            double nTenTotal = 0.0;
            for (int i = 0; i < PayTypes.vSalePayTypes.size(); ++i) {
                TenDets d = new TenDets(PayTypes.vSalePayTypes.elementAt(i));
                if (d.payType.isEftposWltPay) continue;
                if (d.payType.isCash) {
                    for (int j = 0; j < this.vDenom.size(); ++j) {
                        d.data.add(this.vDenom.elementAt(j));
                    }
                }
                nTenTotal = 0.0;
                psCount.setLong(1, d.payType.idx);
                psCount.setString(2, this.sParams.tillnum);
                try (ResultSet rs = psCount.executeQuery();){
                    if (rs.next()) {
                        nTenTotal = rs.getDouble(1);
                    }
                }
                if (d.payType.isTillCounting()) {
                    psFloat.setLong(1, d.payType.idx);
                    psFloat.setString(2, this.sParams.tillnum);
                    rs = psFloat.executeQuery();
                    var10_18 = null;
                    try {
                        if (rs.next()) {
                            nTenTotal += rs.getDouble(1);
                        }
                    }
                    catch (Throwable throwable) {
                        var10_18 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var10_18 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var10_18.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    d.nExpected = nTenTotal;
                    d.nCounted = 0.0;
                } else {
                    d.nCounted = d.nExpected = nTenTotal;
                }
                this.tendersModel.data.add(d);
            }
            this.tendersModel.fireTableDataChanged();
            if (this.tblTenders.getRowCount() > 0) {
                this.selectNextCountableTender(-1);
            }
            try (Statement stmt = this.sParams.getStmt();){
                stmt.executeUpdate("UPDATE RET_TRANH SET COMPLETE = 4 WHERE COMPLETE = 1 AND TILL_NUMBER = " + PosUtils.StringToSqlString(this.sParams.tillnum));
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        this.setTot();
        this.lFeedBack.setText("");
    }

    private void tblInit() {
        this.countIcon = new ImageIcon(SP.sParams.imagepath + "count.png");
        this.disabledCountIcon = new ImageIcon(SP.sParams.imagepath + "count_disabled.png");
        this.tblTenders.setSelectionMode(0);
        this.tblTenders.getColumnModel().getColumn(0).setHeaderRenderer(this.tblTenders.headerLeftRen);
        this.tblTenders.getColumnModel().getColumn(1).setHeaderRenderer(this.tblTenders.headerRightRen);
        this.tblTenders.getColumnModel().getColumn(2).setHeaderRenderer(this.tblTenders.headerRightRen);
        this.tblTenders.getColumnModel().getColumn(3).setHeaderRenderer(this.tblTenders.headerRightRen);
        this.tblTenders.getColumnModel().getColumn(4).setHeaderRenderer(this.tblTenders.headerCenterRen);
        this.tblTenders.renderer.setColumnFormat(1, this.sParams.currFormat, 4);
        this.tblTenders.renderer.setColumnFormat(2, this.sParams.currFormat, 4);
        this.tblTenders.renderer.setColumnFormat(3, this.sParams.currFormat, 4);
        this.setColumnSizes(true);
    }

    private void setColumnSizes(boolean showVariance) {
        this.tblTenders.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.tblTenders.getColumnModel().getColumn(0).setMinWidth(95);
        this.tblTenders.getColumnModel().getColumn(0).setMaxWidth(700);
        this.tblTenders.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.tblTenders.getColumnModel().getColumn(2).setMinWidth(95);
        this.tblTenders.getColumnModel().getColumn(2).setMaxWidth(700);
        this.tblTenders.getColumnModel().getColumn(1).setPreferredWidth(showVariance ? 200 : 0);
        this.tblTenders.getColumnModel().getColumn(1).setMinWidth(showVariance ? 95 : 0);
        this.tblTenders.getColumnModel().getColumn(1).setMaxWidth(showVariance ? 700 : 0);
        this.tblTenders.getColumnModel().getColumn(3).setPreferredWidth(showVariance ? 200 : 0);
        this.tblTenders.getColumnModel().getColumn(3).setMinWidth(showVariance ? 95 : 0);
        this.tblTenders.getColumnModel().getColumn(3).setMaxWidth(showVariance ? 700 : 0);
        this.tblTenders.getColumnModel().getColumn(4).setPreferredWidth(95);
        this.tblTenders.getColumnModel().getColumn(4).setMinWidth(95);
        this.tblTenders.getColumnModel().getColumn(4).setMaxWidth(95);
    }

    private void jbInit() throws Exception {
        this.tfFloat = new DecimalField(this.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.tfFloat.setForeground(Colours.RED);
        this.tfFloat.setEnabled(false);
        this.tfFloat.setFieldWidth(140);
        this.tfBank = new DecimalField(this.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.tfBank.setEnabled(false);
        this.tfBank.setFieldWidth(140);
        this.tfBankBagNumber = new TouchTextField(TouchTextField.FontSize.LARGE);
        this.tfBankBagNumber.setFieldWidth(250);
        this.lFloat.setText(StoreParams.res.getString("Float"));
        this.lBank.setText(StoreParams.res.getString("Cash_to_bank"));
        this.lBankBagNumber.setText(StoreParams.res.getString("Bank_Bag_Number"));
        this.bChangeFloat.setText(SP.getRS("Change_float"));
        this.bChangeFloat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaTillBalance.this.changeFloat();
            }
        });
        this.tendersModel = new TenderTableModel();
        this.tblTenders = new PosTable(this.frParent, this.tendersModel){

            @Override
            public Color getDisplayForegroundAt(Object value, int row, int col) {
                if (row < 0 || col < 0) {
                    return this.renderer.defaultColour;
                }
                if (col == 3 && ((PaTillBalance)PaTillBalance.this).tendersModel.data.elementAt(row).getVariance() != 0.0) {
                    return Colours.RED;
                }
                if (!((PaTillBalance)PaTillBalance.this).tendersModel.data.elementAt((int)row).payType.isTillCounting()) {
                    return Colours.GREY;
                }
                return this.renderer.defaultColour;
            }

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 4: {
                        return ImageIcon.class;
                    }
                }
                return super.getColumnClass(column);
            }
        };
        ComponentKeyEventHelper.ignoreKeyEvent(this.tblTenders, 10);
        this.tblTenders.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PaTillBalance.this.showCountDlg();
                }
            }
        });
        this.tblTenders.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    PaTillBalance.this.showCountDlg();
                } else {
                    PosTable target = (PosTable)e.getSource();
                    int row = target.getSelectedRow();
                    int column = target.getSelectedColumn();
                    if (row >= 0 && row < ((PaTillBalance)PaTillBalance.this).tendersModel.data.size() && column == 4 && ((PaTillBalance)PaTillBalance.this).tendersModel.data.elementAt((int)row).payType.isTillCounting()) {
                        PaTillBalance.this.showCountDlg();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PaTillBalance.this.frParent.setStatusText(sTendersTableStatusMessage);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PaTillBalance.this.frParent.resetStatus();
            }
        });
        this.tblTenders.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaTillBalance.this.frParent.setStatusText(sTendersTableStatusMessage);
            }

            @Override
            public void focusLost(FocusEvent e) {
                PaTillBalance.this.frParent.resetStatus();
            }
        });
        this.tblInit();
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblTenders.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row != 0) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        return StoreParams.totalText;
                    }
                    case 1: {
                        return new PosDouble(PaTillBalance.this.tendersModel.getTotalExpected());
                    }
                    case 2: {
                        return new PosDouble(PaTillBalance.this.tendersModel.getTotalCounted());
                    }
                    case 3: {
                        return new PosDouble(PaTillBalance.this.tendersModel.getTotalVariance());
                    }
                }
                return "";
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblTenders, totalsTableModel){

            @Override
            public Color getDisplayForegroundAt(Object value, int row, int col) {
                if (row < 0 || col < 0) {
                    return this.renderer.defaultColour;
                }
                if (col == 3 && PaTillBalance.this.tendersModel.getTotalVariance() != 0.0) {
                    return Colours.RED;
                }
                return this.renderer.defaultColour;
            }
        };
        this.updateSec(false);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tblTenders);
        if (FrTillBalance.promptForBankBagNumber) {
            v.add(this.tfBankBagNumber);
        }
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.setLayout(this.gridBagLayout);
        this.add((Component)this.lFeedBack, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tblTenders.getScrollPane(), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 15, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.lFloat, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
        this.add((Component)this.lBank, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.tfFloat, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.bChangeFloat, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.tfBank, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        if (FrTillBalance.promptForBankBagNumber) {
            this.add((Component)this.lBankBagNumber, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
            this.add((Component)this.tfBankBagNumber, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        }
    }

    void updateSec(boolean viewVariance) {
        this.bShowingVariances = viewVariance;
        this.setColumnSizes(this.bShowingVariances);
        this.tendersModel.fireTableDataChanged();
    }

    public void setEditable(boolean pEditable) {
        this.bChangeFloat.setEnabled(pEditable && !SP.sParams.EODFixed);
        if (FrTillBalance.promptForBankBagNumber) {
            this.tfBankBagNumber.setEditable(pEditable);
        }
        this.bEditable = pEditable;
    }

    public boolean isEditable() {
        return this.bEditable;
    }

    public double getTotalCounted() {
        return this.tendersModel.getTotalCounted();
    }

    private void showCountDlg() {
        if (!this.frParent.isLoggedIn(true)) {
            return;
        }
        int nRow = this.tblTenders.getSelectedRow();
        if (nRow > -1) {
            TenDets td = this.tendersModel.data.elementAt(nRow);
            StringBuffer sbOkPressed = new StringBuffer("0");
            if (td.payType.isTillCounting()) {
                DlgTillBalanceCount d = new DlgTillBalanceCount(this.frParent, "", true, "", td, this.bEditable, this.bShowingVariances, sbOkPressed);
                d.setVisible(true);
                this.tendersModel.fireTableRowsUpdated(nRow, nRow);
                if (sbOkPressed.toString().equals("1")) {
                    this.selectNextCountableTender(nRow);
                    this.setTot();
                }
            } else {
                Object[] objs = new Object[]{td.payType.code};
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("count_not_needed"), objs), StoreParams.res.getString("Stop"), -1, 0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean populate(Element trans) {
        this.tfBankBagNumber.setText("");
        try {
            Throwable throwable;
            SqlQuery sql;
            this.populateDenominations();
            this.tendersModel.data.clear();
            String storeno = trans.getAttribute("widx") != null ? this.sParams.getStore(trans.getAttribute("widx").getLongValue()).getStoreNo() : "000";
            this.lFeedBack.setText(StoreParams.res.getString("Docket_") + " D" + storeno + trans.getAttribute("docket_number").getValue());
            if (FrTillBalance.promptForBankBagNumber) {
                sql = new SqlQuery(this.sParams.conn, "SELECT BANK_BAG_NUM FROM RET_TRANH WHERE \"ACTIVE\" = 1 AND TR_TYPE = 564 AND DOCKET_NUMBER = ? AND WIDX = ?", trans.getAttribute("docket_number").getValue(), this.sParams.getStoreIdx());
                throwable = null;
                try {
                    if (sql.next()) {
                        this.tfBankBagNumber.setText(sql.getString(1));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (sql != null) {
                        if (throwable != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
            }
            sql = new SqlQuery(this.sParams.conn, "SELECT TBIDX, TYPEIDX, FLOATAMT, BALANCE, VARIANCE FROM TILL_BALANCES WHERE DOCKET_NUMBER = " + PosUtils.StringToSqlString(trans.getAttribute("docket_number").getValue()));
            throwable = null;
            try {
                TenDets d = null;
                long nTbIdx = 0L;
                try (PreparedStatement pscCount = this.sParams.conn.prepareStatement("SELECT \"VALUE\", \"COUNT\" FROM TENDER_BALANCES WHERE TBIDX = ?");){
                    while (sql.next()) {
                        Throwable throwable4;
                        ResultSet rsCount;
                        try {
                            PayType p = PayTypes.getPayType(sql.getLong(2));
                            d = new TenDets(p);
                        }
                        catch (Exception e) {
                            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("ten_dets_changed"), "\n"), StoreParams.res.getString("Error"), 0);
                            boolean bl = false;
                            if (pscCount != null) {
                                if (var9_15 != null) {
                                    try {
                                        pscCount.close();
                                    }
                                    catch (Throwable throwable5) {
                                        var9_15.addSuppressed(throwable5);
                                    }
                                } else {
                                    pscCount.close();
                                }
                            }
                            if (sql == null) return bl;
                            if (throwable == null) {
                                sql.close();
                                return bl;
                            }
                            try {
                                sql.close();
                                return bl;
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                                return bl;
                            }
                        }
                        nTbIdx = sql.getLong(1);
                        d.nCounted = sql.getDouble(4);
                        d.nExpected = d.nCounted - sql.getDouble(5);
                        if (d.payType.isCash) {
                            this.tfFloat.setText(sql.getDouble(3));
                            for (int j = 0; j < this.vDenom.size(); ++j) {
                                d.data.add(this.vDenom.elementAt(j));
                            }
                            pscCount.setLong(1, nTbIdx);
                            rsCount = pscCount.executeQuery();
                            throwable4 = null;
                            try {
                                while (rsCount.next()) {
                                    for (int i = 0; i < d.data.size(); ++i) {
                                        if (((Denomination)d.data.elementAt((int)i)).nValue != rsCount.getDouble(1)) continue;
                                        ((Denomination)d.data.elementAt((int)i)).nCount = rsCount.getInt(2);
                                    }
                                }
                            }
                            catch (Throwable throwable7) {
                                throwable4 = throwable7;
                                throw throwable7;
                            }
                            finally {
                                if (rsCount != null) {
                                    if (throwable4 != null) {
                                        try {
                                            rsCount.close();
                                        }
                                        catch (Throwable throwable8) {
                                            throwable4.addSuppressed(throwable8);
                                        }
                                    } else {
                                        rsCount.close();
                                    }
                                }
                            }
                        }
                        pscCount.setLong(1, nTbIdx);
                        rsCount = pscCount.executeQuery();
                        throwable4 = null;
                        try {
                            while (rsCount.next()) {
                                d.data.add(new PosDouble(rsCount.getDouble(1)));
                            }
                        }
                        catch (Throwable throwable9) {
                            throwable4 = throwable9;
                            throw throwable9;
                        }
                        finally {
                            if (rsCount != null) {
                                if (throwable4 != null) {
                                    try {
                                        rsCount.close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable4.addSuppressed(throwable10);
                                    }
                                } else {
                                    rsCount.close();
                                }
                            }
                        }
                        this.tendersModel.data.add(d);
                    }
                }
            }
            catch (Throwable throwable11) {
                throwable = throwable11;
                throw throwable11;
            }
            finally {
                if (sql != null) {
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable12) {
                            throwable.addSuppressed(throwable12);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
            this.tendersModel.fireTableDataChanged();
            this.setTot();
            return true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    private void populateDenominations() {
        block15: {
            try {
                this.vDenom.clear();
                String denoms = this.sParams.storeCurrency.getDenominations();
                if (denoms.length() <= 0) break block15;
                try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT RCIDX, CODE, NAME, COALESCE(LINKIDX, 0) FROM REFCODE WHERE RGIDX = 371 AND \"ACTIVE\" = 1 AND RCIDX IN (" + denoms + ") ORDER BY COALESCE(LINKIDX, 0)");){
                    while (sql.next()) {
                        this.vDenom.add(new Denomination(sql.getLong(1), sql.getString(2), sql.getString(3), sql.getDouble(4), 0));
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    private void changeFloat() {
        TenDets tdCash = null;
        for (int i = 0; i < this.tendersModel.data.size(); ++i) {
            if (!this.tendersModel.data.elementAt((int)i).payType.isCash) continue;
            tdCash = this.tendersModel.data.elementAt(i);
            break;
        }
        if (tdCash != null) {
            DlgTillBalanceFloat d = new DlgTillBalanceFloat(this.frParent, tdCash, this.tfFloat.getDouble(), SP.getRS("Change_float_title"));
            d.setVisible(true);
            this.tfFloat.setText(d.getFloat());
            this.tfBank.setText(tdCash.nCounted - this.tfFloat.getDouble());
            d.dispose();
        }
    }

    public void selectNextCountableTender(int npCurrentRow) {
        for (int i = npCurrentRow + 1; i < this.tendersModel.data.size(); ++i) {
            if (!this.tendersModel.data.elementAt((int)i).payType.isTillCounting()) continue;
            this.tblTenders.setRowSelectionInterval(i, i);
            this.tblTenders.scrollRectToVisible(this.tblTenders.getCellRect(this.tblTenders.getSelectedRow(), 0, true));
            break;
        }
    }

    public double getTotalValiance() {
        return this.tendersModel.getTotalVariance();
    }

    public double getTotalCountedCheque() {
        return this.tendersModel.getTotalCountedCheque();
    }

    private class TenderTableModel
    extends AbstractTableModel {
        Vector<TenDets> data = new Vector();

        private TenderTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.data.size() || row < 0) {
                return "";
            }
            switch (col) {
                case 0: {
                    return this.data.elementAt((int)row).payType.code;
                }
                case 1: {
                    return new PosDouble(this.data.elementAt((int)row).nExpected);
                }
                case 2: {
                    return new PosDouble(this.data.elementAt((int)row).nCounted);
                }
                case 3: {
                    return new PosDouble(this.data.elementAt(row).getVariance());
                }
                case 4: {
                    if (row == PaTillBalance.this.tblTenders.getSelectedRow()) {
                        if (this.data.elementAt((int)row).payType.isTillCounting()) {
                            return PaTillBalance.this.countIcon;
                        }
                        return PaTillBalance.this.disabledCountIcon;
                    }
                    return null;
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return sTENDER;
                }
                case 1: {
                    return sEXPECTED;
                }
                case 2: {
                    return sCOUNTED;
                }
                case 3: {
                    return sVARIANCE;
                }
                case 4: {
                    return sCOUNT_BUTTON;
                }
            }
            return "";
        }

        public double getTotalExpected() {
            double nTotal = 0.0;
            for (int i = 0; i < ((PaTillBalance)PaTillBalance.this).tendersModel.data.size(); ++i) {
                nTotal += ((PaTillBalance)PaTillBalance.this).tendersModel.data.elementAt((int)i).nExpected;
            }
            return ((PaTillBalance)PaTillBalance.this).sParams.storeCurrency.round(nTotal);
        }

        public double getTotalCounted() {
            double nTotal = 0.0;
            for (int i = 0; i < ((PaTillBalance)PaTillBalance.this).tendersModel.data.size(); ++i) {
                nTotal += ((PaTillBalance)PaTillBalance.this).tendersModel.data.elementAt((int)i).nCounted;
            }
            return ((PaTillBalance)PaTillBalance.this).sParams.storeCurrency.round(nTotal);
        }

        public double getTotalVariance() {
            double nTotal = 0.0;
            for (int i = 0; i < ((PaTillBalance)PaTillBalance.this).tendersModel.data.size(); ++i) {
                nTotal += ((PaTillBalance)PaTillBalance.this).tendersModel.data.elementAt(i).getVariance();
            }
            return ((PaTillBalance)PaTillBalance.this).sParams.storeCurrency.round(nTotal);
        }

        public double getTotalCountedCheque() {
            double nTotal = 0.0;
            for (int i = 0; i < ((PaTillBalance)PaTillBalance.this).tendersModel.data.size(); ++i) {
                if (!((PaTillBalance)PaTillBalance.this).tendersModel.data.elementAt((int)i).payType.isCheque) continue;
                nTotal += ((PaTillBalance)PaTillBalance.this).tendersModel.data.elementAt((int)i).nCounted;
            }
            return ((PaTillBalance)PaTillBalance.this).sParams.storeCurrency.round(nTotal);
        }
    }
}

