/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import jpos.StringUtils;
import jpos.ui.UIConstants;

public class BorderVerifier
extends InputVerifier {
    private Border originalBorder;
    private JComponent borderComponent;
    private JComponent validateComponent;

    public BorderVerifier(JComponent borderComponent, JComponent validateComponent) {
        this.borderComponent = borderComponent;
        this.validateComponent = validateComponent;
        this.originalBorder = borderComponent.getBorder();
        validateComponent.setInputVerifier(this);
        validateComponent.addFocusListener(new BorderResetFocusListener(this));
    }

    public BorderVerifier(JComponent borderComponent) {
        this(borderComponent, borderComponent);
    }

    @Override
    public boolean verify(JComponent input) {
        if (this.isValid(input)) {
            this.resetBorder();
            return true;
        }
        if (this.borderComponent != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BorderVerifier.this.borderComponent.setBorder(UIConstants.INVALID_BORDER);
                }
            });
        }
        return false;
    }

    @Override
    public boolean shouldYieldFocus(JComponent input) {
        this.verify(input);
        return true;
    }

    public boolean isValid(JComponent input) {
        if (!(input instanceof JTextField)) {
            return true;
        }
        return !StringUtils.isNullOrEmpty(((JTextField)input).getText());
    }

    public void resetBorder() {
        if (this.borderComponent != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BorderVerifier.this.borderComponent.setBorder(BorderVerifier.this.originalBorder);
                }
            });
        }
    }

    public boolean verify() {
        return this.verify(this.validateComponent);
    }

    public static class BorderResetFocusListener
    implements FocusListener {
        BorderVerifier verifier;

        public BorderResetFocusListener(BorderVerifier verifier) {
            this.verifier = verifier;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.verifier.resetBorder();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

