/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JLabel;
import jpos.Link;
import jpos.LinkStyle;
import jpos.StringUtils;

public class LinkLabel
extends JLabel {
    private Link link = new Link();

    public LinkLabel() {
        this("");
    }

    public LinkLabel(String text) {
        this.setText(text);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LinkLabel.this.link.isValid()) {
                    LinkLabel.this.link.open();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (LinkLabel.this.link.isValid()) {
                    LinkLabel.this.getParent().setCursor(new Cursor(12));
                    LinkLabel.this.updateText(LinkStyle.ACTIVE);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (LinkLabel.this.link.isValid()) {
                    LinkLabel.this.updateText(LinkLabel.this.link.isVisited() ? LinkStyle.VISITED : LinkStyle.UNVISITED);
                    LinkLabel.this.getParent().setCursor(new Cursor(0));
                }
            }
        });
    }

    public void setLink(URI uri) {
        this.link.setURI(uri);
        this.updateLink();
    }

    public void setLink(String uri) {
        this.link.setURI(uri);
        this.updateLink();
    }

    private void updateLink() {
        this.setToolTipText(!this.link.isValid() ? "" : this.link.getURI().toString());
        this.updateText(LinkStyle.UNVISITED);
    }

    @Override
    public void setText(String text) {
        if (this.link != null) {
            this.link.setDisplayText(StringUtils.nullToEmpty(text));
            this.updateText(this.link.isVisited() ? LinkStyle.VISITED : LinkStyle.UNVISITED);
        } else {
            super.setText(text);
        }
    }

    private void updateText(LinkStyle style) {
        String formattedText = this.link.getDisplayText();
        if (style != null && this.link.isValid()) {
            formattedText = style.format(formattedText);
        }
        super.setText(formattedText);
    }

    public URI getLink() {
        return this.link.getURI();
    }

    public String getLinkText() {
        return this.link.getDisplayText();
    }

    public void clear() {
        this.link.clear();
        this.setText("");
    }
}

