/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jpos.SP;
import jpos.ui.UIConstants;

public class TableCellCheckbox
extends JCheckBox
implements TableCellRenderer {
    private static ImageIcon iconChecked = new ImageIcon(SP.sParams.imagepath + "tick32x32.png");
    private static ImageIcon iconUnchecked = new ImageIcon(SP.sParams.imagepath + "unchecked.png");

    public TableCellCheckbox() {
        this.setOpaque(true);
        this.setBorderPainted(true);
        this.setHorizontalAlignment(0);
        this.setSelected(false);
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.toggleIcon(selected);
    }

    private void toggleIcon(boolean selected) {
        if (selected) {
            this.setIcon(iconChecked);
        } else {
            this.setIcon(iconUnchecked);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.setBorder(UIConstants.TABLE_SELECTED_CELL_BORDER);
        } else {
            this.setBorder(UIConstants.TABLE_CELL_BORDER);
        }
        this.setFont(table.getFont());
        if (value instanceof Boolean) {
            this.setSelected((Boolean)value);
        }
        return this;
    }
}

