/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import jpos.SP;
import jpos.ui.Fonts;
import jpos.ui.UIConstants;

public class TouchToggleButton
extends JToggleButton {
    private static ImageIcon ICON_CHECKED = new ImageIcon(SP.sParams.imagepath + "tick32x32.png");
    private static ImageIcon ICON_UNCHECKED = new ImageIcon(SP.sParams.imagepath + "unchecked.png");
    private static final int WIDTH = 160;
    private boolean isPerformingAction = false;

    public TouchToggleButton() {
        this.init();
    }

    private void init() {
        this.setMaximumSize(new Dimension(160, UIConstants.BUTTON_HEIGHT));
        this.setMinimumSize(new Dimension(160, UIConstants.BUTTON_HEIGHT));
        this.setPreferredSize(new Dimension(160, UIConstants.BUTTON_HEIGHT));
        this.setFont(Fonts.PlainText);
        if (UIManager.getBorder("Button.border").toString().indexOf("XP") > 0) {
            this.setBorder(new EmptyBorder(2, 8, 2, 2));
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TouchToggleButton.this.isPerformingAction && TouchToggleButton.this.isVisible()) {
                    TouchToggleButton.this.isPerformingAction = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TouchToggleButton.this.toggleIcon();
                            TouchToggleButton.this.isPerformingAction = false;
                        }
                    });
                }
            }
        });
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!TouchToggleButton.this.isPerformingAction && TouchToggleButton.this.isVisible()) {
                    TouchToggleButton.this.isPerformingAction = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TouchToggleButton.this.toggleIcon();
                            TouchToggleButton.this.isPerformingAction = false;
                        }
                    });
                }
            }
        });
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(4);
        this.setIconTextGap(7);
        this.setSelected(false);
    }

    private void toggleIcon() {
        if (this.isSelected()) {
            this.setIcon(ICON_CHECKED);
        } else {
            this.setIcon(ICON_UNCHECKED);
        }
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
        this.toggleIcon();
    }
}

