/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jpos.DlgMessage;
import jpos.PosDateField;
import jpos.PosDateFormatter;
import jpos.PosDialog;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.voucher.BaseAdapter;
import jpos.voucher.BaseVoucher;
import jpos.voucher.GatewayVoucher;
import jpos.voucher.Voucher;
import jpos.voucher.VoucherAdapter;
import jpos.voucher.VoucherType;
import jpos.voucher.VoucherUtils;

public class DlgStatusDetails
extends PosDialog {
    private final JPanel contentPanel = new JPanel();
    private BaseAdapter adapter = null;
    private PosFrame parent = null;
    private PosDateField dfExpiryDate = null;
    private LabelNormal lblExpiryTitle;
    private LabelNormal lblIssuedTitle;
    private LabelNormal lblIssuedDate;
    private LabelNormal lblIssuedStore;
    private LabelSubHeading lblHeading;
    private LabelNormal lblExpiryDate;
    private DialogButton btnChangeDate;
    private LabelNormal lblOriginalValueTitle;
    private LabelNormal lblOriginalValue;
    private LabelNormal lblRemainingValueTitle;
    private LabelNormal lblRemainingValue;
    private LabelNormal lblCardStatusTitle;
    private LabelNormal lblCardStatusValue;
    private LabelNormal lblLastUsedTitle;
    private LabelNormal lblLastUsedDate;
    private LabelNormal lblLastUsedStore;
    private DialogButton btnOk = new DialogButton("OK");

    public DlgStatusDetails(PosFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.dfExpiryDate = new PosDateField(parent);
        this.setBounds(100, 100, 392, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gbl_contentPanel = new GridBagLayout();
        gbl_contentPanel.columnWidths = new int[]{153, 153, 110, 0};
        gbl_contentPanel.rowHeights = new int[]{14, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_contentPanel.columnWeights = new double[]{1.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_contentPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gbl_contentPanel);
        this.lblHeading = new LabelSubHeading("");
        GridBagConstraints gbc_lblHeading = new GridBagConstraints();
        gbc_lblHeading.gridwidth = 3;
        gbc_lblHeading.anchor = 17;
        gbc_lblHeading.insets = new Insets(5, 5, 20, 0);
        gbc_lblHeading.gridx = 0;
        gbc_lblHeading.gridy = 0;
        this.contentPanel.add((Component)this.lblHeading, gbc_lblHeading);
        this.lblIssuedTitle = new LabelNormal(SP.getRS("Issued"));
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.anchor = 17;
        gbc_label.insets = new Insets(5, 5, 0, 5);
        gbc_label.gridx = 0;
        gbc_label.gridy = 1;
        this.contentPanel.add((Component)this.lblIssuedTitle, gbc_label);
        this.lblIssuedDate = new LabelNormal("");
        GridBagConstraints gbc_lblLabel = new GridBagConstraints();
        gbc_lblLabel.gridwidth = 2;
        gbc_lblLabel.anchor = 17;
        gbc_lblLabel.insets = new Insets(5, 0, 0, 5);
        gbc_lblLabel.gridx = 1;
        gbc_lblLabel.gridy = 1;
        this.contentPanel.add((Component)this.lblIssuedDate, gbc_lblLabel);
        this.lblIssuedStore = new LabelNormal("");
        gbc_label = new GridBagConstraints();
        gbc_label.gridwidth = 2;
        gbc_label.insets = new Insets(0, 0, 5, 5);
        gbc_label.anchor = 17;
        gbc_label.gridx = 1;
        gbc_label.gridy = 2;
        this.contentPanel.add((Component)this.lblIssuedStore, gbc_label);
        this.lblExpiryTitle = new LabelNormal(SP.getRS("Expires_2"));
        GridBagConstraints gbc_lblExpiryTitle = new GridBagConstraints();
        gbc_lblExpiryTitle.anchor = 17;
        gbc_lblExpiryTitle.insets = new Insets(5, 5, 5, 5);
        gbc_lblExpiryTitle.gridx = 0;
        gbc_lblExpiryTitle.gridy = 3;
        this.contentPanel.add((Component)this.lblExpiryTitle, gbc_lblExpiryTitle);
        this.lblExpiryDate = new LabelNormal("");
        GridBagConstraints gbc_lblExpiryDate = new GridBagConstraints();
        gbc_lblExpiryDate.anchor = 17;
        gbc_lblExpiryDate.insets = new Insets(5, 0, 5, 5);
        gbc_lblExpiryDate.gridx = 1;
        gbc_lblExpiryDate.gridy = 3;
        this.contentPanel.add((Component)this.lblExpiryDate, gbc_lblExpiryDate);
        this.btnChangeDate = new DialogButton("");
        this.btnChangeDate.setText(SP.getRS("F5_change_date"));
        GridBagConstraints gbc_btnChangeDate = new GridBagConstraints();
        gbc_btnChangeDate.insets = new Insets(0, 0, 5, 0);
        gbc_btnChangeDate.anchor = 13;
        gbc_btnChangeDate.gridx = 2;
        gbc_btnChangeDate.gridy = 3;
        this.contentPanel.add((Component)this.btnChangeDate, gbc_btnChangeDate);
        this.btnChangeDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStatusDetails.this.changeExpiryDate();
            }
        });
        this.lblOriginalValueTitle = new LabelNormal(SP.getRS("Original_Value"));
        GridBagConstraints gbc_lblOriginalValueTitle = new GridBagConstraints();
        gbc_lblOriginalValueTitle.anchor = 17;
        gbc_lblOriginalValueTitle.insets = new Insets(5, 5, 5, 5);
        gbc_lblOriginalValueTitle.gridx = 0;
        gbc_lblOriginalValueTitle.gridy = 4;
        this.contentPanel.add((Component)this.lblOriginalValueTitle, gbc_lblOriginalValueTitle);
        this.lblOriginalValue = new LabelNormal("");
        GridBagConstraints gbc_lblOriginalValue = new GridBagConstraints();
        gbc_lblOriginalValue.anchor = 17;
        gbc_lblOriginalValue.insets = new Insets(5, 0, 5, 5);
        gbc_lblOriginalValue.gridx = 1;
        gbc_lblOriginalValue.gridy = 4;
        this.contentPanel.add((Component)this.lblOriginalValue, gbc_lblOriginalValue);
        this.lblRemainingValueTitle = new LabelNormal(SP.getRS("Remaining_Value"));
        GridBagConstraints gbc_lblRemainingValueTitle = new GridBagConstraints();
        gbc_lblRemainingValueTitle.anchor = 17;
        gbc_lblRemainingValueTitle.insets = new Insets(5, 5, 5, 5);
        gbc_lblRemainingValueTitle.gridx = 0;
        gbc_lblRemainingValueTitle.gridy = 5;
        this.contentPanel.add((Component)this.lblRemainingValueTitle, gbc_lblRemainingValueTitle);
        this.lblRemainingValue = new LabelNormal("");
        GridBagConstraints gbc_lblRemainingValue = new GridBagConstraints();
        gbc_lblRemainingValue.anchor = 17;
        gbc_lblRemainingValue.insets = new Insets(5, 0, 5, 5);
        gbc_lblRemainingValue.gridx = 1;
        gbc_lblRemainingValue.gridy = 5;
        this.contentPanel.add((Component)this.lblRemainingValue, gbc_lblRemainingValue);
        this.lblCardStatusTitle = new LabelNormal(SP.getRS("CardStatus_Value"));
        GridBagConstraints gbc_lblCardStatusTitle = new GridBagConstraints();
        gbc_lblCardStatusTitle.anchor = 17;
        gbc_lblCardStatusTitle.insets = new Insets(5, 5, 5, 5);
        gbc_lblCardStatusTitle.gridx = 0;
        gbc_lblCardStatusTitle.gridy = 6;
        this.contentPanel.add((Component)this.lblCardStatusTitle, gbc_lblCardStatusTitle);
        this.lblCardStatusValue = new LabelNormal("");
        GridBagConstraints gbc_lblCardStatusValue = new GridBagConstraints();
        gbc_lblCardStatusValue.anchor = 17;
        gbc_lblCardStatusValue.insets = new Insets(5, 0, 5, 5);
        gbc_lblCardStatusValue.gridx = 1;
        gbc_lblCardStatusValue.gridy = 6;
        this.contentPanel.add((Component)this.lblCardStatusValue, gbc_lblCardStatusValue);
        this.lblLastUsedTitle = new LabelNormal(SP.getRS("Last_Used"));
        GridBagConstraints gbc_lblLastUsedTitle = new GridBagConstraints();
        gbc_lblLastUsedTitle.anchor = 17;
        gbc_lblLastUsedTitle.insets = new Insets(5, 5, 0, 5);
        gbc_lblLastUsedTitle.gridx = 0;
        gbc_lblLastUsedTitle.gridy = 7;
        this.contentPanel.add((Component)this.lblLastUsedTitle, gbc_lblLastUsedTitle);
        this.lblLastUsedDate = new LabelNormal("");
        GridBagConstraints gbc_lblLastUsedDate = new GridBagConstraints();
        gbc_lblLastUsedDate.gridwidth = 2;
        gbc_lblLastUsedDate.anchor = 17;
        gbc_lblLastUsedDate.insets = new Insets(5, 0, 0, 5);
        gbc_lblLastUsedDate.gridx = 1;
        gbc_lblLastUsedDate.gridy = 7;
        this.contentPanel.add((Component)this.lblLastUsedDate, gbc_lblLastUsedDate);
        this.lblLastUsedStore = new LabelNormal("");
        GridBagConstraints gbc_lblLastUsedStore = new GridBagConstraints();
        gbc_lblLastUsedStore.gridwidth = 2;
        gbc_lblLastUsedStore.insets = new Insets(0, 0, 5, 5);
        gbc_lblLastUsedStore.anchor = 17;
        gbc_lblLastUsedStore.gridx = 1;
        gbc_lblLastUsedStore.gridy = 8;
        this.contentPanel.add((Component)this.lblLastUsedStore, gbc_lblLastUsedStore);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnOk.setText(SP.getRS("OK"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStatusDetails.this.dispose();
            }
        });
        buttonPane.add(this.btnOk);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.btnOk);
        v.add(this.btnChangeDate);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    public void loadDetails(BaseAdapter adapter) {
        boolean isGatewayVoucher;
        this.adapter = adapter;
        BaseVoucher voucher = adapter instanceof VoucherAdapter ? ((VoucherAdapter)adapter).getBaseVoucher() : adapter.getVoucher();
        boolean bl = isGatewayVoucher = adapter instanceof VoucherAdapter && ((VoucherAdapter)adapter).getGatewayVoucher() != null;
        if (isGatewayVoucher || voucher instanceof Voucher && ((Voucher)voucher).getVoucherType().getIssueType() == VoucherType.IssueType.PROMO) {
            this.btnChangeDate.setVisible(false);
        } else {
            this.btnChangeDate.setEnabled(this.parent.hasSecurity(adapter.getSecurity(), 2));
        }
        Date dToday = new Date(new java.util.Date().getTime());
        PosDateFormatter.truncateTime(dToday);
        PosDateFormatter.truncateTime(voucher.getExpiryDate());
        if (voucher.getExpiryDate() != null && dToday.getTime() > voucher.getExpiryDate().getTime()) {
            this.lblExpiryTitle.setText(SP.getRS("Expired"));
            this.lblExpiryTitle.setForeground(Colours.RED);
            this.lblExpiryDate.setForeground(Colours.RED);
        } else {
            this.lblExpiryTitle.setText(SP.getRS("Expires_2"));
            this.lblExpiryTitle.setForeground(Colours.BLACK);
            this.lblExpiryDate.setForeground(Colours.BLACK);
        }
        this.lblHeading.setText(adapter.getDisplayText(BaseAdapter.DisplayText.VoucherNumberDsiplay));
        PosDateFormatter dateFormatter = null;
        dateFormatter = voucher.getIssuedDate() != null ? new PosDateFormatter(new Timestamp(voucher.getIssuedDate().getTime()), 3, 3, 2) : new PosDateFormatter(null, 3, 3, 2);
        this.lblIssuedDate.setText(dateFormatter.toString().equals("") ? "" : dateFormatter.toString());
        this.lblIssuedStore.setText(voucher.getIssuedStore() == null ? "" : voucher.getIssuedStore());
        dateFormatter = voucher.getExpiryDate() != null ? new PosDateFormatter(new Timestamp(voucher.getExpiryDate().getTime()), 3, 3, 0) : new PosDateFormatter(null, 3, 3, 0);
        this.lblExpiryDate.setText(dateFormatter.toString().equals("") ? SP.getRS("expires_never") : dateFormatter.toString());
        if (isGatewayVoucher) {
            this.lblOriginalValue.setVisible(false);
            this.lblOriginalValueTitle.setVisible(false);
        } else {
            this.lblOriginalValue.setText(PosDouble.valueOf(voucher.getOriginalAmount()).toString());
        }
        this.lblRemainingValue.setText(PosDouble.valueOf(voucher.getAvailableAmount()).toString());
        dateFormatter = voucher.getLastUsedDate() != null ? new PosDateFormatter(new Timestamp(voucher.getLastUsedDate().getTime()), 3, 3, 2) : new PosDateFormatter(null, 3, 3, 2);
        this.lblLastUsedDate.setText(dateFormatter.toString().equals("") ? "" : dateFormatter.toString());
        this.lblLastUsedStore.setText(voucher.getLastUsedStore() == null ? "" : voucher.getLastUsedStore());
        this.lblLastUsedTitle.setText(this.lblLastUsedStore.getText().equals("") && dateFormatter.toString().equals("") ? "" : adapter.getDisplayText(BaseAdapter.DisplayText.LastUsedTitle));
        if (voucher.getClass() == GatewayVoucher.class && ((GatewayVoucher)voucher).getCardStatus() != null) {
            this.lblCardStatusValue.setText(((GatewayVoucher)voucher).getCardStatus());
        } else {
            this.lblCardStatusTitle.setText("");
        }
        this.pack();
    }

    private void changeExpiryDate() {
        BaseVoucher voucher = this.adapter.getVoucher();
        if (voucher.getAvailableAmount() <= 0.0) {
            DlgMessage.showMessage(this.parent, this.adapter.getDisplayText(BaseAdapter.DisplayText.RedeemedMsg), SP.getRS("Change_Expiry_Date"), -1, 0);
            return;
        }
        if (voucher.isPosted()) {
            DlgMessage.showMessage(this.parent, this.adapter.getDisplayText(BaseAdapter.DisplayText.WrittenOffMsg), SP.getRS("Change_Expiry_Date"), -1, 0);
            return;
        }
        Timestamp origTime = voucher.getExpiryDate() == null ? null : new Timestamp(voucher.getExpiryDate().getTime());
        Timestamp modifiedTime = voucher.getExpiryDate() == null ? new Timestamp(new java.util.Date().getTime()) : new Timestamp(voucher.getExpiryDate().getTime());
        this.dfExpiryDate.setValue(modifiedTime);
        this.dfExpiryDate.actionSearch();
        PosDateFormatter.truncateTime(origTime);
        PosDateFormatter.truncateTime(modifiedTime);
        if (modifiedTime != null) {
            try {
                if (origTime == null || origTime.getTime() != modifiedTime.getTime()) {
                    if (voucher.getExpiryDate() == null) {
                        voucher.setExpiryDate(new Date(modifiedTime.getTime()));
                    } else {
                        voucher.getExpiryDate().setTime(modifiedTime.getTime());
                    }
                    VoucherUtils.changeExpiryDate(SP.sParams.conn, voucher.getGvcnidx(), voucher.getExpiryDate(), this.parent.getUser().getMemidx());
                    this.loadDetails(this.adapter);
                    DlgMessage.showMessage(this.parent, MessageFormat.format(SP.getRS("Expiry_Date_Changed"), this.dfExpiryDate.getDateFormatter().toString()), SP.getRS("Change_Expiry_Date"), 1);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 116 && this.btnChangeDate.isEnabled()) {
            this.btnChangeDate.doClick();
            return true;
        }
        return false;
    }

    @Override
    public void okDialog() {
        this.btnOk.doClick();
    }

    @Override
    public void cancelDialog() {
        this.btnOk.doClick();
    }
}

