/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.sql.Date;
import java.sql.Timestamp;
import jpos.SP;
import jpos.voucher.BaseVoucher;
import jpos.voucher.IVoucherGateway;
import jpos.voucher.vii.ViiGateway;

public class GatewayVoucher
extends BaseVoucher {
    private IVoucherGateway gateway;
    private String voucherNumber;
    private String serialNumber;
    private Status cardStatus;
    private String pin;
    private String reference;
    private String receiptNumber;
    private String authCode;
    private double originalAmount;
    private double usedAmount;
    private Date issueDate;
    private Date expiryDate;
    private String settlementDate;
    private String gatewayMessage;
    private String gatewayTransactionId;
    private boolean deferred;
    private String quantityOrdered;

    public void copyFrom(GatewayVoucher voucher) {
        this.voucherNumber = voucher.voucherNumber;
        this.cardStatus = voucher.cardStatus;
        this.reference = voucher.reference;
        this.receiptNumber = voucher.receiptNumber;
        this.authCode = voucher.authCode;
        this.originalAmount = voucher.originalAmount;
        this.usedAmount = voucher.usedAmount;
        this.issueDate = voucher.issueDate;
        this.expiryDate = voucher.expiryDate;
        this.gatewayMessage = voucher.gatewayMessage;
        this.gatewayTransactionId = voucher.gatewayTransactionId;
        this.deferred = voucher.deferred;
        this.quantityOrdered = voucher.quantityOrdered;
    }

    public String getQuantityOrdered() {
        return this.quantityOrdered;
    }

    public void setQuantityOrdered(String quantityOrdered) {
        this.quantityOrdered = quantityOrdered;
    }

    public String getPin() {
        return this.pin;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getGatewayMessage() {
        return this.gatewayMessage;
    }

    public void setGatewayMessage(String gatewayMessage) {
        this.gatewayMessage = gatewayMessage;
    }

    public String getGatewayTransactionId() {
        return this.gatewayTransactionId;
    }

    public void setGatewayTransactionId(String gatewayTransactionId) {
        this.gatewayTransactionId = gatewayTransactionId;
    }

    public void setDeferred(boolean deferred) {
        this.deferred = deferred;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public void setOriginalAmount(double originalAmount) {
        this.originalAmount = originalAmount;
    }

    public void setUsedAmount(double usedAmount) {
        this.usedAmount = usedAmount;
    }

    public GatewayVoucher(IVoucherGateway gateway, String voucherNumber) {
        this.gateway = gateway;
        this.voucherNumber = voucherNumber;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getSettlementDate() {
        return this.settlementDate;
    }

    public void setSettlementDate(String settlementDate) {
        this.settlementDate = settlementDate;
    }

    public void setCardStatus(String cardStatusId) {
        this.cardStatus = ViiGateway.getCardStatus(cardStatusId);
    }

    public String getCardStatus() {
        return this.cardStatus.getName();
    }

    public IVoucherGateway getGateway() {
        return this.gateway;
    }

    @Override
    public String getNumber() {
        return this.voucherNumber;
    }

    @Override
    public boolean isIssued() {
        return false;
    }

    @Override
    public long getGvcnidx() {
        return -1L;
    }

    @Override
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Override
    public double getOriginalAmount() {
        return this.originalAmount;
    }

    @Override
    public double getUsedAmount() {
        return this.usedAmount;
    }

    @Override
    public double getAvailableAmount() {
        return this.originalAmount - this.usedAmount;
    }

    @Override
    public Timestamp getIssuedDate() {
        return this.issueDate != null ? new Timestamp(this.issueDate.getTime()) : null;
    }

    @Override
    public Timestamp getLastUsedDate() {
        return null;
    }

    @Override
    public String getIssuedStore() {
        return null;
    }

    @Override
    public String getLastUsedStore() {
        return null;
    }

    @Override
    public boolean isPosted() {
        return false;
    }

    @Override
    public String getCurrencyIdx() {
        return null;
    }

    @Override
    public String getCurrencyCode() {
        return null;
    }

    @Override
    protected void loadDetails() throws Exception {
    }

    public static enum Status {
        UNKNOWN("voucher_status_unknown"),
        NOT_ISSUED("voucher_status_not_issued"),
        ACTIVE("voucher_status_active"),
        EXPIRED("voucher_status_expired"),
        SUSPENDED("voucher_status_suspended"),
        CANCELLED("voucher_status_cancelled");

        private String key;

        private Status(String key) {
            this.key = key;
        }

        public String getName() {
            return SP.getRS(this.key);
        }
    }
}

