/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;

public class VoucherType {
    private static final int IMPORT_TYPE = 784;
    private IssueType issueType;
    private BalanceRules balanceRules;
    private long nFromNum;
    private long nToNum;
    private double nValue;
    private Date dExpiryDate;
    private boolean issueWithSale;
    private String name;
    private String code;
    private long rcidx;
    private long gvridx;
    private boolean isSecure;
    private boolean useCheckDigit;
    private boolean rangeAtStore;
    private boolean rangeSuspended;
    private int nExpiryMonths;
    private boolean showName = false;
    private final String GIVE_CHANGE_MSG = SP.getRS("Give_Change_Msg");
    private final String RETAIN_VALUE_TEXT = SP.getRS("Retain_Value_Msg");
    private final String WRTIE_OFF_TEXT = SP.getRS("Wrtie_Off_Change_Msg");

    public IssueType getIssueType() {
        return this.issueType;
    }

    public BalanceRules getBalanceRules() {
        return this.balanceRules;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isIssueWithSale() {
        return this.issueWithSale;
    }

    public long getRcidx() {
        return this.rcidx;
    }

    public long getGvridx() {
        return this.gvridx;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean isImport() {
        return this.getRcidx() == 784L;
    }

    public boolean useCheckDigit() {
        return this.useCheckDigit;
    }

    public boolean isRangeAtStore() {
        return this.rangeAtStore;
    }

    public boolean isRangeSuspended() {
        return this.rangeSuspended;
    }

    public boolean isActive() {
        return this.rangeAtStore && !this.rangeSuspended;
    }

    public VoucherType(long pGvridx) {
        this.gvridx = pGvridx;
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT R.CODE, R.NAME, R.RCIDX, G.VOUCHER_RULE, G.EXPIRY_MONTHS, G.FROM_NUM, G.TO_NUM, G.VOUCHER_VALUE, G.EXPIRY_DATE, COALESCE(G.SECURE, 0), COALESCE(G.STATUS, 0) AS IS_ACTIVE_RANGE, COALESCE(G.USE_CHECK_DIGIT, 0), coalesce(g.promo_woff_issue_type, 0), R.\"ACTIVE\" as IS_ACTIVE_AT_STORE FROM REFCODE R JOIN GIFT_VOUCHER_RANGE G ON R.RCIDX = G.RCIDX WHERE G.GVRIDX = " + this.gvridx);){
            if (sql.next()) {
                this.code = sql.getString(1);
                this.name = sql.getString(2);
                this.rcidx = sql.getLong(3);
                this.rangeSuspended = sql.getBoolean(11);
                this.rangeAtStore = sql.getBoolean(14);
                switch (sql.getInt(4)) {
                    case 0: {
                        this.issueType = IssueType.SOLD;
                        this.balanceRules = BalanceRules.RETAIN_VALUE;
                        this.nExpiryMonths = sql.getInt(5);
                        break;
                    }
                    case 1: {
                        this.issueType = IssueType.SOLD;
                        this.balanceRules = BalanceRules.GIVE_CHANGE;
                        this.nExpiryMonths = sql.getInt(5);
                        break;
                    }
                    case 2: {
                        this.issueType = IssueType.PROMO;
                        this.balanceRules = BalanceRules.GIVE_CHANGE;
                        this.nValue = sql.getDouble(8);
                        this.dExpiryDate = sql.getDate(9);
                        break;
                    }
                    case 3: {
                        this.issueType = IssueType.PROMO;
                        this.balanceRules = BalanceRules.WRITE_OFF;
                        this.nValue = sql.getDouble(8);
                        this.dExpiryDate = sql.getDate(9);
                        this.issueWithSale = sql.getBoolean(13);
                        break;
                    }
                    default: {
                        this.issueType = IssueType.PROMO;
                        this.balanceRules = BalanceRules.GIVE_CHANGE;
                        this.nValue = sql.getDouble(8);
                        this.dExpiryDate = sql.getDate(9);
                    }
                }
                this.isSecure = sql.getBoolean(10);
                this.useCheckDigit = sql.getBoolean(12);
                this.nFromNum = sql.getLong(6);
                this.nToNum = sql.getLong(7);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public double getValuePromo(long nVouchNum) {
        if (this.issueType == IssueType.PROMO) {
            return this.nValue;
        }
        return -1.0;
    }

    public Date getExpiryPromo(long nVouchNum) {
        if (this.issueType == IssueType.PROMO) {
            return this.dExpiryDate;
        }
        return null;
    }

    public Date calcExpirySold() {
        if (this.nExpiryMonths == 0) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        int nDay = cal.get(5);
        cal.set(5, 1);
        cal.add(2, this.nExpiryMonths);
        if (this.getLastDayOfMonth(cal) < nDay) {
            cal.add(2, 1);
        } else {
            cal.set(5, nDay);
        }
        Date dSqlDate = new Date(cal.getTime().getTime());
        return dSqlDate;
    }

    private int getLastDayOfMonth(GregorianCalendar inCalender) {
        int lastDay = 0;
        switch (inCalender.get(2)) {
            case 0: {
                lastDay = 31;
                break;
            }
            case 1: {
                if (inCalender.isLeapYear(inCalender.get(1))) {
                    lastDay = 29;
                    break;
                }
                lastDay = 28;
                break;
            }
            case 2: {
                lastDay = 31;
                break;
            }
            case 3: {
                lastDay = 30;
                break;
            }
            case 4: {
                lastDay = 31;
                break;
            }
            case 5: {
                lastDay = 30;
                break;
            }
            case 6: {
                lastDay = 31;
                break;
            }
            case 7: {
                lastDay = 31;
                break;
            }
            case 8: {
                lastDay = 30;
                break;
            }
            case 9: {
                lastDay = 31;
                break;
            }
            case 10: {
                lastDay = 30;
                break;
            }
            case 11: {
                lastDay = 31;
            }
        }
        return lastDay;
    }

    public String toString() {
        return this.showName ? this.name : this.code;
    }

    public String getBalanceRulesText() {
        if (this.balanceRules == BalanceRules.GIVE_CHANGE) {
            return this.GIVE_CHANGE_MSG;
        }
        if (this.balanceRules == BalanceRules.RETAIN_VALUE) {
            return this.RETAIN_VALUE_TEXT;
        }
        if (this.balanceRules == BalanceRules.WRITE_OFF) {
            return this.WRTIE_OFF_TEXT;
        }
        return "";
    }

    public static enum IssueType {
        SOLD,
        PROMO;

    }

    public static enum BalanceRules {
        RETAIN_VALUE,
        GIVE_CHANGE,
        WRITE_OFF;

    }
}

