/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jpos.PosComboBox;
import jpos.PosUtils;

public class AutoSuggestCombo<T>
extends JPanel {
    private final JTextField tf;
    private final PosComboBox<T> combo = new PosComboBox();
    private Vector<T> values = new Vector();
    private boolean hide_flag = false;

    public AutoSuggestCombo(Vector<T> vals) {
        super(new BorderLayout());
        this.values = vals;
        this.combo.setEditable(true);
        this.tf = (JTextField)this.combo.getEditor().getEditorComponent();
        this.setModel(new DefaultComboBoxModel<T>(this.values), "");
        this.setLayout(new GridBagLayout());
        this.add(this.combo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.combo.setMaximumRowCount(10);
        this.tf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String text = AutoSuggestCombo.this.tf.getText();
                        if (text.length() == 0) {
                            AutoSuggestCombo.this.combo.hidePopup();
                            AutoSuggestCombo.this.setModel(new DefaultComboBoxModel(AutoSuggestCombo.this.values), "");
                        } else {
                            DefaultComboBoxModel m = AutoSuggestCombo.this.getSuggestedModel(AutoSuggestCombo.this.values, text.toUpperCase());
                            if (m.getSize() == 0 || AutoSuggestCombo.this.hide_flag) {
                                AutoSuggestCombo.this.combo.hidePopup();
                                AutoSuggestCombo.this.hide_flag = false;
                            } else {
                                AutoSuggestCombo.this.setModel(m, text);
                                AutoSuggestCombo.this.combo.showPopup();
                            }
                        }
                    }
                });
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 27) {
                    AutoSuggestCombo.this.hide_flag = true;
                } else if (code == 10) {
                    AutoSuggestCombo.this.hide_flag = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String text = AutoSuggestCombo.this.tf.getText();
                            DefaultComboBoxModel m = AutoSuggestCombo.this.getSuggestedModel(AutoSuggestCombo.this.values, text.toUpperCase());
                            AutoSuggestCombo.this.setModel(m, text);
                        }
                    });
                }
            }
        });
        this.tf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String docStr = AutoSuggestCombo.this.tf.getText();
                            String[] tokens = docStr.split(" ");
                            if (!AutoSuggestCombo.this.tf.getText().trim().equals("") && tokens.length > 2 && tokens[tokens.length - 1].matches("[0-9]*")) {
                                String str = "";
                                for (int i = 0; i < tokens.length - 2; ++i) {
                                    str = str + " " + tokens[i];
                                }
                                AutoSuggestCombo.this.setSelectedItem(str);
                            }
                        }
                        catch (Exception ex) {
                            PosUtils.logError(ex);
                        }
                    }
                });
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void setModel(DefaultComboBoxModel<T> mdl, String str) {
        this.combo.setModel(mdl);
        this.combo.setSelectedIndex(-1);
        this.tf.setText(str);
    }

    private DefaultComboBoxModel<T> getSuggestedModel(Vector<T> values, String text) {
        DefaultComboBoxModel<T> m = new DefaultComboBoxModel<T>();
        for (int i = 0; i < values.size(); ++i) {
            if (!values.get(i).toString().toUpperCase().startsWith(text)) continue;
            m.addElement(values.get(i));
        }
        return m;
    }

    public void addActionListener(ActionListener actionListener) {
        this.combo.addActionListener(actionListener);
    }

    public Object getSelectedItem() {
        return this.combo.getSelectedItem();
    }

    public void setSelectedItem(String s) {
        this.tf.setText(s != null ? s.trim() : "");
    }

    public JTextField getTextField() {
        return this.tf;
    }

    public PosComboBox<T> getComboBox() {
        return this.combo;
    }

    public void reset(Vector<T> vals) {
        this.reset(vals, "");
    }

    public void reset(Vector<T> vals, String selectedText) {
        this.combo.hidePopup();
        this.values = vals;
        this.setModel(new DefaultComboBoxModel<T>(vals), selectedText);
    }

    public void setFieldWidth(int fieldWidth) {
        this.combo.setFieldWidth(fieldWidth);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.combo.setEnabled(enabled);
        this.tf.setEnabled(enabled);
    }
}

