/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;

public class Currency {
    private String idx;
    private String code;
    private String denominations;
    private String detailFormatPattern;
    private DecimalFormat detailFormat;
    private String totalFormatPattern;
    private DecimalFormat totalFormat;
    private int precision;
    private String symbol;

    public String getIdx() {
        return this.idx;
    }

    public String getCode() {
        return this.code;
    }

    public String getDenominations() {
        return this.denominations;
    }

    public synchronized String formatDetail(double amount) {
        return this.formatDetailNoScale(PosUtils.scale(amount, this.precision));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String formatDetailNoScale(double amount) {
        DecimalFormat decimalFormat = this.detailFormat;
        synchronized (decimalFormat) {
            return this.detailFormat.format(amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number parseDetail(String value) throws ParseException {
        DecimalFormat decimalFormat = this.detailFormat;
        synchronized (decimalFormat) {
            return this.detailFormat.parse(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecimalFormatSymbols getDetailDecimalFormatSymbols() {
        DecimalFormat decimalFormat = this.detailFormat;
        synchronized (decimalFormat) {
            return this.detailFormat.getDecimalFormatSymbols();
        }
    }

    public DecimalFormat generateDetailFormat() {
        return new DecimalFormat(this.detailFormatPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String formatTotal(double amount) {
        DecimalFormat decimalFormat = this.totalFormat;
        synchronized (decimalFormat) {
            return this.totalFormat.format(PosUtils.scale(amount, this.precision));
        }
    }

    public DecimalFormat generateTotalFormat() {
        return new DecimalFormat(this.totalFormatPattern);
    }

    public int getPrecision() {
        return this.precision;
    }

    public double round(double amount) {
        return PosUtils.scale(amount, this.precision);
    }

    public double roundEven(double num) {
        BigDecimal correction = new BigDecimal("0.00000000000001");
        BigDecimal bdNum = num >= 0.0 ? new BigDecimal(num).add(correction) : new BigDecimal(num).subtract(correction);
        bdNum = bdNum.multiply(BigDecimal.valueOf(Math.pow(10.0, this.precision)));
        bdNum = new BigDecimal(Math.round(bdNum.doubleValue()));
        bdNum = bdNum.divide(BigDecimal.valueOf(Math.pow(10.0, this.precision)));
        bdNum = bdNum.setScale(this.precision, RoundingMode.HALF_UP);
        return bdNum.doubleValue();
    }

    public double roundEvenRecall(double num) {
        BigDecimal bdNum = new BigDecimal(num);
        bdNum = bdNum.setScale(4, RoundingMode.HALF_UP);
        bdNum = bdNum.setScale(3, RoundingMode.HALF_UP);
        bdNum = bdNum.setScale(this.precision, RoundingMode.HALF_UP);
        return bdNum.doubleValue();
    }

    public String prependSymbol(String value) {
        if (value != null && this.symbol != null && !value.contains(this.symbol)) {
            return SP.getRS("Currency_Value_With_Symbol", this.symbol, value);
        }
        return value;
    }

    public Currency(Connection conn, String idx) {
        try (SqlQuery qry = new SqlQuery(conn, "SELECT A.RCIDX, R.CODE, R.EXTEND, A.PRECN, A.FMT, A.POSDETFMT, A.POSTOTFMT, A.SYMBOL FROM AXCUR A LEFT JOIN REFCODE R ON A.RCIDX = R.RCIDX WHERE A.RCIDX = ?", idx);){
            if (qry.next()) {
                this.idx = qry.getString("RCIDX");
                this.code = StringUtils.nullToEmpty(qry.getString("CODE"));
                this.denominations = StringUtils.nullToEmpty(qry.getString("EXTEND"));
                this.precision = qry.getInt("PRECN");
                String format = qry.getString("POSDETFMT");
                if (StringUtils.isNullOrEmpty(format)) {
                    format = Currency.getDefaultCurrFormat(qry.getString("FMT"));
                }
                this.detailFormatPattern = format;
                this.detailFormat = new DecimalFormat(this.detailFormatPattern);
                format = qry.getString("POSTOTFMT");
                if (StringUtils.isNullOrEmpty(format)) {
                    format = Currency.getDefaultCurrFormat(qry.getString("FMT"));
                }
                this.totalFormatPattern = format;
                this.totalFormat = new DecimalFormat(this.totalFormatPattern);
                this.symbol = StringUtils.nullToEmpty(qry.getString("SYMBOL"));
                return;
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        this.idx = "-1";
        this.code = "<Unknown>";
        this.precision = 2;
        this.detailFormatPattern = "#0.00";
        this.detailFormat = new DecimalFormat(this.detailFormatPattern);
        this.totalFormatPattern = "#0.00";
        this.totalFormat = new DecimalFormat(this.totalFormatPattern);
        this.symbol = "";
    }

    public static String getDefaultCurrFormat(String pformat) {
        if (pformat != null) {
            while (pformat.indexOf("'") != -1) {
                String remainder = pformat.substring(pformat.indexOf("'") + 1);
                remainder = remainder.substring(remainder.indexOf("'") + 1);
                pformat = pformat.substring(0, pformat.indexOf("'"));
                pformat = pformat + remainder;
            }
            pformat = pformat.trim();
            return pformat;
        }
        return "";
    }
}

