/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jpos.Clr;
import jpos.ClrSizeTable;
import jpos.DecimalField;
import jpos.DlgKitEntry_bAccept_actionAdapter;
import jpos.DlgKitEntry_bCancel_actionAdapter;
import jpos.DlgKitEntry_bPrint_actionAdapter;
import jpos.DlgMessage;
import jpos.Kit;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.RemPosReportRun;
import jpos.Sku;
import jpos.StoreParams;
import jpos.searchfields.ProductClrSizeSearch;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class DlgKitEntry
extends PosDialog {
    ProductClrSizeSearch barcodeSearch = new ProductClrSizeSearch(this, TouchTextField.FontSize.LARGE){

        @Override
        public boolean processSku(long skuidx, String barcode) {
            return DlgKitEntry.this.insertStyleLine(barcode);
        }
    };
    private JPanel panel = new JPanel();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private PosScrollPane scrollPane = new PosScrollPane();
    private ClrSizeTable tblStyles = new ClrSizeTable(this, true);
    private Vector<Sku> retSkus;
    private Kit kit;
    private DialogButton bAccept = new DialogButton("");
    private DialogButton bPrint = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private DecimalField tfTotal = new DecimalField(StoreParams.qtyFormat, 4, TouchTextField.FontSize.LARGE);
    private LabelSubHeading lTotal = new LabelSubHeading();

    public DlgKitEntry(PosFrame frame, String title, boolean modal, Kit pKit, Vector<Sku> skus) {
        super(frame, title, modal);
        this.retSkus = skus;
        this.kit = pKit;
        try {
            this.jbInit();
            this.barcodeSearch.getBarcodeSearchField().requestFocus();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() throws Exception {
        this.tfTotal.setFieldWidth(100);
        this.tfTotal.setEnabled(false);
        this.panel.setLayout(this.gridBagLayout);
        this.bAccept.setText(StoreParams.res.getString("F9_Accept"));
        this.bAccept.addActionListener(new DlgKitEntry_bAccept_actionAdapter(this));
        this.bPrint.setText(StoreParams.res.getString("Alt+P_Print"));
        this.bPrint.addActionListener(new DlgKitEntry_bPrint_actionAdapter(this));
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new DlgKitEntry_bCancel_actionAdapter(this));
        this.lTotal.setText(StoreParams.res.getString("Total") + " ");
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.barcodeSearch.getSearchPanel(), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.panel.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 3, 1, 2.0, 1.0, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        JPanel panelTotal = new JPanel(new GridBagLayout());
        panelTotal.add((Component)this.lTotal, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelTotal.add((Component)this.tfTotal, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)panelTotal, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.bCancel, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.bPrint, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.bAccept, new GridBagConstraints(2, 3, 1, 1, 0.5, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.scrollPane.getViewport().add((Component)this.tblStyles, null);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize.width * 3 / 4, screenSize.height * 2 / 3);
        PosUtils.centreWindow(this);
        this.validate();
        this.tblStyles.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                DlgKitEntry.this.tfTotal.setText(DlgKitEntry.this.tblStyles.getQty());
            }
        });
        this.tblStyles.setPopulateMethod(3);
        boolean errorShown = false;
        Vector<Kit.KitDet> kitDets = this.kit.getKitDets();
        double oldPrice = -1.0;
        long oldClridx = -1L;
        for (int i = 0; i < kitDets.size(); ++i) {
            Kit.KitDet kitDet = kitDets.elementAt(i);
            int row = this.tblStyles.add_sku(kitDet.skuidx, 0.0, kitDet.price == oldPrice && kitDet.clridx == oldClridx);
            if (row > 0) {
                Sku sku = this.tblStyles.getSku(kitDet.skuidx);
                sku.clr.setDecrip(kitDet.description);
                sku.clr.style.taxPer = kitDet.tax;
                sku.clr.style.disc = kitDet.discount;
                sku.setPrice(kitDet.price);
                sku.setOrigPrice(kitDet.origPrice);
            } else if (!errorShown) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("invalid_kit"), objs), StoreParams.res.getString("Error"), 0);
                errorShown = true;
            }
            oldClridx = kitDet.clridx;
            oldPrice = kitDet.price;
        }
        this.tblStyles.hideUnusedCoulmns();
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 83 && e.isAltDown()) {
            this.barcodeSearch.getBarcodeSearchField().requestFocus();
        } else if (e.getKeyCode() == 120) {
            this.bAccept.doClick();
        } else if (e.getKeyCode() == 80 && e.isAltDown()) {
            this.bPrint.doClick();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void okDialog() {
    }

    @Override
    public void cancelDialog() {
        this.bCancel.doClick();
    }

    protected boolean insertStyleLine(String barcode) {
        if (this.tblStyles.isEditing()) {
            this.tblStyles.getCellEditor().stopCellEditing();
        }
        if (!barcode.equals("") && !barcode.equals(StoreParams.invalidBarcode)) {
            if (this.tblStyles.add_EAN(this.barcodeSearch.getBarcodeSearchField().getText(), true) == -1) {
                DlgMessage.showMessage(this, StoreParams.res.getString("no_kit_style"), StoreParams.res.getString("Stop"), 2);
            }
            return true;
        }
        return false;
    }

    void bAccept_actionPerformed(ActionEvent e) {
        if (this.tblStyles.isEditing()) {
            this.tblStyles.getCellEditor().stopCellEditing();
        }
        int rowCnt = this.tblStyles.getRowCount();
        for (int i = 0; i < rowCnt; ++i) {
            Object line = this.tblStyles.getItemAt(i);
            if (!(line instanceof Clr)) continue;
            Clr clr = (Clr)line;
            for (int z = 0; z < clr.style.sizes.size(); ++z) {
                if (clr.getSku(z) == null || !(clr.getSku(z).getQty() > 0.0)) continue;
                this.retSkus.add(clr.getSku(z));
            }
        }
        this.dispose();
    }

    void bPrint_actionPerformed(ActionEvent e) {
        this.bPrint.setEnabled(false);
        this.setCursor(this.sParams.commsCursor);
        RemPosReportRun remPosReportRun = this.kit.getKitType() == Kit.KitType.RETAIL ? new RemPosReportRun(this.sParams.conn, null, true, this.sParams.iconn, 1, "RetKitReportRetailPrice", this.frParent.getUser().getMemidx(), " H.IDX = " + this.kit.getKitidx()) : new RemPosReportRun(this.sParams.conn, null, true, this.sParams.iconn, 1, "RetKitReport", this.frParent.getUser().getMemidx(), " H.IDX = " + this.kit.getKitidx());
        remPosReportRun.doPrint();
        remPosReportRun.Close();
        this.setCursor(StoreParams.normalCursor);
        this.bPrint.setEnabled(true);
    }

    void bCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

