/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jpos.ErrorHandler;
import jpos.PosDateFormatter;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.ui.TouchTextArea;

public class FrErrors
extends JFrame {
    private final int LOGS_PER_HOUR = 20;
    private long nTimePlusHour = 0L;
    private int nLogsRemaining = 20;
    private String fileName;
    private ErrorHandler.ErrorLogging errorLogging;
    private Connection con;
    private Connection originalConnection;
    private String tillnum = "";
    private long widx = 0L;
    protected static StringBuffer sbEmailText = new StringBuffer();
    private PosDateFormatter dateFormatter = new PosDateFormatter(null);
    private TextArea aTextArea = new TextArea();
    private ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
    private FilteredStream filteredStream = new FilteredStream(this.byteArrayStream);
    private PrintStream aPrintStream = new PrintStream(this.filteredStream);
    private JPanel jPanel1 = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel panelTop = new JPanel();
    private JPanel panelBottom = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private TouchTextArea jTextArea1 = new TouchTextArea();

    public static void shutdown() {
        for (int i = 0; i < 20 && sbEmailText.length() != 0; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void logToFileOnly(String text) {
        this.filteredStream.logToFileOnly(text);
    }

    public FrErrors(Connection con, ErrorHandler.ErrorLogging errorLogging, String fileName, int closeOperation) {
        this.originalConnection = con;
        try {
            this.con = StoreParams.createNewConnection();
        }
        catch (Exception e1) {
            this.con = this.originalConnection;
        }
        this.fileName = fileName;
        this.errorLogging = errorLogging;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        try {
            this.tillnum = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            // empty catch block
        }
        System.setOut(this.aPrintStream);
        System.setErr(this.aPrintStream);
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable ex) {
                System.out.print(MessageFormat.format("Uncaught exception in thread {0}\r\nException data: {1}", t.getName(), PosUtils.getStackTrace(ex)));
            }
        });
        if (errorLogging == ErrorHandler.ErrorLogging.ScreenAndFile) {
            this.setDefaultCloseOperation(closeOperation);
            Toolkit tk = Toolkit.getDefaultToolkit();
            ArrayList<Image> list = new ArrayList<Image>();
            list.add(tk.getImage("images/ap21_pos_16x16.png"));
            list.add(tk.getImage("images/ap21_pos_32x32.png"));
            this.setIconImages(list);
        }
        try {
            this.dateFormatter.setTimestamp(new Timestamp(new Date().getTime()));
            StringBuffer header = new StringBuffer();
            header.append(FrErrors.padRight("_", 80).replace(' ', '_') + "\r\n\r\n");
            header.append(String.format("Application started on %s running on machine %s for store '%s'.\r\n", this.dateFormatter.toString(), InetAddress.getLocalHost().getHostName().toUpperCase(), Settings.getStoreNo()));
            header.append(FrErrors.padRight("_", 80).replace(' ', '_') + "\r\n");
            this.filteredStream.writeToLogFile(header.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    private void logErrorInDB() throws Exception {
        block53: {
            try (SqlQuery sqlMain = new SqlQuery(this.con, "SELECT " + PosUtils.nextValSyntax("XBLOBTEXT") + " FROM DUAL");){
                if (!sqlMain.next()) break block53;
                long blobidx = sqlMain.getLong(1) * -1L;
                if (this.widx == 0L) {
                    try (SqlQuery sql = new SqlQuery(this.con, "SELECT W.WIDX FROM STOREPARAMS S, WHSE W WHERE W.STORENO = S.STORENO");){
                        if (sql.next()) {
                            this.widx = sql.getLong(1);
                        }
                    }
                }
                if (this.nLogsRemaining == 1) {
                    sbEmailText.append("\r\nMAXIMUM LOGS PER HOUR REACHED\r\n");
                }
                long erridx = 0L;
                try (SqlQuery sql = new SqlQuery(this.con, "SELECT " + PosUtils.nextValSyntax("XPOS_ERRORS") + " FROM DUAL");){
                    if (sql.next()) {
                        erridx = sql.getLong(1);
                    }
                }
                var8_13 = null;
                try (Statement stmt = this.con.createStatement();){
                    stmt.executeUpdate("INSERT INTO BLOBTEXT(BLOBIDX, BLOBTEXT) VALUES(" + blobidx + "," + PosUtils.StringToSqlString(sbEmailText.toString()) + ")");
                    stmt.executeUpdate("INSERT INTO POS_ERRORS(IDX, WIDX, MACHINE_NAME, ERRDATE, BLOBIDX, VERSION)VALUES(" + erridx + ", " + this.widx + ", " + PosUtils.StringToSqlString(this.tillnum) + ", CURRENT_TIMESTAMP, " + blobidx + ", " + PosUtils.StringToSqlString(StoreParams.VERSION) + ")");
                    if (this.widx != 0L) {
                        stmt.executeUpdate("INSERT INTO YPOS_ERRORS(YIDX, IDX) VALUES(" + PosUtils.nextValSyntax("XYPOS_ERRORS") + ", " + erridx + ")");
                    }
                    --this.nLogsRemaining;
                }
                catch (Throwable throwable) {
                    var8_13 = throwable;
                    throw throwable;
                }
            }
        }
    }

    private void jbInit() throws Exception {
        this.dateFormatter.setFormat(1, 1, 2);
        this.setTitle(SP.getRS("Error_Console"));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.panelBottom.setLayout(this.gridBagLayout2);
        this.panelTop.setLayout(this.gridBagLayout3);
        this.getContentPane().setLayout(this.gridBagLayout4);
        this.panelTop.setMinimumSize(new Dimension(500, 100));
        this.panelTop.setPreferredSize(new Dimension(500, 100));
        this.panelBottom.setMinimumSize(new Dimension(500, 200));
        this.panelBottom.setPreferredSize(new Dimension(500, 200));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setBackground(UIManager.getColor("Panel.background"));
        this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints(0, 0, 0, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.panelTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelTop.add((Component)this.jTextArea1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.panelBottom, new GridBagConstraints(0, 1, 1, 300, 1.0, 2.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelBottom.add((Component)this.aTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelBottom.setVisible(false);
        this.pack();
        PosUtils.centreWindow(this);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
    }

    @Override
    public void dispose() {
        this.aPrintStream.flush();
        this.aPrintStream.close();
        try {
            this.filteredStream.close();
            this.byteArrayStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.originalConnection != this.con) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.setVisible(false);
        super.dispose();
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.dumpError(new String(b));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.dumpError(new String(b, off, len));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logToFileOnly(String text) {
            if (text == null || text.length() == 0) {
                return;
            }
            StringBuffer stringBuffer = sbEmailText;
            synchronized (stringBuffer) {
                try {
                    this.dumpError(text, ErrorHandler.ErrorLogging.FileOnly);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void dumpError(String aString) throws IOException {
            this.dumpError(aString, FrErrors.this.errorLogging);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpError(String aString, ErrorHandler.ErrorLogging loggingStyle) throws IOException {
            String sFirstLine;
            block30: {
                if (aString == null || aString.trim().length() == 0) {
                    return;
                }
                sFirstLine = null;
                long nTime = 0L;
                if (loggingStyle == ErrorHandler.ErrorLogging.ScreenAndFile) {
                    sFirstLine = SP.getRS("unexpected_error");
                }
                try (SqlQuery sql = new SqlQuery(FrErrors.this.con, "SELECT CURRENT_TIMESTAMP FROM DUAL");){
                    if (sql.next()) {
                        FrErrors.this.dateFormatter.setTimestamp(sql.getTimestamp(1));
                        nTime = FrErrors.this.dateFormatter.getTimestamp().getTime();
                        if (FrErrors.this.nTimePlusHour < nTime) {
                            FrErrors.this.nTimePlusHour = nTime + 3600000L;
                            FrErrors.this.nLogsRemaining = 20;
                        }
                    }
                    if (FrErrors.this.nLogsRemaining <= 0) break block30;
                    StringBuffer stringBuffer = sbEmailText;
                    synchronized (stringBuffer) {
                        if (sbEmailText.length() < 3900) {
                            sbEmailText.append(aString);
                            if (sbEmailText.length() > 3900) {
                                sbEmailText.setLength(3900);
                            }
                        }
                        if (sbEmailText.length() > 0) {
                            try {
                                FrErrors.this.logErrorInDB();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            sbEmailText.setLength(0);
                        }
                    }
                }
                catch (SQLException e) {
                    FrErrors.this.dateFormatter.setTimestamp(new Timestamp(new Date().getTime()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            aString = (FrErrors.this.dateFormatter.toString().equals("") ? new Date().toString() : FrErrors.this.dateFormatter.toString()) + "\r\n" + aString;
            if (loggingStyle == ErrorHandler.ErrorLogging.ScreenAndFile) {
                if (sFirstLine != null) {
                    FrErrors.this.jTextArea1.setText(sFirstLine);
                }
                if (!FrErrors.this.isVisible()) {
                    FrErrors.this.setAlwaysOnTop(true);
                    FrErrors.this.setVisible(true);
                    FrErrors.this.toFront();
                }
            }
            this.writeToLogFile(aString);
        }

        public void writeToLogFile(String aString) throws IOException {
            try (FileWriter aWriter = new FileWriter(FrErrors.this.fileName, true);){
                if (!aString.endsWith("\r\n")) {
                    aString = aString + "\r\n";
                }
                aWriter.write(aString + "\r\n");
            }
        }
    }
}

