/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.event.KeyEvent;
import jpos.PaStkEnquiry;
import jpos.PaStkEnquiryFoot;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.SP;
import jpos.StoreParams;

public class FrStkEnquiry
extends PosFrame {
    private boolean hasSockAdjustmentSecurity = false;
    private boolean hasPurcOrdersSecurity = false;
    private boolean hasTransPendingSecurity = false;

    public FrStkEnquiry(PosMenuController pmenu, StoreParams psParams) {
        super(pmenu, null, 4, 11119L, psParams, StoreParams.res.getString("Stock_Enquiry"));
        this.paBody = new PaStkEnquiry(this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaStkEnquiryFoot(this.sParams);
        this.contentPane.add((Component)this.paFoot, "South");
        this.noteTypes.clear();
        this.menuFunc.remove(this.menuNotes);
        this.setFocus();
    }

    public StockType getEffectiveStockType(StockType stockType) {
        if (stockType == StockType.INCOMING_ORDERS) {
            if (this.hasPurcOrdersSecurity && !this.hasTransPendingSecurity) {
                return StockType.PURCH_ORDERS;
            }
            if (this.hasTransPendingSecurity && !this.hasPurcOrdersSecurity) {
                return StockType.TRANS_PENDING;
            }
        }
        return stockType;
    }

    @Override
    public boolean validateTrans() {
        return false;
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        return false;
    }

    @Override
    protected void setTransType() {
    }

    @Override
    public void setFocus() {
        ((PaStkEnquiry)this.paBody).tfBarcode.requestFocus();
    }

    @Override
    public void delLines() {
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 115 && !e.isAltDown()) {
            ((PaStkEnquiryFoot)this.paFoot).bSoh.doClick();
        } else if (e.getKeyCode() == 117) {
            ((PaStkEnquiryFoot)this.paFoot).bLayby.doClick();
        } else if (e.getKeyCode() == 116) {
            ((PaStkEnquiryFoot)this.paFoot).bTrans.doClick();
        } else if (e.getKeyCode() == 119) {
            ((PaStkEnquiryFoot)this.paFoot).bRes.doClick();
        } else if (e.getKeyCode() == 122 && ((PaStkEnquiryFoot)this.paFoot).bIncOrders.isEnabled()) {
            ((PaStkEnquiryFoot)this.paFoot).bIncOrders.doClick();
        } else if (e.getKeyCode() == 118 && ((PaStkEnquiryFoot)this.paFoot).bLink.isVisible() && ((PaStkEnquiryFoot)this.paFoot).bLink.isEnabled()) {
            ((PaStkEnquiryFoot)this.paFoot).bLink.doClick();
        } else if (e.getKeyCode() == 82 && e.isAltDown() && ((PaStkEnquiryFoot)this.paFoot).bRequest.isEnabled()) {
            ((PaStkEnquiryFoot)this.paFoot).bRequest.doClick();
        } else if (e.getKeyCode() == 83 && e.isAltDown() && ((PaStkEnquiryFoot)this.paFoot).bStockAdjustment.isEnabled()) {
            ((PaStkEnquiryFoot)this.paFoot).bStockAdjustment.doClick();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void setStatusText(String msg) {
        ((PaStkEnquiryFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaStkEnquiryFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaStkEnquiryFoot)this.paFoot).statusBar.reset();
    }

    public void search(StockType pstkType) {
        ((PaStkEnquiry)this.paBody).populate(pstkType);
    }

    @Override
    public boolean populate(String docket) {
        return true;
    }

    @Override
    public boolean isVoid() {
        return true;
    }

    @Override
    protected void setEditable(boolean editable) {
    }

    @Override
    public void printReceipt(boolean reprint) {
    }

    @Override
    protected void setTransnum() {
        this.transnum = null;
    }

    public void openItem() {
        if (this.isLoggedIn(true)) {
            ((PaStkEnquiry)this.paBody).openItem(this);
        }
    }

    public void requestItem() {
        if (this.isLoggedIn(true)) {
            ((PaStkEnquiry)this.paBody).requestItem(this);
        }
    }

    public void stockAdjustment() {
        if (this.isLoggedIn(true)) {
            ((PaStkEnquiry)this.paBody).stockAdjustment(this);
        }
    }

    @Override
    protected void updateSec(boolean[] formSec) {
    }

    @Override
    public void notesSet() {
    }

    @Override
    public boolean checkExit() {
        return true;
    }

    @Override
    public void refreshImage() {
        if (((PaStkEnquiry)this.paBody).sStyleCode != null && ((PaStkEnquiry)this.paBody).sStyleCode.length() > 0) {
            this.ChangeImage(((PaStkEnquiry)this.paBody).sStyleCode, ((PaStkEnquiry)this.paBody).sStyleName);
        } else {
            this.ChangeImage("", "");
        }
    }

    @Override
    public void processLogin() {
        this.hasPurcOrdersSecurity = this.hasSecurity(11147L, 0);
        this.hasTransPendingSecurity = this.hasSecurity(11171L, 0);
        if (this.hasPurcOrdersSecurity || this.hasTransPendingSecurity) {
            ((PaStkEnquiryFoot)this.paFoot).bIncOrders.setEnabled(true);
        } else {
            ((PaStkEnquiryFoot)this.paFoot).bIncOrders.setEnabled(false);
        }
        if (this.hasSecurity(11153L, 0)) {
            ((PaStkEnquiryFoot)this.paFoot).bRequest.setEnabled(true);
        } else {
            ((PaStkEnquiryFoot)this.paFoot).bRequest.setEnabled(false);
        }
        this.hasSockAdjustmentSecurity = this.hasSecurity(11164L, 0);
        this.controlStockAdjustmentButton(((PaStkEnquiry)this.paBody).currentStockType);
        if (SP.sParams.bUsingCustOrders && this.hasSecurity(11156L, 0)) {
            ((PaStkEnquiryFoot)this.paFoot).bCustOrders.setEnabled(true);
            ((PaStkEnquiryFoot)this.paFoot).bCustOrdersPacked.setEnabled(true);
        } else {
            ((PaStkEnquiryFoot)this.paFoot).bCustOrders.setEnabled(false);
            ((PaStkEnquiryFoot)this.paFoot).bCustOrdersPacked.setEnabled(false);
        }
    }

    public void controlStockAdjustmentButton(StockType stockType) {
        ((PaStkEnquiryFoot)this.paFoot).bStockAdjustment.setEnabled(this.hasSockAdjustmentSecurity && stockType == StockType.SOH);
    }

    @Override
    public void voidTrans(boolean logout) {
        ((PaStkEnquiryFoot)this.paFoot).bIncOrders.setEnabled(false);
        ((PaStkEnquiryFoot)this.paFoot).bRequest.setEnabled(false);
        ((PaStkEnquiryFoot)this.paFoot).bStockAdjustment.setEnabled(false);
        ((PaStkEnquiryFoot)this.paFoot).bCustOrders.setEnabled(false);
        ((PaStkEnquiryFoot)this.paFoot).bCustOrdersPacked.setEnabled(false);
        ((PaStkEnquiry)this.paBody).reset();
    }

    protected static enum StockType {
        NONE,
        SOH,
        IN_TRANSIT,
        LAYBY,
        RESERVED,
        INCOMING_ORDERS,
        PURCH_ORDERS,
        TRANS_PENDING,
        CUST_ORDERS,
        CUST_ORDERS_PACKED;

    }
}

