/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Receipt;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;
import jpos.Carrier;
import jpos.DlgMessage;
import jpos.FrTransferInAbstact;
import jpos.Note;
import jpos.PaTransferFoot;
import jpos.PaTransferIn;
import jpos.PosDouble;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SkuReservation;
import jpos.SpecialOrderReceiptProcessor;
import jpos.Store;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.basscom.utils.Utils;
import org.jdom.Element;

public class FrTransferIn
extends FrTransferInAbstact {
    boolean completing = false;
    Carrier carrier = null;
    private Vector<SkuReservation> reservations = new Vector();
    private Element specialOrder = null;
    protected Element transRoot = null;

    public FrTransferIn(PosMenuController pmenu, StoreParams psParams) {
        super(pmenu, null, 3, 11103L, psParams, StoreParams.res.getString("Transfer_In"));
        this.paBody = new PaTransferIn(this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaTransferFoot(this);
        this.contentPane.add((Component)this.paFoot, "South");
        this.voidTrans(false);
    }

    @Override
    public void setFocus() {
        if (this.isLoggedIn(false)) {
            ((PaTransferIn)this.paBody).tfBarcode.requestFocus();
            this.setButtons();
        }
    }

    @Override
    protected void setTransType() {
        this.setTransType(250);
    }

    @Override
    public void setTransType(int ptype) {
        this.transType = ptype;
        if (this.paBody != null) {
            ((PaTransferIn)this.paBody).setFromField(this.transType);
            this.setButtons();
            if (this.transType == 248) {
                ((PaTransferIn)this.paBody).tfDock.setVisible(true);
                ((PaTransferIn)this.paBody).lDock.setVisible(true);
                ((PaTransferIn)this.paBody).tfBarcode.requestFocus();
                ((PaTransferIn)this.paBody).tfSupplier.setEnabled(true);
                ((PaTransferIn)this.paBody).tfBarcode.setText("");
                ((PaTransferIn)this.paBody).lFeedBack.setText(StoreParams.res.getString("Direct_Stock_Receipt"));
            } else if (this.transType == 251) {
                ((PaTransferIn)this.paBody).tfDock.setVisible(true);
                ((PaTransferIn)this.paBody).lDock.setVisible(true);
                ((PaTransferIn)this.paBody).tfBarcode.requestFocus();
                ((PaTransferIn)this.paBody).tfSupplier.setEnabled(false);
                ((PaTransferIn)this.paBody).lFeedBack.setText("");
            } else if (this.transnum != null) {
                ((PaTransferIn)this.paBody).lFeedBack.setText(StoreParams.res.getString("Transfer_") + " " + this.transnum);
            } else {
                ((PaTransferIn)this.paBody).lFeedBack.setText(StoreParams.res.getString("Stock_Transfer_In"));
            }
            if (this.transType == 1) {
                ((PaTransferIn)this.paBody).tblStyles.showReceivedCols(false);
            } else {
                ((PaTransferIn)this.paBody).tblStyles.showReceivedCols(true);
            }
        }
    }

    @Override
    public boolean validateTrans() {
        String msg;
        PaTransferIn body = (PaTransferIn)this.paBody;
        if (body.tblStyles.isEditing()) {
            body.tblStyles.getCellEditor().stopCellEditing();
        }
        if (!((PaTransferFoot)this.paFoot).bComplete.isEnabled()) {
            return false;
        }
        if (body.tblStyles.getQty() <= body.tblStyles.getOrigQty()) {
            return false;
        }
        double totalReceived = body.tblStyles.getQty() - body.tblStyles.getOrigQty();
        if (this.transType == 248 || this.transType == 251) {
            if (body.tfDock.getText().equals("")) {
                DlgMessage.showMessage(this, StoreParams.res.getString("You_must_enter_a2"));
                body.tfDock.requestFocus();
                return false;
            }
            if (body.tfSupplier.getText().length() == 0 || body.tfSupplier.getidx() <= 0L) {
                if (this.transType == 248) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("You_must_enter_a6"));
                    body.tfSupplier.requestFocus();
                    return false;
                }
                if (this.transType == 251) {
                    Object[] objs = new Object[]{"\n"};
                    DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("no_supplier"), objs));
                    return false;
                }
            }
            if (this.transType == 248 ? DlgMessage.showMessage(this, MessageFormat.format(msg = StoreParams.res.getString(totalReceived > 1.0 ? "units_received_docket" : "unit_received_docket"), PosDouble.valueOf(totalReceived, 4), body.tfSupplier.getDesc(), "\n", body.tfDock.getText()), StoreParams.res.getString("Confirm_rec"), 2, 3) != 0 : DlgMessage.showMessage(this, MessageFormat.format(msg = StoreParams.res.getString(totalReceived > 1.0 ? "units_received" : "unit_received"), PosDouble.valueOf(totalReceived, 4), body.tfSupplier.getDesc()), StoreParams.res.getString("Confirm_rec"), 2, 3) != 0) {
                return false;
            }
        } else {
            if (body.tfWhse.getidx() <= 0L) {
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("no_from_store_contact_support"), "\n"));
                return false;
            }
            msg = StoreParams.res.getString(totalReceived > 1.0 ? "units_received" : "unit_received");
            if (DlgMessage.showMessage(this, MessageFormat.format(msg, PosDouble.valueOf(totalReceived, 4), body.tfWhse.getDesc()), StoreParams.res.getString("Confirm_rec"), 2, 3) != 0) {
                return false;
            }
        }
        try {
            this.setCursor(StoreParams.waitCursor);
            Vector<StyleLine> styleLines = new Vector<StyleLine>();
            for (int i = 0; i < body.tblStyles.getRowCount(); ++i) {
                if (!(body.tblStyles.getItemAt(i) instanceof StyleLine)) continue;
                styleLines.add((StyleLine)body.tblStyles.getItemAt(i));
            }
            this.reservations = SkuReservation.allocateTransfersToReservations(styleLines);
            if (this.reservations.size() > 0) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("stk_reserved"), objs), StoreParams.res.getString("Reserved_Stock"), 1);
            }
            this.specialOrder = SpecialOrderReceiptProcessor.loadSpecialOrderFromPurchaseOrder(this.pordidx);
            if (this.specialOrder != null) {
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("SpecialOrder_stk"), "\n"), StoreParams.res.getString("Reserved_Stock"), 1);
            }
            this.setCursor(StoreParams.normalCursor);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            this.setCursor(StoreParams.normalCursor);
        }
        return true;
    }

    @Override
    public boolean completeTrans() {
        if (this.completing) {
            return false;
        }
        this.completing = true;
        try {
            boolean bl = super.completeTrans();
            return bl;
        }
        finally {
            this.completing = false;
        }
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        try {
            String from_widx = this.transType == 250 && ((PaTransferIn)this.paBody).tfWhse.getidx() > 0L ? String.valueOf(((PaTransferIn)this.paBody).tfWhse.getidx()) : "null";
            String supplier = this.transType != 250 && ((PaTransferIn)this.paBody).tfSupplier.getidx() >= 0L ? String.valueOf(((PaTransferIn)this.paBody).tfSupplier.getidx()) : "null";
            String db_carrier = this.carrier == null || this.carrier.getId() <= 0L ? "null" : String.valueOf(this.carrier.getId());
            String db_pordidx = this.pordidx == -1L ? "null" : String.valueOf(this.pordidx);
            try {
                PosUtils.startTrans(this.sParams.conn);
                this.vhidx = this.sParams.nextVal("XRET_TRANH");
                Statement stmt = this.sParams.conn.createStatement();
                Iterator iterator = null;
                try {
                    stmt.executeUpdate(" INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRANS_NUMBER, TRAND,  SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, DOCKET_NUMBER, COMPLETE,  TILL_NUMBER, FROM_WIDX, SUPPLIERIDX, TO_WIDX, CARRIERIDX, PORDIDX, SALE_DATE) VALUES( " + this.vhidx + ", " + this.transType + ", 1, " + this.sParams.getStoreIdx() + ", " + PosUtils.StringToSqlString(this.transnum) + ", current_timestamp, " + " " + this.getUser().getPeridx() + "," + this.getUser().getMemidx() + ", " + this.getUser().getPeridx() + "," + this.getUser().getMemidx() + ", " + (this.docknum == null ? "null" : PosUtils.StringToSqlString(this.docknum)) + ", 0, " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", " + from_widx + ", " + supplier + ", " + from_widx + ", " + db_carrier + ", " + db_pordidx + ", TRUNC_DATE(current_timestamp))");
                    Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.vhidx);
                    ((PaTransferIn)this.paBody).tblStyles.db_insertLines(this.transType);
                    stmt.executeUpdate("UPDATE RET_TRANH SET COMPLETE = 1 WHERE VHIDX = " + this.sParams.currVal("XRET_TRANH") + ";");
                    this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.sParams.currVal("XRET_TRANH"));
                }
                catch (Throwable throwable) {
                    iterator = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (iterator != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)iterator)).addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                PosUtils.endTrans(this.sParams.conn);
            }
            catch (Exception e) {
                PosUtils.releaseTrans(this.sParams.conn);
                PosUtils.logError(e);
                return false;
            }
            Vector<SkuReservation> reservationsToPrint = new Vector<SkuReservation>();
            for (SkuReservation reservation : this.reservations) {
                reservation.updateAvailQty();
                boolean markedToPrint = false;
                for (SkuReservation reservationToPrint : reservationsToPrint) {
                    if (reservationToPrint.getVhidx() != reservation.getVhidx()) continue;
                    markedToPrint = true;
                    break;
                }
                if (markedToPrint) continue;
                reservationsToPrint.add(reservation);
            }
            for (SkuReservation reservationToPrint : reservationsToPrint) {
                reservationToPrint.printStoreDocket(this, true);
            }
            SpecialOrderReceiptProcessor.printSpecialOrder(this, this.specialOrder);
            return true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    protected void setButtons() {
        if (((PaTransferIn)this.paBody).tblStyles.getRowCount() > 0 || this.transType != 250) {
            ((PaTransferFoot)this.paFoot).bVoid.setEnabled(true);
        } else {
            ((PaTransferFoot)this.paFoot).bVoid.setEnabled(false);
        }
        if (this.transRoot == null) {
            ((PaTransferFoot)this.paFoot).bPrintCheckList.setEnabled(false);
        } else if (this.transType == 1) {
            ((PaTransferFoot)this.paFoot).bPrintCheckList.setEnabled(false);
        } else {
            ((PaTransferFoot)this.paFoot).bPrintCheckList.setEnabled(true);
        }
        if (this.transType == 250) {
            ((PaTransferFoot)this.paFoot).bImport.setEnabled(this.transnum != null);
        } else if (this.transType == 251) {
            ((PaTransferFoot)this.paFoot).bImport.setEnabled(this.pordidx > 0L);
        } else {
            ((PaTransferFoot)this.paFoot).bImport.setEnabled(this.transType == 248);
        }
        if (this.docknum == null) {
            if (((PaTransferIn)this.paBody).tblStyles.getRowCount() > 0 && this.transType != 1) {
                ((PaTransferFoot)this.paFoot).bDelete.setEnabled(true);
            } else {
                ((PaTransferFoot)this.paFoot).bDelete.setEnabled(false);
            }
            if (((PaTransferIn)this.paBody).tblStyles.getQty() > ((PaTransferIn)this.paBody).tblStyles.getOrigQty()) {
                ((PaTransferFoot)this.paFoot).bComplete.setEnabled(true);
            } else {
                ((PaTransferFoot)this.paFoot).bComplete.setEnabled(false);
            }
            if (this.transType == 248) {
                ((PaTransferFoot)this.paFoot).bRecAll.setEnabled(false);
                ((PaTransferFoot)this.paFoot).bDirect.setEnabled(false);
            } else {
                if (((PaTransferIn)this.paBody).tblStyles.getRowCount() > 0 && this.transType != 1) {
                    ((PaTransferFoot)this.paFoot).bRecAll.setEnabled(true);
                } else {
                    ((PaTransferFoot)this.paFoot).bRecAll.setEnabled(false);
                }
                if (this.transType == 251 || this.transnum != null) {
                    ((PaTransferFoot)this.paFoot).bDirect.setEnabled(false);
                } else {
                    ((PaTransferFoot)this.paFoot).bDirect.setEnabled(true);
                }
            }
        }
    }

    @Override
    public void voidTrans(boolean logout) {
        if (!logout || this.isLoggedIn(!logout)) {
            super.voidTrans(logout);
            this.transRoot = null;
            this.carrier = null;
            this.pordidx = -1L;
            this.reservations.clear();
            this.specialOrder = null;
            ((PaTransferIn)this.paBody).tblStyles.clear();
            ((PaTransferIn)this.paBody).tfWhse.setEnabled(false);
            ((PaTransferIn)this.paBody).tfWhse.clear();
            ((PaTransferIn)this.paBody).tfSupplier.setEnabled(false);
            ((PaTransferIn)this.paBody).tfSupplier.clear();
            ((PaTransferIn)this.paBody).lFrom.setText(StoreParams.res.getString("From"));
            ((PaTransferIn)this.paBody).tfDock.setVisible(false);
            ((PaTransferIn)this.paBody).lDock.setVisible(false);
            ((PaTransferIn)this.paBody).tfBarcode.setText("");
            ((PaTransferIn)this.paBody).tfDock.setText("");
            ((PaTransferIn)this.paBody).lFeedBack2.clear();
            ((PaTransferIn)this.paBody).lFeedBack.setForeground(this.getDefaultColor());
            ((PaTransferIn)this.paBody).tblStyles.showReceivedCols(true);
            this.setButtons();
        }
    }

    @Override
    public void delLines() {
        if (((PaTransferFoot)this.paFoot).bDelete.isEnabled()) {
            ((PaTransferIn)this.paBody).delLines();
            this.setFocus();
        }
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 116) {
            ((PaTransferFoot)this.paFoot).bDirect.doClick();
        } else if (e.getKeyCode() == 119) {
            if (((PaTransferFoot)this.paFoot).bRecAll.isVisible()) {
                ((PaTransferFoot)this.paFoot).bRecAll.doClick();
            }
        } else if (e.getKeyCode() == 117) {
            if (e.isAltDown()) {
                ((PaTransferFoot)this.paFoot).bTransferOrders.doClick();
            } else {
                ((PaTransferFoot)this.paFoot).bSearch.doClick();
            }
        } else if (e.getKeyCode() == 118 && ((PaTransferFoot)this.paFoot).bPrintCheckList.isEnabled()) {
            ((PaTransferFoot)this.paFoot).bPrintCheckList.doClick();
        } else if (e.getKeyCode() == 115) {
            ((PaTransferFoot)this.paFoot).bSearchPO.doClick();
        } else if ((this.transType == 251 || this.transType == 250 || this.transType == 248) && e.getKeyCode() == 73 && e.isAltDown()) {
            ((PaTransferFoot)this.paFoot).bImport.doClick();
        } else {
            return false;
        }
        return true;
    }

    public void transferSearch() {
        if (this.hasSecurity(11132L, 0)) {
            if (this.sParams.checkIConn()) {
                ((PaTransferIn)this.paBody).tfTransSearch.clear();
                boolean wasOnline = this.sParams.checkIConn();
                ((PaTransferIn)this.paBody).tfTransSearch.doSearch();
                if (wasOnline && !this.sParams.checkIConn()) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
                }
                if (((PaTransferIn)this.paBody).tfTransSearch.getidx() > 0L) {
                    ((PaTransferIn)this.paBody).tfBarcode.setText("TVHIDX" + ((PaTransferIn)this.paBody).tfTransSearch.getidx());
                    ((PaTransferIn)this.paBody).tfBarcode_actionPerformed(null);
                }
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    public void purchOrderSearch() {
        if (this.hasSecurity(11147L, 0)) {
            if (this.sParams.checkIConn()) {
                ((PaTransferIn)this.paBody).tfPurchOrderSearch.clear();
                boolean wasOnline = this.sParams.checkIConn();
                ((PaTransferIn)this.paBody).tfPurchOrderSearch.doSearch();
                if (wasOnline && !this.sParams.checkIConn()) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
                }
                if (((PaTransferIn)this.paBody).tfPurchOrderSearch.getidx() > 0L) {
                    ((PaTransferIn)this.paBody).tfBarcode.setText(((PaTransferIn)this.paBody).tfPurchOrderSearch.getText());
                    ((PaTransferIn)this.paBody).tfBarcode_actionPerformed(null);
                }
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    public void transferOrderSearch() {
        if (this.hasSecurity(11147L, 0)) {
            if (this.sParams.checkIConn()) {
                ((PaTransferIn)this.paBody).tfTransferOrderSearch.clear();
                boolean wasOnline = this.sParams.checkIConn();
                ((PaTransferIn)this.paBody).tfTransferOrderSearch.doSearch();
                if (wasOnline && !this.sParams.checkIConn()) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
                }
                if (((PaTransferIn)this.paBody).tfTransferOrderSearch.getidx() > 0L) {
                    ((PaTransferIn)this.paBody).tfBarcode.setText("O" + ((PaTransferIn)this.paBody).tfTransferOrderSearch.getidxStr());
                    ((PaTransferIn)this.paBody).tfBarcode_actionPerformed(null);
                }
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    @Override
    public void setStatusText(String msg) {
        ((PaTransferFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaTransferFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaTransferFoot)this.paFoot).statusBar.reset();
    }

    @Override
    public boolean isVoid() {
        return ((PaTransferIn)this.paBody).tblStyles.getRowCount() == 0 && this.transnum == null && ((PaTransferIn)this.paBody).tfDock.getText().equals("");
    }

    @Override
    protected void setEditable(boolean peditable) {
        super.setEditable(peditable);
        ((PaTransferIn)this.paBody).tblStyles.setEditable(this.editable);
        ((PaTransferIn)this.paBody).tfWhse.setEnabled(this.editable);
        ((PaTransferIn)this.paBody).tfSupplier.setEnabled(this.editable);
        ((PaTransferIn)this.paBody).tfDock.setEnabled(this.editable);
        ((PaTransferFoot)this.paFoot).bComplete.setEnabled(this.editable);
        ((PaTransferFoot)this.paFoot).bDelete.setEnabled(this.editable);
        ((PaTransferFoot)this.paFoot).bDirect.setEnabled(this.editable);
        ((PaTransferFoot)this.paFoot).bRecAll.setEnabled(this.editable);
    }

    @Override
    public boolean populate(Element trans) {
        try {
            if (super.populate(trans)) {
                Store store;
                String storeno = "000";
                if (trans.getAttribute("widx") != null && (store = ((PaTransferIn)this.paBody).getTransferInStore(trans.getAttribute("widx").getLongValue())) != null) {
                    storeno = store.getStoreNo();
                }
                ((PaTransferIn)this.paBody).tfWhse.clear();
                ((PaTransferIn)this.paBody).tfSupplier.clear();
                if (this.transType == 248 || this.transType == 251) {
                    ((PaTransferIn)this.paBody).tfDock.setText(trans.getAttribute("trans_number").getValue());
                    if (trans.getAttribute("supplieridx") != null) {
                        boolean bFound = false;
                        for (int j = 0; j < ((PaTransferIn)this.paBody).suppliers.size(); ++j) {
                            if (((PaTransferIn)this.paBody).suppliers.elementAt(j).getIdx() != trans.getAttribute("supplieridx").getLongValue()) continue;
                            ((PaTransferIn)this.paBody).tfSupplier.setAll(((PaTransferIn)this.paBody).suppliers.elementAt(j).getIdx(), ((PaTransferIn)this.paBody).suppliers.elementAt(j).getCode(), ((PaTransferIn)this.paBody).suppliers.elementAt(j).getName());
                            bFound = true;
                            break;
                        }
                        if (!bFound) {
                            Object[] objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve_no_supplier_sec"), objs), StoreParams.res.getString("Error"), 0);
                            return false;
                        }
                    }
                } else if (trans.getAttribute("from_widx") != null) {
                    store = ((PaTransferIn)this.paBody).getTransferInStore(trans.getAttribute("from_widx").getLongValue());
                    if (store != null) {
                        ((PaTransferIn)this.paBody).tfWhse.setAll(store.getWidx(), store.getCode(), store.getName());
                    } else {
                        ((PaTransferIn)this.paBody).tfWhse.clear();
                    }
                }
                ((PaTransferIn)this.paBody).lFeedBack2.setText(StoreParams.res.getString("Docket_") + " D" + storeno + trans.getAttribute("docket_number").getValue());
                if (!((PaTransferIn)this.paBody).tblStyles.populate(trans)) {
                    ((PaTransferIn)this.paBody).tfBarcode.setText(StoreParams.res.getString("Error_loading"));
                    return false;
                }
                ((PaTransferIn)this.paBody).tblStyles.setOrigQtys(0.0);
                ((PaTransferIn)this.paBody).db_populateQty(trans.getAttribute("trans_number").getValue(), trans.getAttribute("vhidx").getValue());
                if (trans.getAttribute("carrier") != null) {
                    this.carrier = new Carrier(trans.getAttribute("carrier").getLongValue());
                }
            } else {
                return false;
            }
            ((PaTransferIn)this.paBody).update();
            this.setEditable(false);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    @Override
    public void printReceipt(boolean reprint) {
        Receipt r1 = new Receipt(this, StoreParams.res.getString("Printing_Transfer"), false, this.sParams.getDocketConnection(), this.vhidx, reprint);
        if (r1.isValidReceipt()) {
            r1.PrintTransferIn();
        } else {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
        }
        r1.close();
    }

    public void printCheckList() {
        Receipt r1 = new Receipt(this, StoreParams.res.getString("Printing_Check"), false, this.sParams.getDocketConnection(), 0L, false);
        r1.printTransferChecklist(this.transRoot);
        r1.close();
    }

    protected void receiptAll() {
        if (this.hasSecurity(11118L, 0)) {
            if (!this.sParams.checkIConn()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            } else {
                ((PaTransferIn)this.paBody).receiptAll();
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    @Override
    protected void setTransnum() {
        if (this.transType == 251 || this.transType == 248) {
            this.transnum = ((PaTransferIn)this.paBody).tfDock.getText();
        }
    }

    @Override
    public void notesSet() {
        for (int i = 0; i < this.notes.size(); ++i) {
            Note note = (Note)this.notes.elementAt(i);
            if (note.noteType.getTblidx() != 23L) continue;
            ((PaTransferIn)this.paBody).lFeedBack.setForeground(this.notesColor);
        }
    }

    @Override
    public boolean checkExit() {
        if (this.editable && ((PaTransferIn)this.paBody).tblStyles.model.getData().size() > 0) {
            return super.checkExit();
        }
        return true;
    }

    @Override
    public void refreshImage() {
        ((PaTransferIn)this.paBody).tblStyles.RefreshImage();
    }

    @Override
    public void processLogin() {
    }

    public void ImportBarcodes(Vector<String> vBarcodes) {
        ((PaTransferIn)this.paBody).processBarcodes(vBarcodes);
    }
}

