/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.Discount;
import jpos.PosUtils;
import jpos.Reference;
import jpos.basscom.utils.Utils;

public class LoyaltyDetails {
    private Reference loyalty = null;
    private long rollingPeriods = 0L;
    private boolean discountOnOrigPrice = false;
    private boolean managerOnly = false;
    private String restrictSql = "";
    private Vector<String> compatibleLoyalties = new Vector();
    private Discount discount = null;
    private boolean promptForAmount = false;

    public LoyaltyDetails() {
    }

    public LoyaltyDetails(Reference loyalty) {
        this.setLoyaltyDetails(loyalty);
    }

    public void setLoyaltyDetails(Reference loyalty) {
        this.loyalty = loyalty;
        if (this.loyalty != null) {
            if (this.loyalty.getIdx() == 787L) {
                this.discount = new Discount(786L, true);
                this.promptForAmount = true;
                this.restrictSql = " From STYLE S Where 1 = 1 ";
            } else {
                Vector<String> toks = new Vector<String>();
                Utils.stringTokenize(this.loyalty.getBlobText(), "\u0003", toks);
                if (toks.size() > 0) {
                    this.discount = new Discount(PosUtils.longVal(toks.elementAt(0)), true);
                }
                if (toks.size() > 1) {
                    this.rollingPeriods = PosUtils.intVal(toks.elementAt(1));
                }
                if (toks.size() > 2) {
                    Utils.stringTokenize(toks.elementAt(2), ",", this.compatibleLoyalties);
                }
                if (toks.size() > 3) {
                    this.restrictSql = Utils.stringReplace(toks.elementAt(3), "ACTIVE", "\"ACTIVE\"");
                }
                if (toks.size() > 5) {
                    this.discountOnOrigPrice = PosUtils.booleanVal(toks.elementAt(5));
                }
                if (toks.size() > 6) {
                    this.managerOnly = PosUtils.booleanVal(toks.elementAt(6));
                }
                if (toks.size() > 7) {
                    this.promptForAmount = PosUtils.booleanVal(toks.elementAt(7));
                }
            }
        }
    }

    public Reference getLoyalty() {
        return this.loyalty;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public long getRollingPeriods() {
        return this.rollingPeriods;
    }

    public boolean isDiscountOnOrigPrice() {
        return this.discountOnOrigPrice;
    }

    public boolean getManagerOnly() {
        return this.managerOnly;
    }

    public String getRestrictSql() {
        return this.restrictSql;
    }

    public Vector<String> getCompatibleLoyalties() {
        return this.compatibleLoyalties;
    }

    public boolean getPromptForAmount() {
        return this.promptForAmount;
    }

    public String toString() {
        return this.loyalty == null ? "" : this.loyalty.toString();
    }
}

