/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import javax.swing.JPanel;
import jpos.AttachedLoyaltyManager;
import jpos.DlgManualLoyaltyDiscount;
import jpos.ManualLoyaltyRedemptionPanel;
import jpos.SP;
import jpos.capillary.CapillaryLoyaltyRedemptionPanel;
import jpos.omneo.ApiLoyaltyRedemptionPanel;
import jpos.omneo.OmneoLoyaltyRedemptionPanel;
import jpos.omneo.OmneoLoyaltySetup;
import jpos.rewards.GiftRedemptionPanel;
import jpos.rewards.GiftSku;
import jpos.rewards.RewardsRedemptionPanel;
import jpos.rewards.RewardsUtils;
import org.jdom.Element;

public abstract class LoyaltyRedemptionPanel
extends JPanel {
    private AttachedLoyaltyManager.LoyaltyInfo loyaltyInfo;
    private Element person;
    private double amount = 0.0;
    private double transactionTotal = 0.0;
    private double accrueSpendTotal = 0.0;
    private DlgManualLoyaltyDiscount parentDlg;

    public LoyaltyRedemptionPanel(DlgManualLoyaltyDiscount parentDlg) {
        this.parentDlg = parentDlg;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getTransactionTotal() {
        return this.transactionTotal;
    }

    public void setTransactionTotal(double transactionTotal) {
        this.transactionTotal = transactionTotal;
    }

    public double getAccrueSpendTotal() {
        return this.accrueSpendTotal;
    }

    public void setAccrueSpendTotal(double accrueSpendTotal) {
        this.accrueSpendTotal = accrueSpendTotal;
    }

    public Element getPerson() {
        return this.person;
    }

    public void setPerson(Element person) {
        this.person = person;
    }

    public void setLoyaltyDetails(AttachedLoyaltyManager.LoyaltyInfo loyaltyInfo) {
        this.loyaltyInfo = loyaltyInfo;
    }

    public AttachedLoyaltyManager.LoyaltyInfo getLoyaltyInfo() {
        return this.loyaltyInfo;
    }

    public void setLoyaltyInfo(AttachedLoyaltyManager.LoyaltyInfo loyaltyInfo) {
        this.loyaltyInfo = loyaltyInfo;
    }

    public DlgManualLoyaltyDiscount getParentDlg() {
        return this.parentDlg;
    }

    public void load() {
    }

    public boolean validateInputs() {
        return true;
    }

    public void destroyPanel() {
    }

    public GiftSku getSelectedGift() {
        return null;
    }

    public static class LoyaltyRedemptionPanelFactory {
        public static LoyaltyRedemptionPanel create(DlgManualLoyaltyDiscount parent, long loyaltyProgramId, boolean giftMode) {
            if (RewardsUtils.usingAp21RetailRewards() && loyaltyProgramId == 787L) {
                if (giftMode) {
                    return new GiftRedemptionPanel(parent);
                }
                return new RewardsRedemptionPanel(parent);
            }
            OmneoLoyaltySetup setup = new OmneoLoyaltySetup();
            if (setup.isUsingLoyaltyRedemptionScreen(loyaltyProgramId)) {
                return new OmneoLoyaltyRedemptionPanel(parent);
            }
            if (setup.isUsingLoyaltyApi(loyaltyProgramId)) {
                return new ApiLoyaltyRedemptionPanel(parent);
            }
            if (SP.sParams.bUsingCapillaryRewards) {
                return new CapillaryLoyaltyRedemptionPanel(parent);
            }
            return new ManualLoyaltyRedemptionPanel(parent);
        }
    }
}

