/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import jpos.NoteType;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.User;
import jpos.XMLUtils;
import org.jdom.Element;

public class Note {
    public long nLogidx = 0L;
    public NoteType noteType;
    public Reference ref;
    public String sNotes;
    public Timestamp dCreated;
    private long nBlobidx;
    private String sFromTable;
    public StyleLine styleParent;
    private StoreParams sParams;
    private long memidx;
    private String loginName;

    public Note(long npLogidx, NoteType pType, User pMember, Reference pRef, String spNotes, Timestamp dpCreated, long npBlobidx, StoreParams psParams) {
        this.sParams = psParams;
        this.nLogidx = npLogidx;
        this.noteType = pType;
        this.ref = pRef;
        this.sNotes = spNotes;
        this.dCreated = dpCreated;
        this.nBlobidx = npBlobidx;
        this.memidx = pMember.getMemidx();
        this.loginName = pMember.getLoginName();
    }

    public static Note createNote(Element noteXml, Vector<NoteType> pnoteTypes) {
        long logidx = XMLUtils.getLongValue(noteXml, "logidx");
        NoteType noteType = null;
        User user = null;
        Reference ref = null;
        for (int j = 0; j < pnoteTypes.size(); ++j) {
            if (pnoteTypes.elementAt((int)j).nRcidx != XMLUtils.getLongValue(noteXml, "typeidx")) continue;
            noteType = pnoteTypes.elementAt(j);
            break;
        }
        if (noteType == null) {
            return null;
        }
        long memidx = XMLUtils.getLongValue(noteXml, "memidx");
        user = memidx != 0L ? new User(memidx, SP.sParams) : new User(SP.sParams);
        long rcidx = XMLUtils.getLongValue(noteXml, "rcidx");
        if (rcidx != 0L) {
            ref = new Reference(rcidx);
        }
        Timestamp createdDate = Timestamp.valueOf(noteXml.getAttribute("log_date").getValue());
        return new Note(logidx, noteType, user, ref, noteXml.getText(), createdDate, 0L, SP.sParams);
    }

    public void db_save() throws SQLException {
        Statement stmt;
        Throwable throwable;
        SqlQuery sql;
        String sRcidx;
        block67: {
            sRcidx = this.ref == null ? "null" : String.valueOf(this.ref.getIdx());
            if (this.sFromTable == null) {
                sql = new SqlQuery(this.sParams.conn, "SELECT LINKIDX FROM REFCODE WHERE RCIDX = " + this.noteType.nRcidx);
                throwable = null;
                try {
                    if (!sql.next()) break block67;
                    long nLinkidx = sql.getLong(1);
                    try (SqlQuery sql2 = new SqlQuery(this.sParams.conn, "SELECT TABLE_NAME FROM REFOBJ WHERE TBLIDX = " + nLinkidx);){
                        if (sql2.next()) {
                            this.sFromTable = sql2.getString(1);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (sql != null) {
                        if (throwable != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
            }
        }
        if (this.memidx == -1L) {
            if (this.sFromTable.toUpperCase().equals("RET_TRANH")) {
                sql = new SqlQuery(this.sParams.conn, "SELECT MEMBER_GENERATEDIDX FROM RET_TRANH WHERE VHIDX = " + this.noteType.getKeyIdx());
                throwable = null;
                try {
                    if (sql.next()) {
                        this.memidx = sql.getLong(1);
                    }
                    this.memidx = 1001L;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (sql != null) {
                        if (throwable != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
            } else {
                this.memidx = 1001L;
            }
        }
        if (this.nLogidx == 0L) {
            stmt = this.sParams.getStmt();
            throwable = null;
            try {
                this.nBlobidx = this.sParams.nextVal("XBLOBTEXT") * -1L;
                stmt.executeUpdate("INSERT INTO BLOBTEXT(BLOBIDX, BLOBTEXT) VALUES (" + this.nBlobidx + "," + PosUtils.StringToSqlString(this.sNotes) + ")");
                this.nLogidx = this.sParams.nextVal("XAP21LOG") * -1L;
                stmt.executeUpdate("INSERT INTO AP21LOG(LOGIDX, TYPEIDX, RCIDX, NOTES_BLOBIDX, MEMIDX, LOG_DATE, FROM_TABLE, FROMIDX, HO_OR_POS) VALUES (" + this.nLogidx + ", " + this.noteType.nRcidx + "," + sRcidx + "," + this.nBlobidx + "," + this.memidx + ",CURRENT_TIMESTAMP, " + PosUtils.StringToSqlString(this.sFromTable) + ", " + this.noteType.getKeyIdx() + ", " + (this.noteType.bKeyidxLocal ? 0 : 1) + ")");
                this.sParams.yTabInsert("AP21LOG", "LOGIDX", "" + this.nLogidx);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        stmt = this.sParams.getStmt();
        throwable = null;
        try {
            stmt.executeUpdate("UPDATE BLOBTEXT SET BLOBTEXT = " + PosUtils.StringToSqlString(this.sNotes) + " WHERE BLOBIDX = " + this.nBlobidx);
            stmt.executeUpdate("UPDATE AP21LOG SET TYPEIDX = " + this.noteType.nRcidx + ", RCIDX = " + sRcidx + ", MEMIDX = " + this.memidx + ", LOG_DATE = CURRENT_TIMESTAMP " + ", FROMIDX = " + this.noteType.getKeyIdx() + ", FROM_TABLE = " + PosUtils.StringToSqlString(this.sFromTable) + " WHERE LOGIDX = " + this.nLogidx);
            this.sParams.yTabInsert("AP21LOG", "LOGIDX", "" + this.nLogidx);
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            if (stmt != null) {
                if (throwable != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    public static Vector<Element> getNotes(long objectIdx, String tblName, Connection con) {
        Vector<Element> notes = new Vector<Element>();
        try (SqlQuery sql = new SqlQuery(con, "SELECT L.LOGIDX, L.RCIDX, L.MEMIDX, L.TYPEIDX, L.LOG_DATE, B.BLOBTEXT FROM AP21LOG L LEFT JOIN BLOBTEXT B ON L.NOTES_BLOBIDX = B.BLOBIDX WHERE L.FROMIDX = " + objectIdx + " AND UPPER(L.FROM_TABLE) = " + PosUtils.StringToSqlString(tblName) + " AND L.\"ACTIVE\" = 1 " + "ORDER BY L.LOG_DATE DESC");){
            while (sql.next()) {
                Element note = new Element("note");
                note.setAttribute("logidx", sql.getString(1));
                if (sql.getString(2) != null) {
                    note.setAttribute("rcidx", sql.getString(2));
                }
                if (sql.getString(3) != null) {
                    note.setAttribute("memidx", sql.getString(3));
                }
                note.setAttribute("typeidx", sql.getString(4));
                note.setAttribute("log_date", sql.getTimestamp(5).toString());
                if (sql.getString(6) != null) {
                    note.setText(sql.getString(6));
                }
                notes.add(note);
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        return notes;
    }

    public String toString() {
        return StringUtils.nullToEmpty(this.sNotes);
    }

    public NoteType getNoteType() {
        return this.noteType;
    }

    public String getLoginName() {
        return this.loginName;
    }
}

