/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.IOrderCountListener;
import jpos.Urgency;

public class OrderCountListener {
    private Vector<IOrderCountListener> listeners = new Vector();
    private int orderCount = 0;
    private int priorityOrderCount = 0;
    private Urgency urgency;

    public void registerListener(IOrderCountListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            listener.orderCountChanged(this.orderCount, this.urgency, this.priorityOrderCount);
        }
    }

    public void unregisterListener(IOrderCountListener listener) {
        this.listeners.remove(listener);
    }

    public void setOrderCount(int orderCount, Urgency urgency, int priorityOrderCount) {
        if (this.orderCount != orderCount || this.urgency != urgency || this.priorityOrderCount != priorityOrderCount) {
            for (IOrderCountListener listener : this.listeners) {
                listener.orderCountChanged(orderCount, urgency, priorityOrderCount);
            }
            this.orderCount = orderCount;
            this.urgency = urgency;
        }
    }

    public int getOrderCount() {
        return this.orderCount;
    }
}

