/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Receipt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import jpos.DlgImportAPNs;
import jpos.DlgMessage;
import jpos.DocumentSizeFilter;
import jpos.FrStkTake;
import jpos.PaTransferFoot;
import jpos.PosDateFormatter;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SqlQuery;
import jpos.StatusBar;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.StyleTable;
import jpos.SystemSettings;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.User;
import jpos.basscom.utils.Utils;
import jpos.searchfields.BarcodeSearchField;
import jpos.searchfields.ClrSearchField;
import jpos.searchfields.SearchPanel;
import jpos.searchfields.SizeSearchField;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class PaStkTake
extends JPanel {
    SizeSearchField tfSize = new SizeSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            String apn = "";
            try (SqlQuery sql = new SqlQuery(PaStkTake.this.sParams.conn, "SELECT DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.SKUIDX = " + this.getidx());){
                if (sql.next()) {
                    apn = sql.getString(1);
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
            PaStkTake.this.tfBarcode.clear();
            PaStkTake.this.tfBarcode.setText(apn);
            PaStkTake.this.insertStyleLineLater(apn);
        }
    };
    ClrSearchField tfClr = new ClrSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            try (SqlQuery sql = new SqlQuery(PaStkTake.this.sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + this.getidx());){
                if (sql.next()) {
                    String apn = sql.getString(2);
                    if (sql.next()) {
                        PaStkTake.this.tfSize.search(this.getidx(), PaStkTake.this.tfBarcode.getText(), this.getText());
                    } else {
                        PaStkTake.this.tfBarcode.clear();
                        PaStkTake.this.tfBarcode.setText(apn);
                        PaStkTake.this.insertStyleLineLater(apn);
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    };
    BarcodeSearchField tfBarcode = new BarcodeSearchField(TouchTextField.FontSize.LARGE){

        @Override
        public void actionSearch() {
            PaStkTake.this.search = true;
            if (this.getText().equals(StoreParams.invalidBarcode)) {
                this.setText("");
            }
            super.actionSearch();
            this.requestFocus();
            this.selectAll();
        }

        @Override
        public void actionValidate() {
            if (!PaStkTake.this.search) {
                return;
            }
            PaStkTake.this.search = false;
            if (!this.getText().equals(StoreParams.invalidBarcode)) {
                super.actionValidate();
                try (SqlQuery sqlClr = new SqlQuery(PaStkTake.this.sParams.conn, "SELECT C.CLRIDX, C.CLRNAME FROM CLR C WHERE C.STYLEIDX = " + this.getidx());){
                    if (sqlClr.next()) {
                        long clridx = sqlClr.getLong(1);
                        String clrname = sqlClr.getString(2);
                        if (sqlClr.next()) {
                            PaStkTake.this.tfClr.search(this.getidx(), this.getText());
                        } else {
                            try (SqlQuery sqlBarcode = new SqlQuery(PaStkTake.this.sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + clridx);){
                                if (sqlBarcode.next()) {
                                    String apn = sqlBarcode.getString(2);
                                    if (sqlBarcode.next()) {
                                        PaStkTake.this.tfSize.search(clridx, this.getText(), clrname);
                                    } else {
                                        PaStkTake.this.tfBarcode.clear();
                                        this.setText(apn);
                                        PaStkTake.this.insertStyleLineLater(apn);
                                    }
                                }
                            }
                        }
                    }
                    PaStkTake.this.tfBarcode.clear();
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
    };
    SearchPanel barcodeSearchPanel = new SearchPanel(this.tfBarcode);
    private boolean search = false;
    StyleTable tblStyles;
    private TotalsTable tblTotals;
    GridBagLayout gridBagLayout = new GridBagLayout();
    PosScrollPane scrollLocns = new PosScrollPane();
    StkLocnTable tblLocns;
    DialogButton bImport = new DialogButton(StoreParams.res.getString("Import_from_file"));
    DialogButton bInsert = new DialogButton(StoreParams.res.getString("Insert_a_new_stock"));
    DialogButton bDelete = new DialogButton(StoreParams.res.getString("Delete_a_stock"));
    int contextRow = -1;
    boolean populating = true;
    LabelSubHeading lFeedBack = new LabelSubHeading();
    LabelSubHeading lTot = new LabelSubHeading();
    Border border;
    LabelSubHeading lWhichTill = new LabelSubHeading();
    StringBuffer sbFilePath = new StringBuffer();
    PosFrame frParent;
    StoreParams sParams;
    DialogButton bOwnTill = new DialogButton(StoreParams.res.getString("Own_Till"));
    DialogButton bAllTills = new DialogButton(StoreParams.res.getString("All_Tills"));

    public PaStkTake(PosFrame pfrParent) {
        this.frParent = pfrParent;
        this.sParams = this.frParent.sParams;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.tblLocns = new StkLocnTable(this.frParent, new StkLocnModel());
        this.tblStyles = new StyleTable(this.frParent, null);
        this.tblStyles.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PaStkTake.this.updateTots();
            }
        });
        this.tblStyles.setAllowInvalid(true);
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblStyles.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row != 0) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        return StoreParams.totalText;
                    }
                    case 5: {
                        return new PosDouble(PaStkTake.this.tblStyles.getQty());
                    }
                }
                return "";
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblStyles, totalsTableModel);
        this.setLayout(this.gridBagLayout);
        this.tfBarcode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaStkTake.this.tfBarcode_focusGained(e);
            }
        });
        this.tfBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaStkTake.this.tfBarcode_actionPerformed(e);
            }
        });
        this.bInsert.setText(StoreParams.res.getString("Insert_F5"));
        this.bInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaStkTake.this.bInsert_actionPerformed(e);
            }
        });
        this.bImport.setText(StoreParams.res.getString("Alt_I_Import"));
        this.bImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaStkTake.this.bImport_actionPerformed(e);
            }
        });
        this.bDelete.setText(StoreParams.res.getString("Delete_F6"));
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaStkTake.this.bDelete_actionPerformed(e);
            }
        });
        this.lTot.setHorizontalAlignment(4);
        this.lTot.setText(StoreParams.res.getString("Total") + " ");
        this.scrollLocns.setRequestFocusEnabled(false);
        this.tblLocns.setRequestFocusEnabled(false);
        this.bOwnTill.setText(StoreParams.res.getString("F4_Own_Till"));
        this.bOwnTill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaStkTake.this.bOwnTill.setSelected(true);
                PaStkTake.this.bAllTills.setSelected(false);
                if (PaStkTake.this.contextRow >= 0 && PaStkTake.this.contextRow < PaStkTake.this.tblLocns.getRowCount()) {
                    ((FrStkTake)PaStkTake.this.frParent).save();
                } else if (PaStkTake.this.frParent.vhidx <= 0L) {
                    ((FrStkTake)PaStkTake.this.frParent).getCurrentVhidx();
                }
                PaStkTake.this.clear();
                PaStkTake.this.populate(PaStkTake.this.frParent.vhidx);
            }
        });
        this.bAllTills.setText(StoreParams.res.getString("F7_All_Tills"));
        this.bAllTills.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaStkTake.this.bAllTills.setSelected(true);
                PaStkTake.this.bOwnTill.setSelected(false);
                if (PaStkTake.this.contextRow >= 0 && PaStkTake.this.contextRow < PaStkTake.this.tblLocns.getRowCount()) {
                    ((FrStkTake)PaStkTake.this.frParent).save();
                } else if (PaStkTake.this.frParent.vhidx <= 0L) {
                    ((FrStkTake)PaStkTake.this.frParent).getCurrentVhidx();
                }
                PaStkTake.this.clear();
                PaStkTake.this.populate(PaStkTake.this.frParent.vhidx);
            }
        });
        this.border = BorderFactory.createLineBorder(Colours.GREY, 1);
        this.lWhichTill.setBorder(this.border);
        this.lWhichTill.setMaximumSize(new Dimension(120, 40));
        this.lWhichTill.setMinimumSize(new Dimension(120, 40));
        this.lWhichTill.setPreferredSize(new Dimension(120, 40));
        this.lWhichTill.setHorizontalAlignment(0);
        this.add((Component)this.tblStyles.getScrollPane(), new GridBagConstraints(0, 7, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 8, 4, 1, 1.0, 0.0, 15, 1, new Insets(0, 5, 10, 5), 0, 0));
        this.add((Component)this.barcodeSearchPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lWhichTill, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.scrollLocns, new GridBagConstraints(0, 2, 3, 5, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.bImport, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.bInsert, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.bDelete, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.bOwnTill, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.bAllTills, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.tfClr, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.tfSize, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.lFeedBack, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.lTot, new GridBagConstraints(1, 8, 3, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 95), 0, 0));
        this.tfClr.setVisible(false);
        this.tfSize.setVisible(false);
        this.scrollLocns.getViewport().add((Component)this.tblLocns, null);
        this.lWhichTill.setText("");
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfBarcode);
        v.add(this.tblLocns);
        v.add(this.tblStyles);
        v.add(this.tfBarcode);
        v.add(this.frParent.paHead.signInButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void insertStyleLineLater(final String barcode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PaStkTake.this.insertStyleLine(barcode);
            }
        });
    }

    private boolean insertStyleLine(String barcode) {
        if (this.contextRow != -1) {
            if (!barcode.equals("") && !barcode.equals(StoreParams.invalidBarcode)) {
                try {
                    if (this.tblStyles.addEAN(barcode, SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.CONSOLIDATE_STOCK_TAKE_LINES), true) == -1) {
                        this.tfBarcode.setText(StoreParams.invalidBarcode);
                    } else {
                        this.tfBarcode.setText("");
                    }
                    return true;
                }
                catch (NumberFormatException n) {
                    return false;
                }
            }
            return false;
        }
        if (this.tblLocns.getRowCount() == 0) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("insert_Locn"), StoreParams.res.getString("Insert_a_new_stock"), 1);
        } else {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("select_Locn2"), StoreParams.res.getString("select_a_locn"), 1);
        }
        this.tfBarcode.setText("");
        return false;
    }

    void tfBarcode_actionPerformed(ActionEvent e) {
        if (this.insertStyleLine(this.tfBarcode.getText())) {
            this.tfBarcode.requestFocus();
            this.tfBarcode.selectAll();
        }
    }

    private void updateTots() {
        if (!this.populating && this.tblLocns.getSelectedRow() >= 0 && this.tblLocns.getSelectedRow() < this.tblLocns.getRowCount() && this.tblLocns.getRowCount() > 0) {
            this.tblLocns.setValueAt(new PosDouble(this.tblStyles.getQty()), this.tblLocns.getSelectedRow(), 5);
            this.tblLocns.setValueAt(new PosDouble(this.tblStyles.getInvalidQty()), this.tblLocns.getSelectedRow(), 6);
        }
    }

    public void delStylelines() {
        int[] rows = this.tblStyles.getSelectedRows();
        int nFirstRow = -1;
        Vector<Integer> rowList = new Vector<Integer>();
        for (int i = 0; i < rows.length; ++i) {
            rowList.add(new Integer(rows[i]));
            if (i != 0) continue;
            nFirstRow = rows[i];
        }
        this.tblStyles.delLines(rowList, false, true);
        this.selectStyleRow(nFirstRow);
    }

    public void clear() {
        this.tblLocns.clear();
        this.tblLocns.model.data.clear();
        this.tblStyles.clear();
        this.contextRow = -1;
        this.lFeedBack.setText("");
    }

    private void setButtons(boolean state) {
        ((PaTransferFoot)this.frParent.paFoot).bSave.setEnabled(state);
    }

    void bInsert_actionPerformed(ActionEvent e) {
        if (this.frParent.isLoggedIn(true) && ((FrStkTake)this.frParent).checkStkTake()) {
            this.contextRow = this.tblLocns.insertLine();
            this.stopEditing();
            this.tblLocns.cellEdit(this.contextRow, 1);
            this.tblLocns.changeSelection(this.contextRow, 1, false, false);
            this.tblLocns.getCellEditor(this.contextRow, 1).cancelCellEditing();
            this.tblLocns.scrollRectToVisible(this.tblLocns.getCellRect(this.contextRow, 1, true));
            this.tblLocns.requestFocus();
            this.setButtons(true);
        }
    }

    void bDelete_actionPerformed(ActionEvent e) {
        if (this.frParent.isLoggedIn(true)) {
            int nRow = this.tblLocns.getSelectedRow();
            if (nRow >= 0) {
                if (((FrStkTake)this.frParent).checkStkTake()) {
                    if (DlgMessage.showMessage(this.frParent, StoreParams.res.getString("del_locn_confirm"), StoreParams.res.getString("del_locn"), 0, 2) != 0) {
                        return;
                    }
                    this.stopEditing();
                    ((FrStkTake)this.frParent).save();
                    try {
                        this.tblLocns.db_delLocn(this.tblLocns.getSelectedRow(), this.frParent.vhidx);
                        this.setButtons(false);
                        this.selectLocnLine(nRow);
                    }
                    catch (SQLException Sqle) {
                        PosUtils.logError(Sqle);
                    }
                }
            } else {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("select_location_Delete"), StoreParams.res.getString("Stop"), 0);
            }
            this.frParent.setFocus();
        }
    }

    void bImport_actionPerformed(ActionEvent e) {
        if (this.frParent.isLoggedIn(true)) {
            Vector<String> vTokens = new Vector<String>();
            String sAPN = "";
            String sLocation = "";
            int nTokens = 0;
            int nRepeats = 0;
            Vector<String> vAPNs = new Vector<String>();
            DlgImportAPNs.showDialog(this.frParent, StoreParams.res.getString("Import_from_file"), vAPNs, this.sbFilePath);
            for (int i = 0; i < vAPNs.size(); ++i) {
                sAPN = vAPNs.elementAt(i).trim();
                if (sAPN.length() <= 0) continue;
                nTokens = Utils.stringTokenize(sAPN, ",", vTokens);
                nRepeats = nTokens >= 2 && vTokens.elementAt(1).trim().length() > 0 ? PosUtils.intVal(vTokens.elementAt(1).trim()) : 1;
                if (nTokens >= 3 && vTokens.elementAt(2).trim().length() > 0) {
                    sLocation = vTokens.elementAt(2).trim();
                    boolean bFound = false;
                    for (int modelRow = 0; modelRow < this.tblLocns.model.data.size(); ++modelRow) {
                        Location rowdata = this.tblLocns.model.data.elementAt(modelRow);
                        if (!rowdata.location.equals(sLocation)) continue;
                        this.selectLocnLine(this.tblLocns.convertRowIndexToView(modelRow));
                        bFound = true;
                        break;
                    }
                    if (!bFound) {
                        this.bInsert.doClick();
                        Location rowdata = this.tblLocns.model.data.elementAt(this.tblLocns.convertRowIndexToModel(this.tblLocns.getSelectedRow()));
                        rowdata.location = sLocation;
                    }
                } else if (this.tblLocns.getSelectedRow() == -1) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("select_location_Import"), StoreParams.res.getString("Stop"), 0);
                    return;
                }
                this.tblStyles.selectRow(0);
                String apn = vTokens.elementAt(0).trim() + "," + nRepeats;
                this.tfBarcode.clear();
                this.tfBarcode.setText(apn);
                this.insertStyleLine(apn);
            }
            this.frParent.setFocus();
        }
    }

    protected void populate(long vhidx) {
        ((FrStkTake)this.frParent).revalidateBarcodes();
        try {
            if (this.bOwnTill.isSelected()) {
                this.lWhichTill.setText(StoreParams.res.getString("Own_Till"));
            } else {
                this.lWhichTill.setText(StoreParams.res.getString("All_Tills"));
            }
            String tillWhere = this.bOwnTill.isSelected() ? " AND STH.NOTES2 = " + PosUtils.StringToSqlString(this.sParams.tillnum) + " " : "";
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT COALESCE(STH.LOCATION, ''), STH.TRAND,  COALESCE(STH.NOTES1, ''), P.MEMIDX, STH.VSHIDX, STH.NOTES2, SUM(STD.QTY), SUM(CASE WHEN STD.SKUIDX IS NULL THEN STD.QTY ELSE 0 END) FROM PERSON P, RET_STTH STH LEFT JOIN RET_STTD STD ON STH.VSHIDX = STD.ST_VSHIDX AND STD.\"ACTIVE\" = 1 WHERE STH.VHIDX = " + vhidx + " AND STH.\"ACTIVE\" = 1 AND P.PERIDX = STH.SREPIDX " + tillWhere + "GROUP BY STH.LOCATION, STH.TRAND, STH.NOTES1, P.MEMIDX, STH.VSHIDX, STH.SEQUENCE_NUMBER, STH.NOTES2 " + "ORDER BY STH.SEQUENCE_NUMBER");){
                while (sql.next()) {
                    PosDateFormatter dateFormatter = new PosDateFormatter(sql.getTimestamp(2));
                    try {
                        dateFormatter.setFormat(3, 2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.tblLocns.insertLine(sql.getString(1), sql.getString(6), sql.getLong(4), dateFormatter, sql.getDouble(7), sql.getDouble(8), sql.getString(3), sql.getLong(5));
                }
            }
            this.selectFirstLocn();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void popStyles(long vhidx, long st_vshidx) {
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT STD.SKUIDX, STD.QTY, STD.VSHIDX, STD.LINE_CODE FROM RET_STTD STD LEFT JOIN SKU K ON STD.SKUIDX = K.SKUIDX WHERE STD.\"ACTIVE\" = 1 AND STD.VHIDX = " + vhidx + " AND STD.ST_VSHIDX = " + st_vshidx + " " + "ORDER BY STD.SEQUENCE_NUMBER");){
            while (sql.next()) {
                if (sql.getDouble(2) == 0.0) continue;
                StyleLine style = new StyleLine(StringUtils.nullToEmpty(sql.getString(4)), false, this.sParams);
                style.setVshidx(sql.getLong(3));
                style.setPosVshidx(sql.getLong(3));
                style.setQty(sql.getDouble(2));
                this.tblStyles.addStyleLine(style);
            }
            this.selectFirstStyle();
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    protected void del_stkLines(long vhidx) throws SQLException {
        for (int i = this.tblLocns.getRowCount(); i > 0; --i) {
            this.tblLocns.db_delLocn(i, vhidx);
        }
    }

    protected void db_save(long vhidx) throws SQLException {
        if (this.tblLocns.getRowCount() > 0) {
            long st_vhidx = this.tblLocns.db_save(vhidx, this.tblStyles.getQty(), this.contextRow);
            this.tblStyles.db_saveStkTake(vhidx, st_vhidx);
            this.setButtons(false);
        }
    }

    void tfBarcode_focusGained(FocusEvent e) {
        this.tfBarcode.selectAll();
        this.frParent.setStatusMsg(StatusBar.status_EANSearch);
    }

    public boolean validateTrans() {
        this.bAllTills.doClick();
        for (int modelRow = 0; modelRow < this.tblLocns.model.data.size(); ++modelRow) {
            if (this.tblLocns.model.data.elementAt((int)modelRow).invalidQty == 0.0) continue;
            this.tblLocns.setColumnSelectionInterval(3, 3);
            this.tblLocns.setRowSelectionInterval(this.tblLocns.convertRowIndexToView(modelRow), this.tblLocns.convertRowIndexToView(modelRow));
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("Invalid_APNS"), objs), StoreParams.res.getString("INVALID_APN"), 0);
            return false;
        }
        if (this.tblLocns.getRowCount() == 0) {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("no_locns"), objs), StoreParams.res.getString("Empty_Stock_Take"), 0);
            return false;
        }
        return true;
    }

    public void printLocnReport(Receipt receipt) {
        long vshidx = this.tblLocns.model.data.elementAt((int)this.tblLocns.convertRowIndexToModel((int)this.tblLocns.getSelectedRow())).st_vshidx;
        receipt.PrintStkTakeLocn(vshidx);
    }

    protected void stopEditing() {
        if (this.tblStyles.isEditing()) {
            this.tblStyles.getCellEditor().stopCellEditing();
        }
        if (this.tblLocns.isEditing()) {
            this.tblLocns.getCellEditor().stopCellEditing();
        }
    }

    protected void selectFirstLocn() {
        this.selectLocnLine(0);
    }

    protected void selectLocnLine(int viewRow) {
        if (this.tblLocns.getRowCount() > 0) {
            if (viewRow >= this.tblLocns.getRowCount()) {
                viewRow = this.tblLocns.getRowCount() - 1;
            } else if (viewRow < 0) {
                viewRow = 0;
            }
            this.tblLocns.cellEdit(viewRow, 1);
            this.tblLocns.changeSelection(viewRow, 1, false, false);
            this.tblLocns.getCellEditor(viewRow, 1).cancelCellEditing();
        }
        if (this.tblStyles.getRowCount() > 0) {
            this.tblStyles.setRowSelectionInterval(0, 0);
        }
    }

    protected void selectFirstStyle() {
        this.selectStyleRow(0);
    }

    protected void selectStyleRow(int nRow) {
        if (this.tblStyles.getRowCount() > 0) {
            if (nRow >= this.tblStyles.getRowCount()) {
                nRow = this.tblStyles.getRowCount() - 1;
            } else if (nRow < 0) {
                nRow = 0;
            }
            for (int col = 0; col < this.tblStyles.getColumnCount(); ++col) {
                if (!this.tblStyles.getModel().isCellEditable(nRow, col)) continue;
                this.tblStyles.cellEdit(nRow, col);
                this.tblStyles.changeSelection(nRow, col, false, false);
                this.tblStyles.getCellEditor(nRow, col).cancelCellEditing();
                break;
            }
        }
    }

    protected void gotoStyles() {
        if (this.tblLocns.isEditing()) {
            this.tblLocns.getCellEditor().stopCellEditing();
        }
        this.tblLocns.setColumnSelectionInterval(0, 0);
        this.selectFirstStyle();
        this.tblStyles.requestFocus();
    }

    public class StkLocnModel
    extends AbstractTableModel {
        static final int DUMMY = 0;
        static final int LOCATION = 1;
        static final int TILL_NUMBER = 2;
        static final int DATE = 3;
        static final int SREP = 4;
        static final int QTY = 5;
        static final int INVALIDQTY = 6;
        static final int NOTES = 7;
        static final int ST_VSHIDX = 8;
        Vector<Location> data = new Vector();
        String[] colnames = new String[]{"", StoreParams.res.getString("Location"), StoreParams.res.getString("Till_Number"), StoreParams.res.getString("Date_Time"), StoreParams.res.getString("Sales_Rep"), StoreParams.res.getString("Count"), StoreParams.res.getString("Invalid"), StoreParams.res.getString("Notes")};
        boolean editable = true;

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.colnames.length;
        }

        @Override
        public Object getValueAt(int modelRow, int col) {
            Location line = this.data.elementAt(modelRow);
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return line.location;
                }
                case 2: {
                    return line.tillNumber;
                }
                case 3: {
                    return line.dateFormatter;
                }
                case 4: {
                    return line.salesRep;
                }
                case 5: {
                    return new PosDouble(line.qty);
                }
                case 6: {
                    return new PosDouble(line.invalidQty);
                }
                case 7: {
                    return line.notes;
                }
                case 8: {
                    return String.valueOf(line.st_vshidx);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object val, int modelRow, int col) {
            if (this.data.size() > modelRow && modelRow >= 0) {
                Location line = this.data.elementAt(modelRow);
                switch (col) {
                    case 1: {
                        if (line.location.equals((String)val)) break;
                        PaStkTake.this.setButtons(true);
                        line.location = (String)val;
                        break;
                    }
                    case 4: {
                        if (line.salesRep.equals((User)val)) break;
                        PaStkTake.this.setButtons(true);
                        line.salesRep = (User)val;
                        break;
                    }
                    case 5: {
                        if (line.qty == ((PosDouble)val).doubleValue()) break;
                        line.qty = ((PosDouble)val).doubleValue();
                        PaStkTake.this.setButtons(true);
                        break;
                    }
                    case 6: {
                        if (line.invalidQty == ((PosDouble)val).doubleValue()) break;
                        line.invalidQty = ((PosDouble)val).doubleValue();
                        PaStkTake.this.setButtons(true);
                        break;
                    }
                    case 7: {
                        if (line.notes.equals((String)val)) break;
                        PaStkTake.this.setButtons(true);
                        line.notes = (String)val;
                        break;
                    }
                }
                this.fireTableCellUpdated(modelRow, col);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 3: {
                    return PosDateFormatter.class;
                }
                case 5: {
                    return PosDouble.class;
                }
                case 6: {
                    return PosDouble.class;
                }
                case 4: {
                    return User.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            return this.colnames[col];
        }

        @Override
        public boolean isCellEditable(int modelRow, int col) {
            return this.editable && PaStkTake.this.frParent.isLoggedIn(false) && (col == 1 || col == 4 || col == 7);
        }

        private int insertLine() {
            Location newline = new Location();
            newline.dummy = "";
            newline.location = "";
            newline.tillNumber = PaStkTake.this.sParams.tillnum;
            newline.dateFormatter.setTimestamp(new Timestamp(new Date().getTime()));
            for (int i = 0; i < PaStkTake.this.tblLocns.sRep.getItemCount(); ++i) {
                if (PaStkTake.this.tblLocns.sRep.getItemAt(i).getMemidx() == PaStkTake.this.frParent.getUser().getMemidx()) {
                    newline.salesRep = PaStkTake.this.tblLocns.sRep.getItemAt(i);
                    break;
                }
                if (i != PaStkTake.this.tblLocns.sRep.getItemCount() - 1) continue;
                newline.salesRep = new User(PaStkTake.this.frParent.getUser().getMemidx(), PaStkTake.this.sParams);
            }
            newline.qty = 0.0;
            newline.invalidQty = 0.0;
            newline.notes = "";
            newline.st_vshidx = -1L;
            this.data.add(newline);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            return this.data.size() - 1;
        }

        private int insertLine(String pLocn, String tillNum, long pMemidx, PosDateFormatter pdateFormatter, double qty, double invalidQty, String pnotes, long pvshidx) {
            Location newline = new Location();
            newline.dummy = "";
            newline.location = pLocn;
            newline.tillNumber = tillNum;
            newline.dateFormatter = pdateFormatter;
            for (int i = 0; i < PaStkTake.this.tblLocns.sRep.getItemCount(); ++i) {
                if (PaStkTake.this.tblLocns.sRep.getItemAt(i).getMemidx() == pMemidx) {
                    newline.salesRep = PaStkTake.this.tblLocns.sRep.getItemAt(i);
                    break;
                }
                if (i != PaStkTake.this.tblLocns.sRep.getItemCount() - 1) continue;
                newline.salesRep = new User(pMemidx, PaStkTake.this.sParams);
            }
            newline.qty = qty;
            newline.invalidQty = invalidQty;
            newline.notes = pnotes;
            newline.st_vshidx = pvshidx;
            this.data.add(newline);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            return this.data.size() - 1;
        }

        private long getLocnDataIdx(int modelRow) {
            return modelRow < 0 || modelRow >= this.data.size() ? -1L : this.data.elementAt((int)modelRow).st_vshidx;
        }

        private void clear() {
            this.data.clear();
            this.fireTableDataChanged();
        }

        private long db_save(long vhidx, double stylecnt, int modelRow) throws SQLException {
            Location rowdata = this.data.elementAt(modelRow);
            if (rowdata.st_vshidx != -1L) {
                try (Statement stmt = PaStkTake.this.sParams.conn.createStatement();){
                    stmt.executeUpdate("UPDATE RET_STTH SET DATE_LAST_UPDATE = current_timestamp, LOCATION = " + PosUtils.StringToSqlString(rowdata.location) + ", " + "NOTES1 = " + PosUtils.StringToSqlString(rowdata.notes) + ", " + "SREPIDX = " + rowdata.salesRep.getPeridx() + " " + "WHERE VSHIDX = " + rowdata.st_vshidx + " AND VHIDX = " + vhidx);
                    stmt.executeUpdate("UPDATE RET_STTT SET DATE_LAST_UPDATE = current_timestamp, MEMIDX_LAST_UPDATE = " + PaStkTake.this.frParent.getUser().getMemidx() + ", " + "\"COUNT\" = " + stylecnt + " " + "WHERE ST_VSHIDX = " + rowdata.st_vshidx + " AND VHIDX = " + vhidx);
                }
            }
            long vshidx = 0L;
            try (SqlQuery sql = new SqlQuery(PaStkTake.this.sParams.conn, "SELECT " + PaStkTake.this.sParams.nextVal("XRET_STTH") + " FROM DUAL");){
                if (sql.next()) {
                    vshidx = sql.getLong(1);
                }
            }
            if (vshidx > 0L) {
                rowdata.st_vshidx = vshidx;
                var10_12 = null;
                try (Statement stmt = PaStkTake.this.sParams.conn.createStatement();){
                    stmt.executeUpdate("INSERT INTO RET_STTH(VHIDX, VSHIDX, \"ACTIVE\", DATE_LAST_UPDATE, LOCATION,   NOTES1, NOTES2, SEQUENCE_NUMBER, SREPIDX, TRAND) SELECT " + vhidx + ", " + vshidx + ", 1, current_timestamp, " + PosUtils.StringToSqlString(rowdata.location) + ", " + " " + PosUtils.StringToSqlString(rowdata.notes) + ", " + PosUtils.StringToSqlString(PaStkTake.this.sParams.tillnum) + ", COALESCE(MAX(SEQUENCE_NUMBER), -1)+1," + rowdata.salesRep.getPeridx() + ", '" + rowdata.dateFormatter.getTimestamp().toString() + "' " + "FROM RET_STTH WHERE VHIDX = " + vhidx);
                    stmt.executeUpdate("INSERT INTO RET_STTT(VHIDX, VSHIDX, \"ACTIVE\", DATE_LAST_UPDATE, MEMIDX_LAST_UPDATE,   \"COUNT\", SEQUENCE_NUMBER, ST_VSHIDX, TRAND) SELECT " + vhidx + ", " + PaStkTake.this.sParams.nextVal("XRET_STTT") + ", 1, current_timestamp, " + PaStkTake.this.frParent.getUser().getMemidx() + ", " + " " + stylecnt + ", COALESCE(MAX(SEQUENCE_NUMBER), -1)+1," + vshidx + ", '" + rowdata.dateFormatter.getTimestamp().toString() + "' " + "FROM RET_STTT WHERE VHIDX = " + vhidx);
                    stmt.executeUpdate("UPDATE RET_STTH SET NOTES3 = " + PosUtils.StringToSqlString(PaStkTake.this.sParams.tillnum) + " WHERE VSHIDX = " + vshidx);
                }
                catch (Throwable throwable) {
                    var10_12 = throwable;
                    throw throwable;
                }
            }
            return rowdata.st_vshidx;
        }

        private void db_delete(int modelRow, long vhidx) throws SQLException {
            try (Statement stmt = PaStkTake.this.sParams.conn.createStatement();){
                stmt.executeUpdate("UPDATE RET_STTD SET \"ACTIVE\" = 0 WHERE VHIDX = " + vhidx + " AND ST_VSHIDX = " + this.data.elementAt((int)modelRow).st_vshidx);
                stmt.executeUpdate("UPDATE RET_STTT SET \"ACTIVE\" = 0 WHERE VHIDX = " + vhidx + " AND ST_VSHIDX = " + this.data.elementAt((int)modelRow).st_vshidx);
                stmt.executeUpdate("UPDATE RET_STTH SET \"ACTIVE\" = 0 WHERE VHIDX = " + vhidx + " AND VSHIDX = " + this.data.elementAt((int)modelRow).st_vshidx);
            }
            this.data.remove(modelRow);
            this.fireTableRowsDeleted(modelRow, modelRow);
        }

        protected void setEditable(boolean ed) {
            this.editable = ed;
        }
    }

    protected class StkLocnTable
    extends PosTable {
        StkLocnModel model;
        int lastSelectedModelRow;
        long lastSelectedVshidx;
        JComboBox<User> sRep;

        @Override
        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
            if (e.getID() == 401 && e.getKeyCode() == 68 && e.isAltDown()) {
                PaStkTake.this.gotoStyles();
            }
        }

        private StkLocnTable(PosFrame pfrParent, StkLocnModel pmodel) {
            super(pfrParent, pmodel);
            this.lastSelectedModelRow = -1;
            this.lastSelectedVshidx = -1L;
            this.sRep = new JComboBox<User>(){

                @Override
                public void processKeyEvent(KeyEvent e) {
                    super.processKeyEvent(e);
                    if (e.getID() == 401 && e.getKeyCode() == 9) {
                        StkLocnTable.this.tabPressed(e);
                    }
                }
            };
            this.stringField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 68 && e.isAltDown()) {
                        PaStkTake.this.gotoStyles();
                    }
                    Document stringFieldDoc = StkLocnTable.this.stringField.getDocument();
                    if (StkLocnTable.this.getSelectedColumn() == 1 || StkLocnTable.this.getSelectedColumn() == 7) {
                        int maxLength = StkLocnTable.this.getSelectedColumn() == 1 ? 50 : 250;
                        if (stringFieldDoc instanceof AbstractDocument) {
                            AbstractDocument doc = (AbstractDocument)stringFieldDoc;
                            doc.setDocumentFilter(new DocumentSizeFilter(maxLength));
                        }
                    }
                }
            });
            this.model = pmodel;
            this.setSelectionMode(0);
            this.setAutoCreateRowSorter(true);
            this.getRowSorter().addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent e) {
                    PaStkTake.this.stopEditing();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PaStkTake.this.tblLocns.scrollRectToVisible(PaStkTake.this.tblLocns.getCellRect(StkLocnTable.this.getSelectedRow(), 1, true));
                        }
                    });
                }
            });
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT M.MEMIDX, P.PERIDX, M.MEMNAME, P.FIRSTNAME, P.SURNAME FROM MEMBER M, PERSON P WHERE M.MEMIDX = P.MEMIDX AND M.\"ACTIVE\" = 1");){
                while (sql.next()) {
                    this.sRep.addItem(new User(sql.getLong(1), sql.getLong(2), sql.getString(3), sql.getString(4), sql.getString(5), null, this.sParams));
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
            this.columnModel.getColumn(4).setCellEditor(new DefaultCellEditor(this.sRep));
            this.columnModel.getColumn(0).setCellEditor(this.stringEd);
            this.columnModel.getColumn(1).setCellEditor(this.stringEd);
            this.columnModel.getColumn(7).setCellEditor(this.stringEd);
            for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
                if (i == 5 || i == 6 || i == 3) {
                    this.columnModel.getColumn(i).setHeaderRenderer(this.headerCenterRen);
                    continue;
                }
                this.columnModel.getColumn(i).setHeaderRenderer(this.headerLeftRen);
            }
            this.renderer.setColumnFormat(3, null, 0);
            this.renderer.setColumnFormat(5, StoreParams.qtyFormat, 0);
            this.renderer.setColumnFormat(6, StoreParams.qtyFormat, 0);
            this.columnModel.getColumn(0).setMinWidth(10);
            this.columnModel.getColumn(0).setMaxWidth(10);
            this.columnModel.getColumn(1).setMinWidth(80);
            this.columnModel.getColumn(2).setMinWidth(80);
            this.columnModel.getColumn(3).setMinWidth(105);
            this.columnModel.getColumn(4).setMinWidth(80);
            this.columnModel.getColumn(5).setMinWidth(60);
            this.columnModel.getColumn(6).setMinWidth(60);
            this.columnModel.getColumn(7).setMinWidth(150);
            this.columnModel.getColumn(7).setPreferredWidth(300);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        Cursor curs;
                        block38: {
                            if (StkLocnTable.this.getSelectedRow() >= 0) {
                                if (StkLocnTable.this.lastSelectedModelRow == StkLocnTable.this.convertRowIndexToModel(StkLocnTable.this.getSelectedRow()) && StkLocnTable.this.lastSelectedVshidx == StkLocnTable.this.getLocnDataIdx(StkLocnTable.this.getSelectedRow())) {
                                    return;
                                }
                                StkLocnTable.this.lastSelectedModelRow = StkLocnTable.this.convertRowIndexToModel(StkLocnTable.this.getSelectedRow());
                                StkLocnTable.this.lastSelectedVshidx = StkLocnTable.this.getLocnDataIdx(StkLocnTable.this.getSelectedRow());
                            } else {
                                StkLocnTable.this.lastSelectedModelRow = -1;
                                StkLocnTable.this.lastSelectedVshidx = -1L;
                            }
                            curs = PaStkTake.this.frParent.getCursor();
                            PaStkTake.this.frParent.setCursor(StoreParams.waitCursor);
                            int n = PaStkTake.this.contextRow = e.getFirstIndex() == StkLocnTable.this.getSelectedRow() ? e.getLastIndex() : e.getFirstIndex();
                            if (PaStkTake.this.contextRow == StkLocnTable.this.getSelectedRow()) {
                                PaStkTake.this.contextRow = -1;
                            }
                            try (SqlQuery sql = new SqlQuery(StkLocnTable.this.sParams.conn, "SELECT H.\"ACTIVE\", H.COMPLETE, RH.NOTES3 FROM RET_STTH RH, RET_TRANH H WHERE RH.VHIDX = H.VHIDX AND RH.VSHIDX = " + StkLocnTable.this.getLocnDataIdx(StkLocnTable.this.getSelectedRow()));){
                                boolean foundLocn = sql.next();
                                if (foundLocn && sql.getInt(1) == 0) {
                                    DlgMessage.showMessage(PaStkTake.this.frParent, MessageFormat.format(StoreParams.res.getString("voided_stktake"), "\n"), StoreParams.res.getString("Stop"), 0);
                                    PaStkTake.this.frParent.paHead.logoff(true);
                                    break block38;
                                }
                                if (foundLocn && sql.getInt(2) > 0 && !((FrStkTake)PaStkTake.this.frParent).oldTrans) {
                                    DlgMessage.showMessage(PaStkTake.this.frParent, MessageFormat.format(StoreParams.res.getString("completed_stktake"), "\n"), StoreParams.res.getString("Stop"), 0);
                                    PaStkTake.this.frParent.paHead.logoff(true);
                                    break block38;
                                }
                                if (foundLocn && sql.getString(3) != null && !sql.getString(3).equals(StkLocnTable.this.sParams.tillnum)) {
                                    DlgMessage.showMessage(PaStkTake.this.frParent, MessageFormat.format(StoreParams.res.getString("Till_Number_locn_locked"), sql.getString(3), "\n", "\n", "\n"), StoreParams.res.getString("Stop"), 2);
                                    if (PaStkTake.this.contextRow < 0 || PaStkTake.this.contextRow >= StkLocnTable.this.getRowCount()) {
                                        StkLocnTable.this.clearSelection();
                                    } else {
                                        StkLocnTable.this.setRowSelectionInterval(PaStkTake.this.contextRow, PaStkTake.this.contextRow);
                                    }
                                    break block38;
                                }
                                ((FrStkTake)PaStkTake.this.frParent).removeLocks();
                                try (Statement stmt = StkLocnTable.this.sParams.getStmt();){
                                    stmt.executeUpdate("UPDATE RET_STTH SET NOTES3 = " + PosUtils.StringToSqlString(StkLocnTable.this.sParams.tillnum) + " WHERE VSHIDX = " + StkLocnTable.this.getLocnDataIdx(StkLocnTable.this.getSelectedRow()));
                                }
                                PaStkTake.this.populating = true;
                                if (PaStkTake.this.contextRow >= 0 && PaStkTake.this.contextRow < StkLocnTable.this.getRowCount()) {
                                    ((FrStkTake)PaStkTake.this.frParent).save();
                                }
                                PaStkTake.this.tblStyles.clear();
                                if (StkLocnTable.this.getSelectedRow() > -1) {
                                    PaStkTake.this.popStyles(PaStkTake.this.frParent.vhidx, StkLocnTable.this.getLocnDataIdx(StkLocnTable.this.getSelectedRow()));
                                }
                                PaStkTake.this.populating = false;
                                PaStkTake.this.updateTots();
                            }
                            catch (SQLException ex) {
                                PosUtils.logError(ex);
                            }
                        }
                        PaStkTake.this.contextRow = StkLocnTable.this.getSelectedRow();
                        PaStkTake.this.frParent.setCursor(curs);
                    }
                }
            });
        }

        @Override
        public Color getDisplayForegroundAt(Object value, int viewRow, int column) {
            if (viewRow < 0) {
                return this.renderer.defaultColour;
            }
            if (column == 6 && PosUtils.doubleValFormatted(value.toString()) > 0.0) {
                return Colours.RED;
            }
            return this.renderer.defaultColour;
        }

        private int insertLine() {
            return this.convertRowIndexToView(this.model.insertLine());
        }

        private int insertLine(String plocn, String tillNum, long pmemidx, PosDateFormatter pdateFormatter, double qty, double invalidQty, String pnotes, long pvshidx) {
            return this.convertRowIndexToView(this.model.insertLine(plocn, tillNum, pmemidx, pdateFormatter, qty, invalidQty, pnotes, pvshidx));
        }

        private void db_delLocn(int viewRow, long vhidx) throws SQLException {
            this.model.db_delete(this.convertRowIndexToModel(viewRow), vhidx);
        }

        private long getLocnDataIdx(int viewRow) {
            if (viewRow < 0 || viewRow >= this.getRowCount()) {
                return -1L;
            }
            return this.model.getLocnDataIdx(this.convertRowIndexToModel(viewRow));
        }

        private long db_save(long vhidx, double stylecnt, int viewRow) throws SQLException {
            return this.model.db_save(vhidx, stylecnt, this.convertRowIndexToModel(viewRow));
        }

        protected void clear() {
            this.model.clear();
            this.lastSelectedModelRow = -1;
            this.lastSelectedVshidx = -1L;
        }

        public void setEditable(boolean ed) {
            this.model.setEditable(ed);
        }
    }

    public class Location {
        String dummy = "";
        String location = "";
        String tillNumber = "";
        PosDateFormatter dateFormatter = new PosDateFormatter(null);
        User salesRep;
        double qty = 0.0;
        double invalidQty = 0.0;
        String notes = "";
        long st_vshidx = -1L;

        protected Location() {
            try {
                this.dateFormatter.setFormat(3, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

