/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.FrTransferOut;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosTableListener;
import jpos.PosTableModelEvent;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.Security;
import jpos.SkuReservation;
import jpos.SqlQuery;
import jpos.StatusBar;
import jpos.Store;
import jpos.StoreParams;
import jpos.StringField;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.StyleTable;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.basscom.swing.BJTextField;
import jpos.searchfields.BarcodeSearchField;
import jpos.searchfields.ClrSearchField;
import jpos.searchfields.HintTextField;
import jpos.searchfields.SearchPanel;
import jpos.searchfields.SizeSearchField;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import org.jdom.Element;

public class PaTransferOut
extends JPanel {
    SizeSearchField tfSize = new SizeSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            String apn = "";
            try (SqlQuery sql = new SqlQuery(PaTransferOut.this.sParams.conn, "SELECT DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.SKUIDX = " + this.getidx());){
                if (sql.next()) {
                    apn = sql.getString(1);
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
            PaTransferOut.this.tfBarcode.clear();
            PaTransferOut.this.tfBarcode.setText(apn);
            PaTransferOut.this.insertStyleLineLater(apn);
        }
    };
    ClrSearchField tfClr = new ClrSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            try (SqlQuery sql = new SqlQuery(PaTransferOut.this.sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + this.getidx());){
                if (sql.next()) {
                    String apn = sql.getString(2);
                    if (sql.next()) {
                        PaTransferOut.this.tfSize.search(this.getidx(), PaTransferOut.this.tfBarcode.getText(), this.getText());
                    } else {
                        PaTransferOut.this.tfBarcode.clear();
                        PaTransferOut.this.tfBarcode.setText(apn);
                        PaTransferOut.this.insertStyleLineLater(apn);
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    };
    BarcodeSearchField tfBarcode = new BarcodeSearchField(TouchTextField.FontSize.LARGE){

        @Override
        public void actionSearch() {
            if (PaTransferOut.this.frParent.isLoggedIn(true)) {
                PaTransferOut.this.search = true;
                if (this.getText().equals(StoreParams.invalidBarcode)) {
                    this.setText("");
                }
                super.actionSearch();
                this.requestFocus();
                this.selectAll();
            }
        }

        @Override
        public void actionValidate() {
            if (!PaTransferOut.this.search) {
                return;
            }
            PaTransferOut.this.search = false;
            if (!this.getText().equals(StoreParams.invalidBarcode) && !this.getText().equals(StoreParams.invalidTrans)) {
                super.actionValidate();
                try (SqlQuery sqlClr = new SqlQuery(PaTransferOut.this.sParams.conn, "SELECT C.CLRIDX, C.CLRNAME FROM CLR C WHERE C.STYLEIDX = " + this.getidx());){
                    if (sqlClr.next()) {
                        long clridx = sqlClr.getLong(1);
                        String clrname = sqlClr.getString(2);
                        if (sqlClr.next()) {
                            PaTransferOut.this.tfClr.search(this.getidx(), this.getText());
                        } else {
                            try (SqlQuery sqlBarcode = new SqlQuery(PaTransferOut.this.sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + clridx);){
                                if (sqlBarcode.next()) {
                                    String apn = sqlBarcode.getString(2);
                                    if (sqlBarcode.next()) {
                                        PaTransferOut.this.tfSize.search(clridx, this.getText(), clrname);
                                    } else {
                                        PaTransferOut.this.tfBarcode.clear();
                                        this.setText(apn);
                                        PaTransferOut.this.insertStyleLineLater(apn);
                                    }
                                }
                            }
                        }
                    }
                    PaTransferOut.this.tfBarcode.clear();
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
    };
    private SearchPanel barcodeSearchPanel = new SearchPanel(this.tfBarcode);
    private boolean search = false;
    private boolean isOverReceipt = false;
    BJTextField tfTransferReqSearch = new BJTextField(TouchTextField.FontSize.LARGE);
    StyleTable tblStyles;
    private TotalsTable tblTotals;
    DecimalField tfTot;
    protected HintTextField tfWhse = new HintTextField(SP.getRS("Search_F12"), TouchTextField.FontSize.LARGE);
    protected HintTextField tfSupplier = new HintTextField(SP.getRS("Search_F12"), TouchTextField.FontSize.LARGE);
    private SearchPanel whseSearchPanel = new SearchPanel(this.tfWhse);
    private SearchPanel supplierSearchPanel = new SearchPanel(this.tfSupplier);
    LabelSubHeading lToWhse = new LabelSubHeading();
    GridBagLayout gridBagLayout = new GridBagLayout();
    StringField tfPurNum = new StringField(TouchTextField.FontSize.LARGE);
    LabelSubHeading lPurNum = new LabelSubHeading();
    protected Vector<Store> transferOutStores = new Vector();
    protected Vector<Reference> suppliers = new Vector();
    LabelSubHeading lFeedBack = new LabelSubHeading();
    LabelSubHeading lFeedBack2 = new LabelSubHeading();
    PosFrame frParent;
    StoreParams sParams;
    StringField tfConnote = new StringField(TouchTextField.FontSize.LARGE);
    LabelSubHeading lConnote = new LabelSubHeading();

    public PaTransferOut(PosFrame pfrParent) {
        this.frParent = pfrParent;
        this.sParams = this.frParent.sParams;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.tfTot = new DecimalField(StoreParams.qtyFormat, 4, TouchTextField.FontSize.LARGE);
        this.setToField(249);
        try {
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT SR.SUPIDX, SR.CODE, SR.NAME FROM SUPPLIER SR WHERE SR.\"ACTIVE\" = 1 " + this.sParams.sRefSecWhereSUPPLIER + " ORDER BY SR.CODE");){
                while (sql.next()) {
                    this.suppliers.add(new Reference(sql.getString(3), sql.getString(2), sql.getLong(1)));
                }
            }
            sql = new SqlQuery(this.sParams.conn, "SELECT W.STORENO, W.WIDX, R.CODE, R.NAME FROM WHSE W, REFCODE R WHERE R.RCIDX = W.WIDX AND R.RGIDX = 7 AND R.\"ACTIVE\" = 1 " + this.sParams.getArmsLengthWhere() + " AND (W.DATE_CLOSE IS NULL OR W.DATE_CLOSE >= CURRENT_TIMESTAMP) AND W.\"TYPE\" <> 'V' AND W.WIDX <> " + this.sParams.getStoreIdx() + " " + this.sParams.sWhseRefSecWhereWHSEStkTransOut + " " + "ORDER BY R.CODE");
            var2_3 = null;
            try {
                while (sql.next()) {
                    this.transferOutStores.add(new Store(sql.getString(4), sql.getString(3), sql.getString(1), sql.getLong(2)));
                }
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (sql != null) {
                    if (var2_3 != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.tblStyles = new StyleTable(this.frParent, null);
        this.tblStyles.addTableModelListener(new PosTableListener(){

            @Override
            public void tableValueChanging(PosTableModelEvent e) {
                if (((FrTransferOut)PaTransferOut.this.frParent).tr_vhidx != -1L && !Security.hasSecurity(PaTransferOut.this.frParent, 12641L, PaTransferOut.this.frParent.getUser().getMemidx(), 2, false) && Double.valueOf(e.getNewValue().toString()) > Double.valueOf(((TableModel)e.getSource()).getValueAt(e.getFirstRow(), 4).toString())) {
                    PaTransferOut.this.isOverReceipt = true;
                    DlgMessage.showMessage(PaTransferOut.this.frParent, StoreParams.res.getString("You_must_enter_a_qty_equal_to_required"), StoreParams.res.getString("Stop"), 0);
                    PaTransferOut.this.isOverReceipt = false;
                    PaTransferOut.this.tblStyles.changeSelection(e.getFirstRow(), 0, false, false);
                    e.setAllow(false);
                    return;
                }
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                PaTransferOut.this.update();
            }
        });
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblStyles.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row != 0) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        return StoreParams.totalText;
                    }
                    case 4: {
                        return new PosDouble(PaTransferOut.this.tblStyles.getReqQty());
                    }
                    case 5: {
                        return new PosDouble(PaTransferOut.this.tblStyles.getQty());
                    }
                }
                return "";
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblStyles, totalsTableModel);
        this.tblStyles.model.setAllowEditingTransferOutCol(!((FrTransferOut)this.frParent).forceScan);
        this.tfWhse.setCache(this.sParams.cacher, 985L, "3798,3797", "", "W.WIDX <> " + this.sParams.getStoreIdx() + " AND (W.DATE_CLOSE IS NULL OR W.DATE_CLOSE >= CURRENT_TIMESTAMP)" + this.sParams.getArmsLengthWhere() + " " + this.sParams.sWhseRefSecWhereWHSEStkTransOut);
        this.tfWhse.setSearchKey(123);
        this.tfWhse.searchWithEnter(true);
        this.tfWhse.setShowSearchForOneResult(true);
        this.tfSupplier.setCache(this.sParams.cacher, 694L, "", "", "SR.\"ACTIVE\" = 1 " + this.sParams.sRefSecWhereSUPPLIER);
        this.tfSupplier.setSearchKey(123);
        this.tfSupplier.searchWithEnter(true);
        this.tfSupplier.setShowSearchForOneResult(true);
        this.setLayout(this.gridBagLayout);
        this.tfBarcode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaTransferOut.this.tfBarcode_focusGained(e);
            }
        });
        this.tfBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaTransferOut.this.tfBarcode_actionPerformed(e);
            }
        });
        this.lToWhse.setText(StoreParams.res.getString("To"));
        this.tfWhse.setFieldWidth(200);
        this.tfSupplier.setFieldWidth(200);
        this.tfPurNum.setFieldWidth(120);
        this.tfPurNum.setHorizontalAlignment(4);
        this.lPurNum.setText("");
        this.lFeedBack.setText(StoreParams.res.getString("Transfer"));
        this.tfConnote.setFieldWidth(120);
        this.tfConnote.setHorizontalAlignment(4);
        this.lConnote.setText(StoreParams.res.getString("Connote_"));
        this.add((Component)this.barcodeSearchPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 0), 0, 0));
        this.add((Component)this.tfPurNum, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 10, 0), 0, 0));
        this.add((Component)this.whseSearchPanel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 10, 10), 0, 0));
        this.add((Component)this.supplierSearchPanel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 10, 10), 0, 0));
        this.add((Component)this.tblStyles.getScrollPane(), new GridBagConstraints(0, 2, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 3, 5, 1, 1.0, 0.0, 15, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.lPurNum, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 14, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lToWhse, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 0, 0, 10), 0, 0));
        this.add((Component)this.lFeedBack, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 16, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.tfClr, new GridBagConstraints(3, 3, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.tfSize, new GridBagConstraints(3, 3, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.lFeedBack2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 0), 0, 0));
        this.add((Component)this.lConnote, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.tfConnote, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 10, 0), 0, 0));
        this.add((Component)this.tfTransferReqSearch, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tfTransferReqSearch.setVisible(false);
        this.tfClr.setVisible(false);
        this.tfSize.setVisible(false);
        this.tfTransferReqSearch.setCache(this.sParams.cacher, this.sParams.iconn, 1120L, "", "", "H.POST_STATUS = 4 AND H.\"ACTIVE\" = 1 AND NVL(H.TRANSFER_COMPLETE_FLAG, 0) = 0 AND H.WIDX = " + this.sParams.getStoreIdx() + this.sParams.sWhseRefSecWhereWHSEStkTransOut);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfBarcode);
        v.add(this.tfPurNum);
        v.add(this.tfConnote);
        v.add(this.tfWhse);
        v.add(this.tfSupplier);
        v.add(this.tblStyles);
        v.add(this.tfBarcode);
        v.add(this.frParent.paHead.signInButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void insertStyleLineLater(final String barcode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PaTransferOut.this.insertStyleLine(barcode);
                PaTransferOut.this.tfBarcode.requestFocus();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertStyleLine(String barcode) {
        if (!barcode.equals("") && !barcode.equals(StoreParams.invalidBarcode) && PosUtils.isProductBarcode(barcode)) {
            block34: {
                barcode = PosUtils.getDefaultBarcode(barcode);
                try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT K.SKUIDX, COALESCE(S.STKFLAG,0) FROM STYLE S, CLR C, SKU K, BARCODE B WHERE B.CODE = " + PosUtils.StringToSqlString(barcode) + " AND B.SKUIDX = K.SKUIDX AND K.CLRIDX = C.CLRIDX AND C.STYLEIDX = S.STYLEIDX");){
                    if (!sql.next()) break block34;
                    if (sql.getInt(2) == 0) {
                        DlgMessage.showMessage(this.frParent, StoreParams.res.getString("non_stocked"), StoreParams.res.getString("Stop"), 0);
                        this.tfBarcode.setText("");
                        boolean bl = false;
                        return bl;
                    }
                    if (((FrTransferOut)this.frParent).tr_vhidx != -1L) {
                        boolean bFound = false;
                        long nSkuidx = sql.getLong(1);
                        for (int i = 0; i < this.tblStyles.getRowCount(); ++i) {
                            if (!(this.tblStyles.model.getItemAt(i) instanceof StyleLine) || ((StyleLine)this.tblStyles.model.getItemAt(i)).getSkuidx() != nSkuidx) continue;
                            bFound = true;
                            break;
                        }
                        if (!bFound) {
                            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("style_not_on_transfer_req"), StoreParams.res.getString("Stop"), 0);
                            this.tfBarcode.setText("");
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                    this.tfBarcode.setText(StoreParams.invalidBarcode);
                    this.tfBarcode.selectAll();
                    return false;
                }
            }
            try {
                if (this.tblStyles.addEAN(barcode) == -1) {
                    this.tfBarcode.setText(StoreParams.invalidBarcode);
                    this.tfBarcode.selectAll();
                    return true;
                }
                this.tfBarcode.setText("");
                return true;
            }
            catch (NumberFormatException n) {
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                return false;
            }
        }
        if (barcode.length() > 1 && barcode.substring(0, 1).toUpperCase().equals("P")) {
            if (this.db_populate(barcode.substring(1), 251L)) {
                this.tfBarcode.setText("");
                return true;
            }
            this.tfBarcode.setText(StoreParams.invalidBarcode);
            this.tfBarcode.selectAll();
            return true;
        }
        if (barcode.length() > 1 && barcode.substring(0, 2).toUpperCase().equals("TR")) {
            String transferRequestNum = barcode.substring(2);
            Element transaction = this.findTransferRequest(transferRequestNum);
            if (transaction == null) {
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                return false;
            }
            if (!this.populateTransferRequest(transferRequestNum, transaction)) {
                this.frParent.voidTrans(false);
                this.tfBarcode.setText(StoreParams.invalidTrans);
                this.tfBarcode.selectAll();
                return false;
            }
            this.tfBarcode.setText("");
            return true;
        }
        if (barcode.length() > 4 && (barcode.substring(0, 1).toUpperCase().equals("D") || barcode.substring(0, 1).toUpperCase().equals("R"))) {
            if (this.db_populate(barcode.substring(1), 614L)) {
                this.tfBarcode.setText("");
                return true;
            }
            this.tfBarcode.setText(StoreParams.invalidBarcode);
            this.tfBarcode.selectAll();
            return true;
        }
        this.tfBarcode.setText(StoreParams.invalidBarcode);
        this.tfBarcode.selectAll();
        return false;
    }

    private Element findTransferRequest(String number) {
        if (StringUtils.isNullOrEmpty(number)) {
            return null;
        }
        Element transaction = null;
        try {
            transaction = SP.sParams.OnlineQueryProvider.getOnlineQuery("trans_req", number + "," + this.sParams.getStoreIdx()).getXML();
            if (transaction != null && (transaction.getAttribute("to_widx") == null || transaction.getAttribute("widx") == null)) {
                transaction = null;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            transaction = null;
        }
        return transaction;
    }

    private boolean populateTransferRequest(String number, Element transaction) {
        this.frParent.voidTrans(false);
        this.tblStyles.showTrOutReqCol(true);
        try {
            Element root = (Element)transaction.clone();
            if (root.getAttribute("to_widx") == null || root.getAttribute("widx") == null) {
                return false;
            }
            if (!this.tblStyles.populate(root)) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("There_was_an_error_req"), objs), StoreParams.res.getString("Invalid"), 0);
                return false;
            }
            ((FrTransferOut)this.frParent).tr_vhidx = root.getAttribute("vhidx").getLongValue();
            ((FrTransferOut)this.frParent).tr_number = root.getAttribute("trans_number").getValue();
            ((FrTransferOut)this.frParent).transRoot = root;
            this.frParent.setTransType(249);
            if (root.getAttribute("to_widx") != null) {
                Store store = this.getTransferOutStore(root.getAttribute("to_widx").getLongValue());
                if (store == null) {
                    this.tfWhse.clear();
                    Object[] objs = new Object[]{"\n"};
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("Unable_retrieve_no_security"), objs), StoreParams.res.getString("Error"), 0);
                    return false;
                }
                this.tfWhse.setAll(store.getWidx(), store.getCode(), store.getName());
                this.tfWhse.setEnabled(false);
            }
            this.update();
            if (this.tblStyles.getReqQty() == 0.0) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("There_are_no_qtys_on"), objs));
                return false;
            }
            this.lFeedBack.setText(StoreParams.res.getString("TransferReq_") + " " + number);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    protected void tfBarcode_actionPerformed(ActionEvent e) {
        this.frParent.setCursor(StoreParams.waitCursor);
        if (this.insertStyleLine(this.tfBarcode.getText())) {
            this.tfBarcode.requestFocus();
            this.tfBarcode.selectAll();
        }
        this.frParent.setCursor(StoreParams.normalCursor);
    }

    protected void update() {
        if (this.tblStyles.getRowCount() > 0) {
            this.tfTot.setText(this.tblStyles.getQty());
        } else {
            this.tfTot.setText("");
        }
        ((FrTransferOut)this.frParent).setButtons();
    }

    protected Vector<Object> delLines() {
        return this.tblStyles.delLines();
    }

    protected void setToField(int type) {
        if (type == 252) {
            this.tfSupplier.setVisible(true);
            this.tfWhse.setVisible(false);
            this.lToWhse.setText(StoreParams.res.getString("Supplier"));
            this.tfSupplier.clear();
        } else {
            this.tfSupplier.setVisible(false);
            this.tfWhse.setVisible(true);
            this.lToWhse.setText(StoreParams.res.getString("Store_To"));
        }
        this.tfSupplier.clear();
        this.tfWhse.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean db_populate(String num, long transType) {
        String storeNum = num.substring(0, 3);
        String col = "H.TRANS_NUMBER";
        if (transType == 614L) {
            num = num.substring(3);
            col = "H.DOCKET_NUMBER";
        }
        boolean first = true;
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT H.TRANS_NUMBER, H.DOCKET_NUMBER, D.SKUIDX, D.QTY  FROM RET_TRANH H  JOIN RET_TRAND D ON H.VHIDX = D.VHIDX  JOIN WHSE W ON H.WIDX = W.WIDX  WHERE H.TR_TYPE = ?  AND W.STORENO = ?  AND " + col + " = ? ", transType, storeNum, num);){
            while (sql.next()) {
                if (first) {
                    this.frParent.voidTrans(false);
                    first = false;
                }
                if (sql.getRow() == 1 && transType != 614L) {
                    this.frParent.setTransnum(sql.getString(1));
                    this.frParent.setTransType(252);
                    this.tfPurNum.setText(sql.getString(1));
                }
                if (transType == 614L) {
                    SkuReservation res = new SkuReservation(num, sql.getLong(3), this.sParams, false);
                    if (!(res.getStyleLine().getQty() > 0.0)) continue;
                    if (!this.frParent.lockTransaction(num, num, 614)) {
                        this.frParent.clearScreenLocks();
                        boolean bl = false;
                        return bl;
                    }
                    this.tblStyles.addStyleLine(res.getStyleLine());
                    ((FrTransferOut)this.frParent).reservations.add(res);
                    continue;
                }
                this.tblStyles.addSku(sql.getLong(3), sql.getDouble(4), true, true);
            }
            if (sql.getRow() != 1) {
                if (transType != 614L) return true;
                if (((FrTransferOut)this.frParent).reservations.size() != 0) return true;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    void tfBarcode_focusGained(FocusEvent e) {
        this.tfBarcode.selectAll();
        this.frParent.setStatusMsg(StatusBar.status_EANSearch);
    }

    protected void receiptAll() {
        if (this.tblStyles.isEditing()) {
            this.tblStyles.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < this.tblStyles.getRowCount(); ++i) {
            PosDouble required = (PosDouble)this.tblStyles.getValueAt(i, 4);
            this.tblStyles.setValueAt(required.toString(), i, 5);
        }
    }

    public Store getTransferOutStore(long widx) {
        for (int i = 0; i < this.transferOutStores.size(); ++i) {
            if (this.transferOutStores.elementAt(i).getWidx() != widx) continue;
            return this.transferOutStores.elementAt(i);
        }
        return null;
    }

    public boolean getIsOverReceipt() {
        return this.isOverReceipt;
    }
}

