/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import jpos.PosFrame;
import jpos.StoreParams;

public abstract class PosDialog
extends JDialog
implements KeyEventDispatcher {
    public PosFrame frParent;
    public StoreParams sParams;
    private long lastKeyAction = 0L;
    private int lastKey = -1;
    private boolean acceptOnEnter = true;
    private boolean cancelOnEscape = true;

    public void setAcceptOnEnter(boolean acceptOnEnter) {
        this.acceptOnEnter = acceptOnEnter;
    }

    public void setCancelOnEscape(boolean cancelOnEscape) {
        this.cancelOnEscape = cancelOnEscape;
    }

    public PosDialog(PosFrame frame, JDialog dlgParent, String title, boolean modal, boolean delayClose) {
        super(dlgParent, title, modal);
        this.frParent = frame;
        this.sParams = this.frParent.sParams;
        this.initialiseUI(delayClose);
    }

    public PosDialog(PosFrame frame, JDialog dlgParent, String title, boolean modal) {
        this(frame, dlgParent, title, modal, false);
    }

    public PosDialog(PosFrame frame, String title, boolean modal, boolean delayClose) {
        super(frame, title, modal);
        this.frParent = frame;
        this.sParams = this.frParent.sParams;
        this.initialiseUI(delayClose);
    }

    public PosDialog(PosFrame frame, String title, boolean modal) {
        this(frame, title, modal, false);
    }

    public void initialiseUI(final boolean delayClose) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (delayClose) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PosDialog.this.cancelDialog();
                        }
                    });
                } else {
                    PosDialog.this.cancelDialog();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PosDialog.this.setLastAction();
                PosDialog.this.this_keyPressed(e);
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PosDialog.this.setLastAction();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PosDialog.this.setLastAction();
            }
        });
    }

    public abstract void cancelDialog();

    public abstract void okDialog();

    protected abstract boolean myKeyPressed(KeyEvent var1);

    protected synchronized boolean this_keyPressed(KeyEvent e) {
        boolean subActionPerformed = false;
        boolean actionPerformed = true;
        if (e.getKeyCode() != this.lastKey || e.getWhen() > this.lastKeyAction + 200L) {
            this.lastKeyAction = new Date().getTime();
            this.lastKey = e.getKeyCode();
            if (e.getKeyCode() == 112) {
                this.sParams.runHelp();
            } else if (e.getKeyCode() == 27 && this.cancelOnEscape) {
                this.cancelDialog();
            } else if (e.getKeyCode() == 10 && this.acceptOnEnter) {
                this.okDialog();
            } else {
                actionPerformed = false;
            }
            subActionPerformed = this.myKeyPressed(e);
            if (!actionPerformed && !subActionPerformed) {
                return false;
            }
        }
        return actionPerformed || subActionPerformed;
    }

    protected void setLastAction() {
        if (this.frParent != null) {
            this.frParent.setLastAction();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 205) {
            this.setLastAction();
        }
        super.processWindowEvent(e);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive()) {
            this.processKeyEvent(e);
        }
        return false;
    }

    @Override
    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        super.dispose();
    }
}

