/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jpos.PosComboBox;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;

public class RefCombo
extends PosComboBox<Reference> {
    public RefCombo(long rgidx, String extraWhere, String OrderBy) {
        try {
            this.populate(rgidx, extraWhere, OrderBy);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public RefCombo() {
    }

    private void populate(long rgidx, String extraWhere, String OrderBy) {
        if (extraWhere != null && extraWhere.trim().length() > 0 && !extraWhere.trim().toUpperCase().startsWith("AND")) {
            extraWhere = "AND " + extraWhere.trim();
        }
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT R.RCIDX, R.CODE, R.NAME, R.LINKIDX, R.\"EXTEND\", B.BLOBTEXT, G.S_NAME, G.L_NAME FROM REFGRP G, REFCODE R LEFT JOIN BLOBTEXT B ON R.LINKIDX = B.BLOBIDX WHERE G.RGIDX = R.RGIDX AND R.RGIDX = ? AND R.\"ACTIVE\" = 1 " + extraWhere + " " + (OrderBy != null && !OrderBy.equals("") ? "ORDER BY " + OrderBy : ""));){
            stmt.setLong(1, rgidx);
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    this.addItem(new Reference(result.getLong(1), rgidx, result.getString(2), result.getString(3), result.getLong(4), result.getString(5), result.getString(6), result.getString(7), result.getString(8)));
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void selectRcidx(long rcidx) {
        this.setSelectedIndex(-1);
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (((Reference)this.getItemAt(i)).getIdx() != rcidx) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    public Reference getRef(long rcidx) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (((Reference)this.getItemAt(i)).getIdx() != rcidx) continue;
            return (Reference)this.getItemAt(i);
        }
        return null;
    }

    public String getCode(long rcidx) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (((Reference)this.getItemAt(i)).getIdx() != rcidx) continue;
            return ((Reference)this.getItemAt(i)).getCode();
        }
        return "";
    }

    public void setShowName(boolean showName) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            ((Reference)this.getItemAt(i)).setShowName(showName);
        }
    }
}

