/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Gen;
import ReceiptPrinter.PrintReceipt;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.rtf.RTFEditorKit;
import jpos.DlgMessage;
import jpos.PosDateFormatter;
import jpos.PosFocusTraversalPolicy;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.basscom.components.ToServ;
import jpos.basscom.utils.Utils;
import jpos.basscom.utils.guts;
import jpos.ui.DialogButton;

public class RemPosReportRun
extends JDialog
implements KeyEventDispatcher {
    String sRepName = "";
    String[] sFonts = new String[30];
    String[] sFCEscChar = new String[30];
    boolean bLocal = false;
    boolean testing = false;
    String[] sScreen = new String[30];
    String[] sPrint = new String[30];
    String sPrinterPort = null;
    String sPrinterFont = null;
    String sImagePath = null;
    long nMemidx;
    long nGenRepIdx;
    int nPrinterTimeout = 0;
    boolean bOk = true;
    ToServ toserv;
    Connection con;
    int action;
    DialogButton jbPrint = new DialogButton("");
    DialogButton jbCancel = new DialogButton("");
    StringBuffer sComSend;
    StringBuffer sReturn = new StringBuffer("");
    StringBuffer sGet = new StringBuffer("");
    StringBuffer s1 = new StringBuffer("");
    int[] nEsc = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] nPos = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public JPanel jPanel1 = new JPanel();
    public PosScrollPane PosScrollPane1 = new PosScrollPane();
    TitledBorder titledBorder1;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    RTFEditorKit rtf = new RTFEditorKit();
    JEditorPane editor = new JEditorPane();

    public RemPosReportRun() {
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void doPrint() {
        if (this.bOk) {
            this.printReport();
        }
        this.dispose();
    }

    public RemPosReportRun(Connection connDB, Frame parent, boolean modal, ToServ toserv, int action, String sRepCode, long nMemidx, String sWhere) {
        super(parent, "", modal);
        String sTitle = "";
        long nGenRepIdx = 0L;
        try (SqlQuery sql = new SqlQuery(connDB, "select g.descrip, g.genrepidx from genrep g where g.repname = '" + sRepCode + "'");){
            if (sql.next()) {
                sTitle = sql.getString(1);
                nGenRepIdx = sql.getLong(2);
            } else {
                this.bOk = false;
            }
        }
        catch (SQLException e) {
            this.bOk = false;
        }
        if (this.bOk) {
            StringBuffer sComSend = new StringBuffer(nMemidx + "\u0003" + 0 + "\u0003" + nGenRepIdx + "\u0003" + sWhere + "\u0003" + " " + "\u0003" + "0\u0003");
            this.conStruct(connDB, modal, toserv, sTitle, sComSend, action, nGenRepIdx, nMemidx);
        } else {
            this.showMsg("ERROR - Report " + sRepCode + " not set up", "Error");
            this.dispose();
        }
    }

    public RemPosReportRun(Connection connDB, Frame parent, boolean modal, ToServ toserv, String title, StringBuffer sComSend, int action, long nRcidx, long nMemidx) {
        super(parent, "", modal);
        this.conStruct(connDB, modal, toserv, title, sComSend, action, nRcidx, nMemidx);
    }

    public void conStruct(Connection connDB, boolean modal, ToServ toserv, String title, StringBuffer sComSend, int action, long nRcidx, long nMemidx) {
        this.con = connDB;
        this.nGenRepIdx = nRcidx;
        this.toserv = toserv;
        this.nMemidx = nMemidx;
        this.sComSend = sComSend;
        this.action = action;
        try {
            if (!this.loadReport()) {
                this.bOk = false;
                this.dispose();
                return;
            }
            this.jbInit();
            if (action == 1) {
                this.setTitle("Printing " + title);
            } else {
                this.setTitle("Preview " + title);
            }
            this.pack();
            if (action == 0) {
                this.previewReport();
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.jbPrint.setText(StoreParams.res.getString("Alt_P_Print"));
        this.jbCancel.setText(StoreParams.res.getString("Cancel"));
        this.titledBorder1 = new TitledBorder("");
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.editor.setEditorKit(this.rtf);
        this.editor.setAutoscrolls(false);
        this.editor.setEditable(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    RemPosReportRun.this.jbCancel_actionPerformed();
                } else if (e.getKeyCode() == 80 && e.isAltDown()) {
                    RemPosReportRun.this.jbPrint_actionPerformed();
                }
            }
        });
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.jbPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemPosReportRun.this.jbPrint_actionPerformed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemPosReportRun.this.jbCancel_actionPerformed();
            }
        });
        if (this.nEsc[23] > 0) {
            this.jPanel1.setPreferredSize(new Dimension(800, 450));
        } else {
            this.jPanel1.setPreferredSize(new Dimension(450, 450));
        }
        this.PosScrollPane1.setViewportBorder(BorderFactory.createRaisedBevelBorder());
        this.PosScrollPane1.setDoubleBuffered(true);
        if (this.nEsc[23] > 0) {
            this.PosScrollPane1.setPreferredSize(new Dimension(800, 450));
        } else {
            this.PosScrollPane1.setPreferredSize(new Dimension(450, 450));
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RemPosReportRun.this.fini();
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.PosScrollPane1, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.PosScrollPane1.getViewport().add((Component)this.editor, null);
        if (this.action == 0) {
            this.jPanel1.add((Component)this.jbPrint, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.jbCancel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (this.action == 1) {
            this.jPanel1.setPreferredSize(new Dimension(400, 8));
        }
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.editor);
        v.add(this.jbPrint);
        v.add(this.jbCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private boolean loadReport() {
        boolean bError;
        String sScript;
        block51: {
            sScript = "";
            bError = false;
            this.loadTrans();
            this.sGet.setLength(0);
            try (SqlQuery sql = new SqlQuery(this.con, "SELECT REPNAME, coalesce(BLOBIDX, 0) FROM GENREP WHERE GENREPIDX = " + this.nGenRepIdx);){
                if (!sql.next()) break block51;
                this.sRepName = sql.getString(1);
                if (!StringUtils.isNullOrEmpty(this.sRepName)) break block51;
                this.sRepName = "";
                int nBlobidx = sql.getInt(2);
                if (nBlobidx == 0) {
                    bError = true;
                    break block51;
                }
                this.bLocal = true;
                try (SqlQuery sql2 = new SqlQuery(this.con, "select blobtext from blobtext where blobidx = " + nBlobidx);){
                    if (sql2.next()) {
                        sScript = sql2.getString(1);
                        if (StringUtils.isNullOrEmpty(sScript)) {
                            bError = true;
                        }
                    } else {
                        bError = true;
                    }
                }
            }
            catch (Exception s) {
                this.showMsg("Sql Error >> " + PosUtils.getStackTrace(s), "Error");
                return false;
            }
        }
        if (bError) {
            this.showMsg("Report set up incorrectly - no program name or script details", "Error");
            return false;
        }
        this.loadStandardFonts();
        if (this.bLocal) {
            this.runFBLocalReport(this.con, sScript);
        } else {
            try {
                String result = SP.sParams.OnlineReportProvider.executeAndReturnReport(this.sRepName, this.sComSend.toString());
                if (result == null) {
                    throw new Exception("exit");
                }
                this.sGet.append(result);
            }
            catch (Exception e) {
                return false;
            }
        }
        try {
            PosDateFormatter dateFormatter = new PosDateFormatter(null, 3, 3, 2);
            try (SqlQuery sql = new SqlQuery(this.con, "SELECT  'Printed by ' || COALESCE(P.FIRSTNAME, ' '), 'At Store ' || COALESCE(S.NAME, ' '), CURRENT_TIMESTAMP FROM  REFCODE S,  whse w, storeparams sp, PERSON P WHERE S.RCIDX = w.widx AND P.MEMIDX = " + this.nMemidx + " AND w.storeno = sp.storeno ");){
                if (sql.next()) {
                    this.sGet.append(sql.getString(1) + "\u000322Fc");
                    this.sGet.append(sql.getString(2) + "\u000322Fc");
                    dateFormatter.setTimestamp(sql.getTimestamp(3));
                    this.sGet.append(dateFormatter.toString() + "        " + this.sRepName + "\u000322Fc");
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.sGet.append("\u000323Fc");
        this.checkEscapeChars(this.sGet, 30);
        return true;
    }

    private void previewReport() {
        this.sReturn.setLength(0);
        this.s1.setLength(0);
        this.sReturn.append(this.sGet.toString().substring(2, this.sGet.length()));
        if (this.nEsc[29] == 0) {
            this.s1.append("{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang3081{\\fonttbl{\\f0\\fswiss\\fcharset0 Arial;}}\\viewkind4\\uc1");
            this.s1.append("{\\colortbl ;\\red7\\green82\\blue169;\\red208\\green2\\blue27;\\red61\\green176\\blue24;}");
            this.s1.append("\\cf0 \\pard\\li000\\f0");
            this.s1.append("\\plain\\f2 ");
        }
        for (int i = 0; i < 30; ++i) {
            if (this.nEsc[i] <= 0 || i == 30) continue;
            if (this.sScreen[i + 1] != null) {
                this.replaceSB(this.sReturn, this.sFCEscChar[i], this.sScreen[i + 1], this.nEsc[i]);
                continue;
            }
            this.replaceSB(this.sReturn, this.sFCEscChar[i], "", this.nEsc[i]);
        }
        this.s1.append(this.sReturn.toString());
        try {
            StringReader stream = new StringReader(this.s1.toString());
            this.rtf.read(stream, this.editor.getDocument(), 0);
        }
        catch (Exception e) {
            this.editor.setText("Exception: " + PosUtils.getStackTrace(e));
        }
        new FocusRequester(this.editor);
    }

    private void printReport() {
        int i;
        this.sReturn.setLength(0);
        this.s1.setLength(0);
        if (this.nEsc[29] > 0) {
            this.sReturn.append(this.sGet.toString().substring(this.nPos[29] + this.nEsc[29], this.sGet.length()));
        } else {
            this.sReturn.append(this.sGet.toString().substring(2, this.sGet.length()));
        }
        if (this.nEsc[23] == 0) {
            for (i = 0; i < 6; ++i) {
                this.sReturn.append("\u000322Fc");
            }
            this.sReturn.append("\u000304Fc");
            this.nEsc[21] = 5;
            this.nEsc[3] = 5;
        }
        for (i = 0; i < 30; ++i) {
            if (this.nEsc[i] <= 0 || i == 30) continue;
            if (this.sPrint[i + 1] != null) {
                this.replaceSB(this.sReturn, this.sFCEscChar[i], this.sPrint[i + 1], this.nEsc[i]);
                continue;
            }
            this.replaceSB(this.sReturn, this.sFCEscChar[i], "", this.nEsc[i]);
        }
        this.s1.append(this.sReturn.toString());
        ThreadReportPrint chiku = new ThreadReportPrint();
        chiku.printReport();
    }

    private void showMsg(String sMsg, String title) {
        DlgMessage.showMessage(this, Utils.stringWrap(sMsg, 100, false), title, 1);
    }

    private void jbPrint_actionPerformed() {
        this.printReport();
    }

    private void jbCancel_actionPerformed() {
        this.fini();
    }

    private void fini() {
        this.dispose();
    }

    private void checkEscapeChars(StringBuffer sBuf, int nMax) {
        String sSearch = sBuf.toString();
        for (int i = 0; i < nMax; ++i) {
            this.nPos[i] = sSearch.indexOf(this.sFCEscChar[i]);
            if (this.nPos[i] <= -1) continue;
            this.nEsc[i] = this.sFCEscChar[i].length();
        }
        sSearch = null;
    }

    private void replaceSB(StringBuffer sBuf, String pattern, String replace, int plen) {
        String str = sBuf.toString();
        int slen = str.length();
        int s = 0;
        int e = 0;
        sBuf.setLength(0);
        char[] chars = new char[slen];
        while ((e = str.indexOf(pattern, s)) >= 0) {
            str.getChars(s, e, chars, 0);
            sBuf.append(chars, 0, e - s).append(replace);
            s = e + plen;
        }
        str.getChars(s, slen, chars, 0);
        sBuf.append(chars, 0, slen - s);
        str = null;
    }

    private void loadTrans() {
        String val = null;
        try {
            try (SqlQuery sql = new SqlQuery(this.con, "select rcidx, fontidx, translate_to from posrem_printer_fonts where translate_to is not null and rcidx in (616, 617) and fontidx < 30");){
                while (sql.next()) {
                    int nRcidx = sql.getInt(1);
                    int nFontidx = sql.getInt(2);
                    val = sql.getString(3);
                    byte[] buf = RemPosReportRun.fromHexString(val);
                    if (nRcidx == 616) {
                        this.sScreen[nFontidx] = this.StringFromByteArray(buf);
                        continue;
                    }
                    this.sPrint[nFontidx] = this.StringFromByteArray(buf);
                }
            }
            sql = new SqlQuery(this.con, "SELECT printerport, coalesce(printer_timeout, 0), coalesce(printerfont, ''), imagepath from storeparams");
            var5_4 = null;
            try {
                if (sql.next()) {
                    this.sPrinterPort = sql.getString(1);
                    this.nPrinterTimeout = sql.getInt(2);
                    this.sPrinterFont = sql.getString(3);
                    this.sImagePath = sql.getString(4);
                }
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
            finally {
                if (sql != null) {
                    if (var5_4 != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable) {
                            var5_4.addSuppressed(throwable);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
            if (this.testing) {
                this.sPrinterPort = "C:\\test.txt";
                this.sImagePath = "\\C:";
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private String StringFromByteArray(byte[] buf) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream(512);
        ba.write(buf, 0, buf.length);
        return ba.toString();
    }

    private static byte[] fromHexString(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("fromHexString requires an even number of hex characters");
        }
        byte[] b = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = RemPosReportRun.charToNibble(s.charAt(i));
            int low = RemPosReportRun.charToNibble(s.charAt(i + 1));
            b[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return b;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    public void Close() {
        this.dispose();
    }

    private void loadStandardFonts() {
        this.sFonts[0] = "justifyLeft";
        this.sFonts[1] = "justifyCentre";
        this.sFonts[2] = "justifyRight";
        this.sFonts[3] = "paperCut";
        this.sFonts[4] = "openDrawer";
        this.sFonts[5] = "fontANormal";
        this.sFonts[6] = "fontBNormal";
        this.sFonts[7] = "fontABold";
        this.sFonts[8] = "fontBBold";
        this.sFonts[9] = "fontAUnderline";
        this.sFonts[10] = "fontBUnderline";
        this.sFonts[11] = "fontABoldUnderline";
        this.sFonts[12] = "fontBBoldUnderline";
        this.sFonts[13] = "fontADoubleHeight";
        this.sFonts[14] = "fontBDoubleHeight";
        this.sFonts[15] = "fontADoubleWeight";
        this.sFonts[16] = "fontBDoubleWeight";
        this.sFonts[17] = "fontADoubleHeightAndWeight";
        this.sFonts[18] = "fontBDoubleHeightAndWeight";
        this.sFonts[19] = "upsideDownOn";
        this.sFonts[20] = "upsideDownOff";
        this.sFonts[21] = "paperLF";
        this.sFonts[22] = "paperFeedA";
        this.sFonts[23] = "paperFeedB";
        this.sFCEscChar[0] = "\u000301Fc";
        this.sFCEscChar[1] = "\u000302Fc";
        this.sFCEscChar[2] = "\u000303Fc";
        this.sFCEscChar[3] = "\u000304Fc";
        this.sFCEscChar[4] = "\u000305Fc";
        this.sFCEscChar[5] = "\u000306Fc";
        this.sFCEscChar[6] = "\u000307Fc";
        this.sFCEscChar[7] = "\u000308Fc";
        this.sFCEscChar[8] = "\u000309Fc";
        this.sFCEscChar[9] = "\u000310Fc";
        this.sFCEscChar[10] = "\u000311Fc";
        this.sFCEscChar[11] = "\u000312Fc";
        this.sFCEscChar[12] = "\u000313Fc";
        this.sFCEscChar[13] = "\u000314Fc";
        this.sFCEscChar[14] = "\u000315Fc";
        this.sFCEscChar[15] = "\u000316Fc";
        this.sFCEscChar[16] = "\u000317Fc";
        this.sFCEscChar[17] = "\u000318Fc";
        this.sFCEscChar[18] = "\u000319Fc";
        this.sFCEscChar[19] = "\u000320Fc";
        this.sFCEscChar[20] = "\u000321Fc";
        this.sFCEscChar[21] = "\u000322Fc";
        this.sFCEscChar[22] = "\u000323Fc";
        this.sFCEscChar[23] = "\u000324Fc";
        this.sFCEscChar[24] = "\u000325Fc";
        this.sFCEscChar[25] = "\u000326Fc";
        this.sFCEscChar[26] = "\u000327Fc";
        this.sFCEscChar[27] = "\u000328Fc";
        this.sFCEscChar[28] = "\u000329Fc";
        this.sFCEscChar[29] = "\u000330Fc";
        for (int i = 24; i < 30; ++i) {
            this.sFonts[i] = "";
        }
    }

    private String runFBLocalReport(Connection con, String spScript) {
        this.sGet.append("02");
        Vector<String> tokens = new Vector<String>();
        Utils.stringTokenize(this.sComSend.toString(), "\u0003", tokens);
        int nOptCount = Integer.parseInt(tokens.elementAt(1));
        String sWhere = tokens.elementAt(3);
        for (int i = 0; i < nOptCount; ++i) {
            spScript = guts.strReplace(spScript, "$" + (i + 2), tokens.elementAt(5));
        }
        if (!sWhere.equals("")) {
            sWhere = " and " + sWhere + " ";
        }
        StringBuffer sb = new StringBuffer();
        Vector<String> vectStmnts = new Vector<String>(10);
        Utils.stringTTokenize(spScript, ";", vectStmnts);
        for (int stmntNo = 0; stmntNo < vectStmnts.size(); ++stmntNo) {
            String sqlSelect = vectStmnts.elementAt(stmntNo).trim();
            if (sqlSelect.equals("") || sqlSelect.startsWith("--")) continue;
            try {
                sqlSelect = Utils.stringReplace(sqlSelect, "%where%", sWhere);
                sqlSelect = Utils.stringReplace(sqlSelect, "\u0004", "\n");
                try (SqlQuery sql = new SqlQuery(con, sqlSelect);){
                    int colCount = sql.getMetaData().getColumnCount();
                    while (sql.next()) {
                        for (int col = 1; col <= colCount; ++col) {
                            this.sGet.append(sql.getString(col));
                        }
                        this.sGet.append("\u000322Fc");
                    }
                    continue;
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        this.subLocalOutput();
        return sb.toString();
    }

    private void subLocalOutput() {
        int i;
        int[] nEsc = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] nPos = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        String sSearch = this.sGet.toString();
        for (i = 0; i < 30; ++i) {
            nPos[i] = sSearch.indexOf(this.sFonts[i]);
            if (nPos[i] <= -1) continue;
            nEsc[i] = this.sFonts[i].length();
        }
        sSearch = null;
        for (i = 0; i < 30; ++i) {
            if (nEsc[i] <= 0 || i == 30) continue;
            this.replaceSB(this.sGet, this.sFonts[i], this.sFCEscChar[i], nEsc[i]);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive()) {
            this.processKeyEvent(e);
        }
        return false;
    }

    @Override
    public void dispose() {
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        super.dispose();
    }

    class ThreadReportPrint
    extends Thread {
        boolean finishedPrint = false;
        String objLock = "PrintLockTimeOut" + String.valueOf(Thread.currentThread().getId());

        ThreadReportPrint() {
        }

        ThreadReportPrint(Object LockObject) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void printReport() {
            ThreadReportPrint newThread = new ThreadReportPrint();
            newThread.start();
            String string = this.objLock;
            synchronized (string) {
                try {
                    if (RemPosReportRun.this.nPrinterTimeout == 0) {
                        this.objLock.wait();
                    } else {
                        this.objLock.wait(RemPosReportRun.this.nPrinterTimeout * 1000);
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
            if (!newThread.finishedPrint) {
                RemPosReportRun.this.showMsg("It seems there may be a problem with the printer " + RemPosReportRun.this.sPrinterPort + " - Please check", "Error");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try (Object pr = new PrintReceipt(RemPosReportRun.this.sPrinterPort, RemPosReportRun.this.sPrinterFont);){
                    ((PrintReceipt)pr).PrintString(RemPosReportRun.this.s1.toString() + "\n");
                }
                if (RemPosReportRun.this.nEsc[23] == 0) {
                    Gen.PrintImage(RemPosReportRun.this.sPrinterPort, RemPosReportRun.this.sImagePath);
                }
                pr = this.objLock;
                synchronized (pr) {
                    this.finishedPrint = true;
                    this.objLock.notify();
                }
            }
            catch (Exception e) {
                String string = this.objLock;
                synchronized (string) {
                    this.objLock.notify();
                }
            }
        }
    }

    class FocusRequester
    implements Runnable {
        private JEditorPane comp;

        public FocusRequester(JEditorPane comp) {
            this.comp = comp;
            try {
                SwingUtilities.invokeLater(this);
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }

        @Override
        public void run() {
            this.comp.select(0, 0);
        }
    }
}

