/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Receipt;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.Note;
import jpos.PosDateFormatter;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SalesRep;
import jpos.SqlQuery;
import jpos.Store;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.XMLLocal;
import jpos.basscom.utils.Utils;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class SkuReservation {
    private StoreParams sParams;
    private StyleLine styleLine;
    private String transnum;
    private Element person;
    private SalesRep salesRep;
    private String notes;
    private PosDateFormatter dateFormatter;
    private long vhidx;
    private Store store;
    private double origQty;
    private List<?> notesXML;

    public SkuReservation(String trans_number, long skuidx, StoreParams psParams, boolean bLoadPersonFromHO) {
        block25: {
            this.person = new Element("person");
            this.salesRep = new SalesRep();
            this.dateFormatter = new PosDateFormatter(null, 3, 3, 0);
            this.vhidx = -1L;
            this.sParams = psParams;
            this.transnum = trans_number;
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT O.CLIENTIDX, O.SREPIDX, O.VHIDX, O.NOTES1,  O.TRAND, SUM(D.QTY), SUM(CASE WHEN H.VHIDX = O.VHIDX THEN COALESCE(D.QTY_AVAIL,0) ELSE 0 END),  P.PERIDX, NULL, P.FIRSTNAME, P.SURNAME,  (SELECT MAX(PH.PHONENUM) FROM PHONENUM PH WHERE PH.PERIDX = P.PERIDX AND PH.PHONETYIDX = 154 AND PH.\"ACTIVE\" = 1),  SUM(CASE WHEN D.VHIDX = O.VHIDX THEN D.QTY ELSE 0 END),  O.WIDX, R.CODE, R.NAME, W.STORENO, P.CUSTIDX FROM RET_TRANH O LEFT JOIN PERSON P ON P.PERIDX = O.CLIENTIDX,  RET_TRANH H, RET_TRAND D, WHSE W, REFCODE R WHERE O.DOCKET_NUMBER = O.TRANS_NUMBER AND H.VHIDX = D.VHIDX AND O.TR_TYPE = 614 AND H.TR_TYPE = 614 AND  O.DOCKET_NUMBER = " + PosUtils.StringToSqlString(this.transnum) + " AND O.WIDX = " + this.sParams.getStoreIdx() + " AND H.TRANS_NUMBER = " + PosUtils.StringToSqlString(this.transnum) + " AND D.SKUIDX = " + skuidx + " AND W.WIDX = O.WIDX AND R.RCIDX = O.WIDX " + "GROUP BY H.TRANS_NUMBER, O.SREPIDX, O.VHIDX, O.NOTES1, O.TRAND, O.CLIENTIDX, D.SKUIDX, " + " P.PERIDX, P.FIRSTNAME, P.SURNAME, O.WIDX, R.CODE, R.NAME, W.STORENO, P.CUSTIDX");){
                if (!sql.next()) break block25;
                this.styleLine = new StyleLine(skuidx, sql.getDouble(6), this.sParams);
                this.styleLine.setQty(5, sql.getDouble(7));
                if (!this.styleLine.isValid()) {
                    this.styleLine.stylecode = StoreParams.res.getString("Invalid");
                }
                this.origQty = sql.getDouble(13);
                this.styleLine.setAvailQtyChanged(false);
                this.vhidx = sql.getLong(3);
                this.store = new Store(sql.getString(16), sql.getString(15), sql.getString(17), sql.getLong(14));
                this.notes = sql.getString(4);
                this.dateFormatter.setTimestamp(sql.getTimestamp(5));
                this.salesRep.setSalesRep(sql.getLong(2), this.sParams);
                if (sql.getString(8) != null) {
                    try {
                        this.person = XMLLocal.getElement(this.sParams.conn, "person", sql.getString(8));
                    }
                    catch (Exception ex) {
                        PosUtils.logError(ex);
                    }
                } else if (bLoadPersonFromHO) {
                    this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("person", sql.getString(1)).getXML();
                    if (this.sParams.root != null) {
                        try {
                            List contents = this.sParams.root.getChildren();
                            while (contents.size() > 0) {
                                this.person.addContent(((Element)contents.get(0)).detach());
                            }
                            List attributes = this.sParams.root.getAttributes();
                            while (attributes.size() > 0) {
                                this.person.setAttribute(((Attribute)attributes.get(0)).detach());
                            }
                        }
                        catch (Exception ex) {
                            PosUtils.logError(ex);
                        }
                    }
                }
                this.notesXML = Note.getNotes(this.vhidx, "RET_TRANH", this.sParams.conn);
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }
    }

    public long getPeridx() {
        try {
            if (this.person != null && this.person.getAttribute("peridx") != null) {
                return this.person.getAttribute("peridx").getLongValue();
            }
        }
        catch (DataConversionException e) {
            PosUtils.logError(e);
        }
        return 0L;
    }

    public void reverseReservation(long nLoggedInMemidx, long nLoggedInPeridx, String fromDockNum) throws SQLException {
        Throwable throwable;
        SqlQuery sql;
        String saleDockNum = fromDockNum == null || fromDockNum.equals("") ? "null" : PosUtils.StringToSqlString(fromDockNum);
        String docknum = PosUtils.padZeroes(this.sParams.getNextDocketNum("SkuReservation.reverseReservation"), 8);
        long personIdx = this.getPeridx();
        long salesRepMemidx = this.salesRep.getMemidx();
        if (personIdx == 0L) {
            sql = new SqlQuery(this.sParams.conn, "SELECT CLIENTIDX FROM RET_TRANH WHERE VHIDX = " + String.valueOf(this.vhidx));
            throwable = null;
            try {
                if (sql.next()) {
                    personIdx = sql.getLong(1);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sql != null) {
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
        }
        if (salesRepMemidx == 0L) {
            sql = new SqlQuery(this.sParams.conn, "SELECT MEMBER_GENERATEDIDX FROM RET_TRANH WHERE VHIDX = " + String.valueOf(this.vhidx));
            throwable = null;
            try {
                if (sql.next()) {
                    salesRepMemidx = sql.getLong(1);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (sql != null) {
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
        }
        throwable = null;
        try (Statement stmt = this.sParams.conn.createStatement();){
            stmt.executeUpdate("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRANS_NUMBER, TRAND,  TILL_NUMBER, STAFF_SALE_FLAG, SREPIDX, MEMBER_GENERATEDIDX, TRANSMEMIDX, TRANSSREPIDX,  DOCKET_NUMBER, COMPLETE, CLIENTIDX, FROM_WIDX, NOTES1, SALE_DATE ) VALUES( " + this.sParams.nextVal("XRET_TRANH") + ", 614, 1, " + this.sParams.getStoreIdx() + ", " + PosUtils.StringToSqlString(this.transnum) + ", CURRENT_TIMESTAMP, " + " " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", 0, " + this.salesRep.getPeridx() + ", " + salesRepMemidx + ", " + nLoggedInMemidx + ", " + nLoggedInPeridx + ", " + PosUtils.StringToSqlString(docknum) + ", 1, " + String.valueOf(personIdx) + ", " + this.sParams.getStoreIdx() + ", " + saleDockNum + ", TRUNC_DATE(current_timestamp))");
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.sParams.currVal("XRET_TRANH"));
        this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.sParams.currVal("XRET_TRANH"));
        if (this.styleLine.getQty() < this.origQty) {
            this.styleLine.setQty(5, Math.max(this.styleLine.getQty(5) - this.styleLine.getQty(), 0.0));
            this.updateAvailQty();
        }
        double oldQty = Math.min(this.styleLine.getQty(), this.origQty);
        this.styleLine.setQty(oldQty * -1.0);
        this.styleLine.setQty(5, 0.0);
        this.styleLine.db_insertline();
        this.styleLine.setQty(oldQty);
    }

    public void updateAvailQty() throws SQLException {
        try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("UPDATE RET_TRAND SET QTY_AVAIL = ? WHERE VHIDX = ? AND SKUIDX = ?");){
            prepStmt.setDouble(1, this.styleLine.getQty(5));
            prepStmt.setLong(2, this.vhidx);
            prepStmt.setLong(3, this.styleLine.getSkuidx());
            prepStmt.executeUpdate();
        }
        this.styleLine.setAvailQtyChanged(false);
    }

    public void printDockets(PosFrame parentFr, boolean reprint) {
        Receipt receipt = new Receipt(parentFr, StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), this.vhidx, reprint);
        if (receipt.isValidReceipt()) {
            receipt.PrintReservation(this.person, true);
            receipt.PrintReservation(this.person, false);
        } else {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(parentFr, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
        }
        receipt.close();
    }

    public void printStoreDocket(PosFrame parentFr, boolean reprint) {
        Receipt receipt = new Receipt(parentFr, StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), this.vhidx, reprint);
        if (receipt.isValidReceipt()) {
            if (this.styleLine.getQty(5) > 0.0) {
                receipt.PrintReservation(this.person, false);
            }
        } else {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(parentFr, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
        }
        receipt.close();
    }

    public PosDateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    public SalesRep getSalesRep() {
        return this.salesRep;
    }

    public Element getPerson() {
        return this.person;
    }

    public void setPerson(Element person) {
        this.person = person;
    }

    public StyleLine getStyleLine() {
        return this.styleLine;
    }

    public Store getStore() {
        return this.store;
    }

    public List<?> getNotesXML() {
        return this.notesXML;
    }

    public double getOrigQty() {
        return this.origQty;
    }

    public String getTransnum() {
        return this.transnum;
    }

    public long getVhidx() {
        return this.vhidx;
    }

    public String getNotes() {
        return this.notes;
    }

    public static Vector<SkuReservation> allocateTransfersToReservations(Vector<StyleLine> transferStyleLines) {
        Vector<SkuReservation> reservations = new Vector<SkuReservation>();
        if (transferStyleLines.size() == 0) {
            return reservations;
        }
        String skuList = "";
        for (StyleLine styleLine : transferStyleLines) {
            if (skuList.isEmpty()) {
                skuList = String.valueOf(styleLine.getSkuidx());
                continue;
            }
            skuList = skuList + "," + String.valueOf(styleLine.getSkuidx());
        }
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT H.TRANS_NUMBER, H.CLIENTIDX, D.SKUIDX FROM RET_TRANH H, RET_TRAND D WHERE H.VHIDX = D.VHIDX AND H.TR_TYPE = 614 AND D.SKUIDX IN (" + skuList + ") " + "GROUP BY H.TRANS_NUMBER, H.CLIENTIDX, D.SKUIDX " + "HAVING SUM(D.QTY) > 0 AND SUM(COALESCE(D.QTY_AVAIL,0))<SUM(D.QTY) " + "ORDER BY MIN(H.TRAND)");){
            while (sql.next()) {
                SkuReservation reservation = new SkuReservation(sql.getString("TRANS_NUMBER"), sql.getLong("SKUIDX"), SP.sParams, true);
                StyleLine reservationLine = reservation.getStyleLine();
                for (StyleLine transferLine : transferStyleLines) {
                    if (transferLine == null || transferLine.getSkuidx() != reservationLine.getSkuidx()) continue;
                    if (transferLine.getQty(5) == -1.0) {
                        transferLine.setQty(5, transferLine.getQty() - transferLine.getQty(1));
                    }
                    double qty = Math.min(transferLine.getQty(5), reservationLine.getQty() - reservationLine.getQty(5));
                    reservationLine.setQty(5, reservationLine.getQty(5) + qty);
                    transferLine.setQty(5, transferLine.getQty(5) - qty);
                    if (reservationLine.getQty(5) != reservationLine.getQty()) continue;
                    break;
                }
                if (!reservationLine.isAvailQtyChanged()) continue;
                reservations.add(reservation);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return reservations;
    }

    public boolean isUpToDate(boolean excludeAvailQTY) {
        SkuReservation dbSku = new SkuReservation(this.transnum, this.styleLine.getSkuidx(), this.sParams, false);
        return this.qtyAndDateEqual(dbSku, excludeAvailQTY);
    }

    private boolean qtyAndDateEqual(SkuReservation sku, boolean excludeAvailQTY) {
        return this.styleLine.getQty() == sku.styleLine.getQty() && this.origQty == sku.origQty && (excludeAvailQTY || this.styleLine.getQty(5) == sku.styleLine.getQty(5)) && this.vhidx == sku.vhidx && this.dateFormatter.getTimestamp().equals(sku.dateFormatter.getTimestamp());
    }
}

