/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Properties;
import jpos.DlgImage;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.StoreParams;

public class SlideShow
extends Thread {
    DlgImage dlgImage;
    StoreParams sParams;
    int nPause = 2000;
    private Properties props = new Properties();

    public SlideShow(PosFrame frParent, StoreParams sParams) {
        this.sParams = sParams;
        this.dlgImage = new DlgImage(frParent, StoreParams.res.getString("SlideShow"), sParams.slideShowPath + sParams.tillnum + "Image.ini", false);
        this.dlgImage.setVisible(true);
    }

    public boolean isRunning() {
        if (this.dlgImage == null) {
            return false;
        }
        return this.dlgImage.isVisible();
    }

    public void endSlidShow() {
        if (this.dlgImage != null && this.dlgImage.isVisible()) {
            this.dlgImage.dispose();
        }
    }

    @Override
    public void run() {
        String sFileName = null;
        String sFileExt = null;
        File dir = new File(this.sParams.slideShowPath);
        Object[] children = dir.list();
        if (children != null) {
            try {
                this.loadSettings(this.sParams.slideShowPath + this.sParams.tillnum + "Image.ini");
            }
            catch (Exception e) {
                // empty catch block
            }
            Arrays.sort(children);
            while (this.dlgImage != null && this.dlgImage.isVisible()) {
                for (int i = 0; i < children.length && this.dlgImage.isVisible(); ++i) {
                    if (((String)children[i]).length() <= 4 || !(sFileExt = ((String)children[i]).substring(((String)children[i]).length() - 4, ((String)children[i]).length()).toLowerCase()).equals(".jpg") && !sFileExt.equals(".gif") && !sFileExt.equals(".png")) continue;
                    sFileName = this.sParams.slideShowPath + (String)children[i];
                    this.dlgImage.setImage(sFileName, StoreParams.res.getString("SlideShow"));
                    this.dlgImage.repaint();
                    try {
                        Thread.sleep(this.nPause);
                        continue;
                    }
                    catch (InterruptedException e) {
                        PosUtils.logError(e);
                    }
                }
            }
            if (this.dlgImage != null) {
                this.dlgImage.dispose();
            }
        }
    }

    private void loadSettings(String fileName) throws FileNotFoundException {
        this.props.clear();
        if (new File(fileName).exists()) {
            try (FileInputStream in = new FileInputStream(fileName);){
                this.props.load(in);
                this.nPause = Integer.parseInt(this.props.getProperty("pause", "2")) * 1000;
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        } else {
            this.nPause = 2000;
        }
    }
}

