/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.swing;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import jpos.basscom.utils.Utils;

public class BJFrame
extends JFrame {
    static ResourceBundle res = ResourceBundle.getBundle("TransJavaCommon");
    private String sivTitle;
    private String sivDatabase;
    private String sivSchema;
    private String sivMem;
    private JTabbedPane ivTabbedPane;

    public BJFrame() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(new Dimension(800, 570));
        this.setWinTitle(this.sivTitle);
    }

    public int getTopTab() {
        return this.ivTabbedPane.getSelectedIndex();
    }

    public void setTopTab(int nTab) {
        this.ivTabbedPane.setSelectedIndex(nTab);
    }

    public void setWinTitle(String spTitle) {
        String sTitle = "";
        sTitle = sTitle + "(";
        if (this.sivMem != null) {
            sTitle = sTitle + Utils.stringLeft(this.sivMem, 1).toUpperCase();
            if (this.sivMem.length() > 1) {
                sTitle = sTitle + Utils.stringRight(this.sivMem, this.sivMem.length() - 1).toLowerCase();
            }
            sTitle = sTitle + "@";
        }
        if (this.sivDatabase != null) {
            sTitle = sTitle + this.sivDatabase + "\\";
        }
        if (this.sivSchema != null) {
            sTitle = sTitle + this.sivSchema;
        }
        sTitle = sTitle + ")";
        sTitle = spTitle + " " + sTitle;
        this.setTitle(sTitle);
    }
}

