/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jpos.PosUtils;
import jpos.basscom.utils.Utils;

public abstract class BUtils {
    public static boolean queryStmt(Connection connpDB, String spSQL, int npCols, Vector<Vector<String>> vResult) {
        if (!Utils.queryStmt(connpDB, spSQL, npCols, vResult)) {
            PosUtils.logError(vResult.elementAt(0).elementAt(0) + '\n' + Utils.stringWrap(spSQL, 80, false));
            return false;
        }
        return true;
    }

    public static Image getBLOBImage(Connection connpDB, long nBlobidx) {
        byte[] byteArr = Utils.getBLOB(connpDB, nBlobidx);
        return Toolkit.getDefaultToolkit().createImage(byteArr);
    }

    public static void setDefaultCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void setCrossHairCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(1));
    }

    public static void setMoveCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(13));
    }

    public static void setWaitCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setEResizeCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(11));
    }

    public static void setWResizeCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(10));
    }

    public static JPanel groupBox(String title, int width, int height) {
        Border etched = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(etched, title, 1, 2);
        JPanel grpBox = new JPanel();
        grpBox.setLayout(null);
        grpBox.setSize(width, height);
        grpBox.setBorder(titledBorder);
        return grpBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getColumnType(Connection pConn, String sTable, String sColumn) {
        String sColType = "S";
        Statement stmt = null;
        try {
            stmt = pConn.createStatement();
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery("SELECT " + sColumn + " FROM " + sTable + ", DUAL WHERE 1 = 2 ");
                ResultSetMetaData rsmd = rs.getMetaData();
                int nType = rsmd.getColumnType(1);
                sColType = nType == 1 || nType == 12 ? "S" : (nType == 91 || nType == 92 || nType == 93 ? "D" : "N");
            }
            catch (Throwable throwable) {
                Utils.closeResultSet(rs);
                throw throwable;
            }
            Utils.closeResultSet(rs);
        }
        catch (SQLException sql) {
        }
        finally {
            Utils.closeStatement(stmt);
        }
        return sColType;
    }
}

