/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.utils;

import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import jpos.basscom.utils.TypConv;

public class PeriodCalc {
    static ResourceBundle res = ResourceBundle.getBundle("TransJavaCommon");

    public static String getPeriodRecurDesc(String params) {
        StringTokenizer toks = new StringTokenizer(params, "@", true);
        String DMWY = toks.nextToken();
        int day = -1;
        int week = -1;
        int month = -1;
        int next_type = -1;
        if (!DMWY.equals("@")) {
            String token;
            toks.nextToken();
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                day = TypConv.toInt(token);
                toks.nextToken();
            }
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                week = TypConv.toInt(token);
                toks.nextToken();
            }
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                month = TypConv.toInt(token);
                toks.nextToken();
            }
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                next_type = TypConv.toInt(token);
            }
        }
        return PeriodCalc.getPeriodRecurDesc(DMWY, day, week, month, next_type);
    }

    public static String getPeriodDesc(String params) {
        StringTokenizer toks = new StringTokenizer(params, "@", true);
        String DMWY = toks.nextToken();
        int day = -1;
        int week = -1;
        int month = -1;
        int next_type = -1;
        if (!DMWY.equals("@")) {
            String token;
            toks.nextToken();
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                day = TypConv.toInt(token);
                toks.nextToken();
            }
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                week = TypConv.toInt(token);
                toks.nextToken();
            }
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                month = TypConv.toInt(token);
                toks.nextToken();
            }
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                next_type = TypConv.toInt(token);
            }
        }
        return PeriodCalc.getPeriodDesc(DMWY, day, week, month, next_type);
    }

    public static GregorianCalendar getNextDate(String params, GregorianCalendar fromCalender) {
        StringTokenizer toks = new StringTokenizer(params, "@", true);
        String DMWY = toks.nextToken();
        int day = -1;
        int week = -1;
        int month = -1;
        int next_type = -1;
        if (!DMWY.equals("@")) {
            String token;
            toks.nextToken();
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                day = TypConv.toInt(token);
                toks.nextToken();
            }
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                week = TypConv.toInt(token);
                toks.nextToken();
            }
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                month = TypConv.toInt(token);
                toks.nextToken();
            }
            if (toks.hasMoreTokens() && !(token = toks.nextToken()).equals("@")) {
                next_type = TypConv.toInt(token);
            }
        }
        return PeriodCalc.getNextDate(DMWY, day, week, month, next_type, fromCalender);
    }

    public static String getPeriodRecurDesc(String sDWMY, int nDay, int nWk, int nMth, int nNextType) {
        String sDesc = null;
        if (sDWMY.equals("D")) {
            if (nDay > 1) {
                Object[] objs1 = new Object[]{new Integer(nDay)};
                sDesc = MessageFormat.format(res.getString("Every_0_Days"), objs1);
            } else {
                sDesc = res.getString("Every_Day");
            }
        } else if (sDWMY.equals("W")) {
            if (nWk > 1) {
                Object[] objs2 = new Object[]{new Integer(nWk)};
                sDesc = MessageFormat.format(res.getString("Every_0_weeks_on"), objs2);
            } else {
                sDesc = res.getString("Every_week_on");
            }
            sDesc = sDesc + PeriodCalc.DayDescX(nDay);
        } else if (sDWMY.equals("M")) {
            if (nWk != -1) {
                Object[] objs3 = new Object[]{PeriodCalc.WkDescX(nWk), PeriodCalc.DayDescX(nDay)};
                sDesc = MessageFormat.format(res.getString("The_0_1_of_every"), objs3);
            } else {
                Object[] objs4 = new Object[]{new Integer(nDay)};
                sDesc = MessageFormat.format(res.getString("Day_0_of_every"), objs4);
            }
            sDesc = nMth == 0 || nMth == 1 ? sDesc + res.getString("month") : sDesc + nMth + res.getString("months");
        } else if (sDWMY.equals("Y")) {
            if (nWk == -1) {
                Object[] objs5 = new Object[]{PeriodCalc.MthDescX(nMth), PeriodCalc.NumDayDescX(nDay)};
                sDesc = MessageFormat.format(res.getString("Every_0_on_1_"), objs5);
            } else {
                Object[] objs6 = new Object[]{PeriodCalc.WkDescX(nWk), PeriodCalc.DayDescX(nDay), PeriodCalc.MthDescX(nMth)};
                sDesc = MessageFormat.format(res.getString("Every_0_1_in_2_"), objs6);
            }
        }
        return sDesc;
    }

    public static String getPeriodDesc(String sDWMY, int nDay, int nWk, int nMth, int nNextType) {
        String sDesc = null;
        if (sDWMY.equals("D")) {
            if (nDay != 1) {
                Object[] objs1 = new Object[]{new Integer(nDay)};
                sDesc = MessageFormat.format(res.getString("After_0_Days"), objs1);
            } else {
                sDesc = res.getString("After_1_Day");
            }
        } else if (sDWMY.equals("W")) {
            if (nWk > 1) {
                Object[] objs2 = new Object[]{new Integer(nWk)};
                sDesc = MessageFormat.format(res.getString("After_0_weeks_on"), objs2);
            } else {
                sDesc = res.getString("After_1_week_on");
            }
            sDesc = sDesc + PeriodCalc.DayDescX(nDay);
        } else if (sDWMY.equals("M")) {
            if (nWk != -1) {
                Object[] objs3 = new Object[]{PeriodCalc.WkDescX(nWk), PeriodCalc.DayDescX(nDay)};
                sDesc = MessageFormat.format(res.getString("The_0_1_in"), objs3);
            } else {
                sDesc = nNextType == 0 || nNextType == -1 ? res.getString("up_to") : res.getString("next");
                sDesc = res.getString("Day") + nDay + sDesc;
            }
            sDesc = nMth == 0 || nMth == 1 ? sDesc + res.getString("1month") : sDesc + nMth + res.getString("months");
        } else if (sDWMY.equals("Y")) {
            sDesc = nWk == -1 ? "On " + PeriodCalc.MthDescX(nMth) + " " + PeriodCalc.NumDayDescX(nDay) : "The " + PeriodCalc.WkDescX(nWk) + " " + PeriodCalc.DayDescX(nDay) + " in " + PeriodCalc.MthDescX(nMth);
        }
        return sDesc;
    }

    public static GregorianCalendar getNextDate(String sDWMY, int nDay, int nWk, int nMth, int nNextType, GregorianCalendar fromCalender) {
        char sType = sDWMY.trim().charAt(0);
        int myYear = fromCalender.get(1);
        int myMonth = fromCalender.get(2);
        int myDayOfMonth = fromCalender.get(5);
        GregorianCalendar tempCalender = new GregorianCalendar(myYear, myMonth, myDayOfMonth);
        tempCalender.setFirstDayOfWeek(7);
        block0 : switch (sType) {
            case 'D': {
                tempCalender.add(5, nDay);
                break;
            }
            case 'W': {
                if (nWk <= 0) break;
                int nWkLoop = nWk;
                while (true) {
                    if (tempCalender.get(7) == PeriodCalc.dayOfWeek(nDay)) {
                        --nWkLoop;
                    }
                    if (nWkLoop == 0) break block0;
                    tempCalender.add(5, 1);
                }
            }
            case 'M': {
                tempCalender.setLenient(true);
                if (nWk < 0) {
                    if (nMth <= 0) {
                        nMth = 1;
                    }
                    if (nNextType == 0) {
                        tempCalender.set(5, 1);
                        if (fromCalender.get(5) > nDay) {
                            tempCalender.add(2, nMth);
                        } else {
                            tempCalender.add(2, nMth - 1);
                        }
                    } else {
                        tempCalender.set(5, 1);
                        tempCalender.add(2, nMth);
                    }
                    int nLastDay = PeriodCalc.getLastDayOfMonth(tempCalender);
                    if (nDay > nLastDay) {
                        tempCalender.set(5, PeriodCalc.DefaultDayNum(nLastDay));
                        break;
                    }
                    tempCalender.set(5, PeriodCalc.DefaultDayNum(nDay));
                    break;
                }
                if (nMth > 1) {
                    tempCalender.add(2, nMth - 1);
                }
                if (nWk == 4) {
                    int nLastDay = PeriodCalc.getLastDayOfMonth(tempCalender);
                    tempCalender.set(5, nLastDay);
                    while (tempCalender.get(7) != PeriodCalc.dayOfWeek(nDay)) {
                        tempCalender.add(5, -1);
                    }
                    break;
                }
                tempCalender.set(5, 1);
                int nWkLoop = nWk;
                while (true) {
                    if (tempCalender.get(7) == PeriodCalc.dayOfWeek(nDay)) {
                        --nWkLoop;
                    }
                    if (nWkLoop < 0) break;
                    tempCalender.add(5, 1);
                }
                if (fromCalender.getTime().compareTo(tempCalender.getTime()) <= 0) break;
                tempCalender.set(5, 1);
                tempCalender.add(2, 1);
                nWkLoop = nWk;
                while (true) {
                    if (tempCalender.get(7) == PeriodCalc.dayOfWeek(nDay)) {
                        --nWkLoop;
                    }
                    if (nWkLoop < 0) break block0;
                    tempCalender.add(5, 1);
                }
            }
            case 'Y': {
                if (nWk < 0) {
                    tempCalender.set(5, 1);
                    tempCalender.set(2, nMth);
                    int nDaySet = PeriodCalc.getLastDayOfMonth(tempCalender);
                    if (nDaySet > nDay) {
                        nDaySet = nDay;
                    }
                    tempCalender.set(5, nDaySet);
                    if (fromCalender.getTime().compareTo(tempCalender.getTime()) <= 0) break;
                    tempCalender.set(5, 1);
                    tempCalender.add(1, 1);
                    nDaySet = PeriodCalc.getLastDayOfMonth(tempCalender);
                    if (nDaySet > nDay) {
                        nDaySet = nDay;
                    }
                    tempCalender.set(5, nDaySet);
                    break;
                }
                if (nWk == 4) {
                    tempCalender.set(5, 1);
                    tempCalender.set(2, nMth);
                    tempCalender.set(5, PeriodCalc.getLastDayOfMonth(tempCalender));
                    while (tempCalender.get(7) != PeriodCalc.dayOfWeek(nDay)) {
                        tempCalender.add(5, -1);
                    }
                    if (fromCalender.getTime().compareTo(tempCalender.getTime()) <= 0) break;
                    tempCalender.set(5, 1);
                    tempCalender.set(1, myYear + 1);
                    tempCalender.set(2, nMth);
                    tempCalender.set(5, PeriodCalc.getLastDayOfMonth(tempCalender));
                    while (tempCalender.get(7) != PeriodCalc.dayOfWeek(nDay)) {
                        tempCalender.add(5, -1);
                    }
                    break;
                }
                tempCalender = new GregorianCalendar(myYear, nMth, 1);
                int nWkLoop = nWk;
                while (true) {
                    if (tempCalender.get(7) == PeriodCalc.dayOfWeek(nDay)) {
                        --nWkLoop;
                    }
                    if (nWkLoop < 0) break;
                    tempCalender.add(5, 1);
                }
                if (fromCalender.getTime().compareTo(tempCalender.getTime()) <= 0) break;
                nWkLoop = nWk;
                tempCalender = new GregorianCalendar(myYear + 1, nMth, 1);
                while (true) {
                    if (tempCalender.get(7) == PeriodCalc.dayOfWeek(nDay)) {
                        --nWkLoop;
                    }
                    if (nWkLoop < 0) break block0;
                    tempCalender.add(5, 1);
                }
            }
        }
        return tempCalender;
    }

    private static int DefaultDayNum(int parWk) {
        switch (parWk) {
            case 0: {
                return 1;
            }
        }
        return parWk;
    }

    private static int getLastDayOfMonth(GregorianCalendar inCalender) {
        int lastDay = 0;
        switch (inCalender.get(2)) {
            case 0: {
                lastDay = 31;
                break;
            }
            case 1: {
                if (inCalender.isLeapYear(inCalender.get(1))) {
                    lastDay = 29;
                    break;
                }
                lastDay = 28;
                break;
            }
            case 2: {
                lastDay = 31;
                break;
            }
            case 3: {
                lastDay = 30;
                break;
            }
            case 4: {
                lastDay = 31;
                break;
            }
            case 5: {
                lastDay = 30;
                break;
            }
            case 6: {
                lastDay = 31;
                break;
            }
            case 7: {
                lastDay = 31;
                break;
            }
            case 8: {
                lastDay = 30;
                break;
            }
            case 9: {
                lastDay = 31;
                break;
            }
            case 10: {
                lastDay = 30;
                break;
            }
            case 11: {
                lastDay = 31;
            }
        }
        return lastDay;
    }

    private static String NumDayDescX(int nDay) {
        String slPrefix = String.valueOf(nDay);
        String sDay = null;
        switch (nDay) {
            case 1: {
                sDay = res.getString("st");
                break;
            }
            case 2: {
                sDay = res.getString("nd");
                break;
            }
            case 3: {
                sDay = res.getString("rd");
                break;
            }
            case 21: {
                sDay = res.getString("st");
                break;
            }
            case 22: {
                sDay = res.getString("nd");
                break;
            }
            case 23: {
                sDay = res.getString("rd");
                break;
            }
            case 31: {
                sDay = res.getString("st");
                break;
            }
            default: {
                sDay = res.getString("th");
            }
        }
        return slPrefix + sDay;
    }

    private static String DayDescX(int nDay) {
        String sDay = null;
        switch (nDay) {
            case 0: {
                sDay = res.getString("Saturday");
                break;
            }
            case 1: {
                sDay = res.getString("Sunday");
                break;
            }
            case 2: {
                sDay = res.getString("Monday");
                break;
            }
            case 3: {
                sDay = res.getString("Tuesday");
                break;
            }
            case 4: {
                sDay = res.getString("Wedensday");
                break;
            }
            case 5: {
                sDay = res.getString("Thursday");
                break;
            }
            case 6: {
                sDay = res.getString("Friday");
                break;
            }
            case 7: {
                sDay = res.getString("Saturday");
                break;
            }
            default: {
                sDay = res.getString("Wrong_Day_data");
            }
        }
        return sDay;
    }

    private static int dayOfWeek(int nDay) {
        switch (nDay) {
            case 0: {
                return 7;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        return 2;
    }

    private static String WkDescX(int nWk) {
        String sWk = null;
        switch (nWk) {
            case 0: {
                sWk = res.getString("First");
                break;
            }
            case 1: {
                sWk = res.getString("Second");
                break;
            }
            case 2: {
                sWk = res.getString("Third");
                break;
            }
            case 3: {
                sWk = res.getString("Fourth");
                break;
            }
            case 4: {
                sWk = res.getString("Last");
                break;
            }
            default: {
                sWk = res.getString("Wrong_Week_data");
            }
        }
        return sWk;
    }

    private static String MthDescX(int nMth) {
        String sMth = null;
        switch (nMth) {
            case 0: {
                sMth = res.getString("January");
                break;
            }
            case 1: {
                sMth = res.getString("Febuary");
                break;
            }
            case 2: {
                sMth = res.getString("March");
                break;
            }
            case 3: {
                sMth = res.getString("April");
                break;
            }
            case 4: {
                sMth = res.getString("May");
                break;
            }
            case 5: {
                sMth = res.getString("June");
                break;
            }
            case 6: {
                sMth = res.getString("July");
                break;
            }
            case 7: {
                sMth = res.getString("August");
                break;
            }
            case 8: {
                sMth = res.getString("September");
                break;
            }
            case 9: {
                sMth = res.getString("October");
                break;
            }
            case 10: {
                sMth = res.getString("November");
                break;
            }
            case 11: {
                sMth = res.getString("December");
                break;
            }
            default: {
                sMth = res.getString("Wrong_Month_data");
            }
        }
        return sMth;
    }
}

