/*
 * Decompiled with CFR 0.152.
 */
package jpos.browser;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JFrame;
import jpos.SP;
import jpos.browser.BrowserControl;

public class BrowserFrame
extends JFrame
implements AutoCloseable {
    private String url;
    private BrowserControl browserControl;

    public BrowserFrame(String titleKey) {
        super(SP.getRS(titleKey));
        this.setPosIcon();
        this.browserControl = new BrowserControl();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.browserControl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setToScreenSize();
        this.browserControl.initialiseSplitterPosition(this.getHeight());
        this.browserControl.requestViewFocus();
    }

    private void setToScreenSize() {
        try {
            Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            this.setBounds(screenSize);
        }
        catch (Exception e) {
            this.setBounds(0, 0, 1024, 768);
        }
    }

    private void setPosIcon() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ArrayList<Image> list = new ArrayList<Image>();
        list.add(tk.getImage(SP.sParams.imagepath + "ap21_pos_16x16.png"));
        list.add(tk.getImage(SP.sParams.imagepath + "ap21_pos_32x32.png"));
        this.setIconImages(list);
    }

    public void setUrl(String url) {
        this.url = url;
        this.refresh();
    }

    public void refresh() {
        this.browserControl.loadURL(this.url);
    }

    @Override
    public void close() throws Exception {
        this.browserControl.disposeBrowserObjects();
    }
}

