/*
 * Decompiled with CFR 0.152.
 */
package jpos.capillary;

import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import jpos.StyleLine;
import jpos.User;
import jpos.capillary.CapillaryAPI;
import jpos.capillary.CapillaryTransaction;
import jpos.logging.RollingLog;
import jpos.rewards.IRewardsApiManager;
import jpos.rewards.RewardsAccount;

public class CapillaryApiManager
implements IRewardsApiManager {
    private CapillaryTransaction dataTransaction;
    private CapillaryAPI api;
    private RedemptionState state = RedemptionState.UNUSED;

    public CapillaryApiManager() {
        this.api = new CapillaryAPI();
        this.logServerInfo();
        this.dataTransaction = new CapillaryTransaction();
        this.reverseAllIncompleteRedemptions();
    }

    private void logServerInfo() {
        RollingLog.log(RollingLog.LogType.CAPILLARY, Level.CONFIG, String.format("Capillary Connecting Server %s", this.api.getBaseURL()));
        RollingLog.log(RollingLog.LogType.CAPILLARY, Level.CONFIG, String.format("Capillary Connecting User %s", this.api.getUsername()));
    }

    @Override
    public boolean requestBalance(String cardNo, long peridx) {
        return false;
    }

    @Override
    public boolean hasUncommittedRedemption() {
        return this.state == RedemptionState.REDEEMED;
    }

    @Override
    public boolean hasRequestedRedemption() {
        return this.state == RedemptionState.REQUESTED;
    }

    @Override
    public void setCardNo(String cardNo) {
        this.dataTransaction.setCardNumber(cardNo);
    }

    @Override
    public void setPerIdx(long perIdx) {
    }

    @Override
    public void setRequestAmount(double amount) {
        this.dataTransaction.setAmount(amount);
        RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("Requested redemption of %s from loyalty card %s", amount, this.dataTransaction.getCardNumber()));
        this.state = amount > 0.0 ? RedemptionState.REQUESTED : RedemptionState.UNUSED;
    }

    public void setRequestPoints(double points) {
        this.dataTransaction.setPoints(points);
        RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("Requested redemption amount equals %s points", points));
        this.state = points > 0.0 ? RedemptionState.REQUESTED : RedemptionState.UNUSED;
    }

    public void setRequestPointsBalance(double points) {
        this.dataTransaction.setPointsBalance(points);
        RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("Requested redemption amount equals %s points", points));
        this.state = points > 0.0 ? RedemptionState.REQUESTED : RedemptionState.UNUSED;
    }

    @Override
    public void setRequestGifts(Vector<StyleLine> gifts) {
    }

    @Override
    public double getBalance() {
        return 0.0;
    }

    @Override
    public String getLastError() {
        return this.api.getLastError();
    }

    @Override
    public boolean redeem(User user) {
        if (this.state == RedemptionState.REDEEMED) {
            return true;
        }
        if (this.dataTransaction != null && this.state == RedemptionState.REQUESTED) {
            if (this.api.requestRedeem(this.dataTransaction.getCardNumber(), user.getMemidx(), this.dataTransaction.getPoints())) {
                String capillaryTransactionId = this.api.getRedemptionId();
                this.dataTransaction.saveRedemption(capillaryTransactionId, user.getMemidx());
                this.state = RedemptionState.REDEEMED;
                RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("successfully redeemed %s (%s points) from card %s", this.dataTransaction.getAmount(), this.dataTransaction.getPoints(), this.dataTransaction.getCardNumber()));
                return true;
            }
            RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("Failed to redeem %s (%s points) from card %s\nError: %s", this.dataTransaction.getAmount(), this.dataTransaction.getPoints(), this.dataTransaction.getCardNumber(), this.api.getLastError()));
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseTransaction() {
        if (this.dataTransaction != null && this.state == RedemptionState.REDEEMED) {
            if (this.api.requestReverse(this.dataTransaction.getCardNumber(), this.dataTransaction.getCapillaryRedeemId())) {
                this.dataTransaction.reverseRedemption();
                this.state = RedemptionState.CANCELED;
                RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("successfully reversed %s (%s points) from card %s, redemption id %s", this.dataTransaction.getAmount(), this.dataTransaction.getPoints(), this.dataTransaction.getCardNumber(), this.dataTransaction.getCapillaryRedeemId()));
                return true;
            }
            this.dataTransaction.logFailedReversal();
            RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("Failed to reverse %s (%s points) from card %s , redemption id %s\nError: %s", this.dataTransaction.getAmount(), this.dataTransaction.getPoints(), this.dataTransaction.getCardNumber(), this.dataTransaction.getCapillaryRedeemId(), this.api.getLastError()));
            return false;
        }
        return false;
    }

    @Override
    public boolean commitTransaction(long vhidx) {
        if (this.dataTransaction != null && this.state == RedemptionState.REDEEMED && this.dataTransaction.finishRedemption(vhidx)) {
            this.state = RedemptionState.COMPLETED;
            RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("Completed transaction vhidx %s ", vhidx));
            return true;
        }
        return false;
    }

    @Override
    public void reverseAllIncompleteRedemptions() {
        ArrayList<CapillaryTransaction> list = CapillaryTransaction.getAllTransactionsToReverse();
        for (CapillaryTransaction cap : list) {
            if (this.api.requestReverse(cap.getCardNumber(), cap.getCapillaryRedeemId())) {
                cap.reverseRedemption();
                RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("successfully reversed %s (%s points) from card %s, redemption id %s", cap.getAmount(), cap.getPoints(), cap.getCardNumber(), cap.getCapillaryRedeemId()));
                continue;
            }
            cap.logFailedReversal();
            RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("Failed to reverse %s (%s points) from card %s, redemption id %s\nError: %s", cap.getAmount(), cap.getPoints(), cap.getCardNumber(), cap.getCapillaryRedeemId(), this.api.getLastError()));
        }
    }

    @Override
    public boolean loadAccount(long peridx) {
        return false;
    }

    @Override
    public long getAccountId() {
        return 0L;
    }

    @Override
    public boolean signUp(long peridx, long programId, User user) {
        return false;
    }

    @Override
    public RewardsAccount getAccount() {
        return null;
    }

    @Override
    public double getTierMinimumSpend() {
        return 0.0;
    }

    private static enum RedemptionState {
        UNUSED,
        REQUESTED,
        REDEEMED,
        CANCELED,
        COMPLETED;

    }
}

