/*
 * Decompiled with CFR 0.152.
 */
package jpos.coupons;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jpos.FrSales;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.SP;
import jpos.XMLUtils;
import jpos.coupons.Coupon;
import jpos.coupons.CouponManager;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchList;
import jpos.ui.TouchTextField;

public class DlgApplyCoupon
extends PosDialog {
    private LabelSubHeading lCouponCode = new LabelSubHeading();
    private TouchTextField tfCouponCode = new TouchTextField();
    private TouchList<String> couponsList = new TouchList();
    private PosScrollPane couponSP;
    private DialogButton bOk = new DialogButton("", this);
    private DialogButton bCancel = new DialogButton("", this);
    private boolean accepted = false;
    private CouponManager couponManager = new CouponManager();
    private Vector<String> couponDetails;
    private Vector<Coupon> availableCoupons;

    public DlgApplyCoupon(PosFrame frame, String defaultCode) {
        super(frame, SP.getRS("Coupons_DlgApplyCoupon_Title"), true);
        this.jbInit(defaultCode);
    }

    public boolean getAccepted() {
        return this.accepted;
    }

    public String getCode() {
        return this.tfCouponCode.getText();
    }

    private void jbInit(String defaultCode) {
        JPanel main = new JPanel(new GridBagLayout());
        this.couponsList.setFixedCellHeight(70);
        this.couponSP = new PosScrollPane(this.couponsList);
        this.couponSP.setPreferredSize(new Dimension(350, 300));
        this.couponSP.setMinimumSize(new Dimension(350, 200));
        this.lCouponCode.setText(SP.getRS("Coupons_DlgApplyCoupon_Prompt"));
        this.tfCouponCode.setFieldWidth(350);
        this.bOk.setText(SP.getRS("OK"));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgApplyCoupon.this.accepted = true;
                DlgApplyCoupon.this.dispose();
            }
        });
        this.bCancel.setText(SP.getRS("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgApplyCoupon.this.dispose();
            }
        });
        this.couponsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DlgApplyCoupon.this.setSelectedCouponToRedeem();
            }
        });
        main.add((Component)this.lCouponCode, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 0, 10), 0, 0));
        main.add((Component)this.tfCouponCode, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 0, 10), 0, 0));
        main.add((Component)this.couponSP, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 10), 0, 0));
        main.add((Component)this.bOk, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 5), 0, 0));
        main.add((Component)this.bCancel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 5, 10, 10), 0, 0));
        this.getContentPane().add(main);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfCouponCode);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        FrSales salesFr = (FrSales)this.frParent;
        if (XMLUtils.getLongValue(salesFr.getPerson(), "peridx") != 0L && this.couponManager.requestGetCoupons(XMLUtils.getLongValue(salesFr.getPerson(), "peridx"))) {
            this.availableCoupons = this.couponManager.getCoupons();
            this.setCouponDetails();
            this.couponsList.setListData(this.couponDetails);
            this.couponsList.setSelectedIndex(0);
            this.setSelectedCouponToRedeem();
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        if (!defaultCode.isEmpty()) {
            this.tfCouponCode.setText(defaultCode);
        }
    }

    @Override
    public void okDialog() {
        this.bOk.doClick();
    }

    @Override
    public void cancelDialog() {
        this.bCancel.doClick();
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    private void setCouponDetails() {
        this.couponDetails = new Vector(this.availableCoupons.size());
        for (int i = 0; i < this.availableCoupons.size(); ++i) {
            this.couponDetails.add(this.availableCoupons.get(i).getCouponDetails());
        }
    }

    private void setSelectedCouponToRedeem() {
        int i;
        if (this.couponDetails != null && this.couponDetails.size() > 0 && (i = this.couponsList.getSelectedIndex()) >= 0 && i < this.availableCoupons.size()) {
            this.tfCouponCode.setText(this.availableCoupons.get(i).getCode());
        }
    }
}

