/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import com.google.gson.Gson;
import com.teamdev.jxbrowser.js.JsAccessible;
import com.teamdev.jxbrowser.js.JsObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.browser.BrowserUtils;
import jpos.custorder.DeliveryInfo;
import jpos.custorder.DeliveryMethod;
import jpos.custorder.DeliveryMethods;
import jpos.kleber.KleberApiException;
import jpos.kleber.KleberModels;
import jpos.kleber.KleberUtils;
import jpos.person.Country;
import jpos.person.DlgPickAddress;
import jpos.person.Location;

public class DeliveryInfoInterface {
    private ArrayList<ListValue> countries = new ArrayList();
    private ArrayList<ListValue> deliveryMethods = new ArrayList();
    private KleberUtils kleberUtils;
    private DeliveryInfo deliveryInfo;
    private List<Country> countryList;
    private DeliveryMethods methods;
    private PosDialog parent;
    @JsAccessible
    public DeliveryInfoContext context;

    public DeliveryInfoInterface(PosDialog parent, DeliveryInfo deliveryInfo, String heading, KleberUtils kleberUtils) {
        this.parent = parent;
        this.deliveryInfo = deliveryInfo;
        this.context = new DeliveryInfoContext(deliveryInfo, heading);
        this.kleberUtils = kleberUtils;
        this.countryList = Country.getCountryList();
        for (Country country : this.countryList) {
            if (StringUtils.isNullOrEmpty(country.getName())) continue;
            this.countries.add(new ListValue(country.getCode(), country.getName(), null));
        }
        this.methods = new DeliveryMethods();
        for (int index = 0; index < this.methods.size(); ++index) {
            this.deliveryMethods.add(new ListValue(Long.toString(((DeliveryMethod)this.methods.get(index)).getId()), ((DeliveryMethod)this.methods.get(index)).getName(), null));
        }
    }

    @JsAccessible
    public String loadImage(String imageName) {
        File file = new File(SP.sParams.imagepath + imageName);
        byte[] bytes = new byte[(int)file.length()];
        try (FileInputStream fileInputStreamReader = new FileInputStream(file);){
            fileInputStreamReader.read(bytes);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    @JsAccessible
    public String getCitiesJSON(String countryName) {
        Gson gson = new Gson();
        String json = gson.toJson(Location.getLocationList(countryName));
        return json;
    }

    @JsAccessible
    public String getCountriesJSON() {
        Gson gson = new Gson();
        String json = gson.toJson(this.countries);
        return json;
    }

    @JsAccessible
    public String getDeliveryMethodsJSON() {
        Gson gson = new Gson();
        String json = gson.toJson(this.deliveryMethods);
        return json;
    }

    @JsAccessible
    public boolean save(JsObject info) {
        final JSAddress address = new JSAddress(info);
        if (!address.fromKleber && this.hasAddressChanged(address) && this.kleberUtils.AddressValidationEnabledForCountry(address.country.getCode()) && !address.addressLine1.trim().isEmpty() && !address.city.trim().isEmpty()) {
            ResultRunnable<Boolean> runnable = new ResultRunnable<Boolean>(){

                @Override
                public Boolean execute() {
                    return DeliveryInfoInterface.this.verifyAddress(address);
                }
            };
            try {
                this.invokeOnEventDispatchThread(runnable);
                if (!((Boolean)runnable.getResult()).booleanValue()) {
                    return false;
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        this.deliveryInfo.setAddressLine1(address.addressLine1);
        this.deliveryInfo.setAddressLine2(address.addressLine2);
        this.deliveryInfo.setCity(address.city);
        this.deliveryInfo.setState(address.state);
        this.deliveryInfo.setPostcode(address.postcode);
        this.deliveryInfo.setCountry(address.country);
        this.deliveryInfo.setContactName(BrowserUtils.getJsStringProperty(info, "name"));
        this.deliveryInfo.setCompany(BrowserUtils.getJsStringProperty(info, "company"));
        this.deliveryInfo.setPhone(BrowserUtils.getJsStringProperty(info, "phone"));
        this.deliveryInfo.setEmail(BrowserUtils.getJsStringProperty(info, "email"));
        this.deliveryInfo.setDeliveryInstructions(BrowserUtils.getJsStringProperty(info, "deliveryInstructions"));
        DeliveryMethod method = this.methods.stream().filter(x -> Long.toString(x.getId()).equalsIgnoreCase(BrowserUtils.getJsStringProperty(info, "deliveryMethod"))).findFirst().get();
        this.deliveryInfo.setDeliveryMethod(method);
        this.deliveryInfo.setUserEdited(true);
        this.parent.okDialog();
        return true;
    }

    @JsAccessible
    public void exit() {
        this.parent.cancelDialog();
    }

    private boolean hasAddressChanged(JSAddress address) {
        if (!address.addressLine1.equalsIgnoreCase(this.deliveryInfo.getAddressLine1() != null ? this.deliveryInfo.getAddressLine1().trim() : "")) {
            return true;
        }
        if (!address.addressLine2.equalsIgnoreCase(this.deliveryInfo.getAddressLine2() != null ? this.deliveryInfo.getAddressLine2().trim() : "")) {
            return true;
        }
        if (!address.city.equalsIgnoreCase(this.deliveryInfo.getCity() != null ? this.deliveryInfo.getCity().trim() : "")) {
            return true;
        }
        if (!address.state.equalsIgnoreCase(this.deliveryInfo.getState() != null ? this.deliveryInfo.getState().trim() : "")) {
            return true;
        }
        if (!address.postcode.equalsIgnoreCase(this.deliveryInfo.getPostcode() != null ? this.deliveryInfo.getPostcode().trim() : "")) {
            return true;
        }
        return !address.country.getName().equalsIgnoreCase(this.deliveryInfo.getCountry().getName() != null ? this.deliveryInfo.getCountry().getName().trim() : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifyAddress(JSAddress address) {
        try {
            KleberModels.DtResponse.Address req = new KleberModels.DtResponse.Address();
            req.AddressLine1 = address.addressLine1;
            req.AddressLine2 = address.addressLine2;
            req.City = address.city;
            req.State = address.state;
            req.Postcode = address.postcode;
            req.Country = address.country.getCode();
            KleberModels.KleberResponse<KleberModels.DtResponse.AddressVerifyResult> response = this.kleberUtils.VerifyAddress(req, req.Country);
            if (response.DtResponse.ResultCount <= 0) return false;
            KleberModels.DtResponse.AddressVerifyResult result = (KleberModels.DtResponse.AddressVerifyResult)response.DtResponse.Result.get(0);
            switch (result.MatchType) {
                case Correct: {
                    if (!result.addressChanged) return true;
                    KleberModels.DtResponse.Address newAddress = new KleberModels.DtResponse.Address();
                    newAddress.AddressLine1 = result.AddressLine1;
                    newAddress.AddressLine2 = result.AddressLine2;
                    newAddress.City = result.City;
                    newAddress.State = result.State;
                    newAddress.Postcode = result.Postcode;
                    newAddress.Country = result.Country;
                    if (newAddress.AddressLine1.trim().equalsIgnoreCase(req.AddressLine1.trim()) && newAddress.AddressLine2.trim().equalsIgnoreCase(req.AddressLine2.trim()) && newAddress.City.trim().equalsIgnoreCase(req.City.trim()) && newAddress.State.trim().equalsIgnoreCase(req.State.trim()) && newAddress.Postcode.trim().equalsIgnoreCase(req.Postcode.trim())) {
                        address.addressLine1 = newAddress.AddressLine1;
                        address.addressLine2 = newAddress.AddressLine2;
                        address.city = newAddress.City;
                        address.state = newAddress.State;
                        address.postcode = newAddress.Postcode;
                        return true;
                    }
                    DlgPickAddress dlg = new DlgPickAddress(this.parent.frParent, (JDialog)this.parent, newAddress, req);
                    try {
                        switch (dlg.getResult()) {
                            case CANCEL: {
                                boolean bl = false;
                                return bl;
                            }
                            case OLD: {
                                boolean bl = true;
                                return bl;
                            }
                            case NEW: {
                                address.addressLine1 = newAddress.AddressLine1;
                                address.addressLine2 = newAddress.AddressLine2;
                                address.city = newAddress.City;
                                address.state = newAddress.State;
                                address.postcode = newAddress.Postcode;
                                boolean bl = true;
                                return bl;
                            }
                        }
                        return true;
                    }
                    finally {
                        dlg.dispose();
                        dlg = null;
                    }
                }
                case PhantomPrimaryPoint: {
                    if (DlgMessage.showMessage(this.parent.frParent, SP.getRS("Phantom_Primary_Point"), StoreParams.res.getString("Address_Validation"), 0, 3) == 0) return false;
                    return true;
                }
            }
            if (DlgMessage.showMessage(this.parent.frParent, SP.getRS("Could_Not_Verify_Address"), StoreParams.res.getString("Address_Validation"), 0, 3) != 0) return false;
            return true;
        }
        catch (KleberApiException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                if (DlgMessage.showMessage(this.parent.frParent, StoreParams.res.getString("Kleber_Address_Verify_Failure"), StoreParams.res.getString("Kleber_Timeout"), 0, 3) != 0) return false;
                return true;
            }
            if (e.getCause() instanceof UnknownHostException) {
                if (DlgMessage.showMessage(this.parent.frParent, StoreParams.res.getString("Kleber_Address_Verify_Failure"), StoreParams.res.getString("Kleber_Connection_Failed"), 0, 3) != 0) return false;
                return true;
            }
            PosUtils.logError(e);
        }
        return false;
    }

    private void invokeOnEventDispatchThread(Runnable runnable) throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeLater(() -> this.parent.setCursor(StoreParams.waitCursor));
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                runnable.run();
            }
        }
        finally {
            SwingUtilities.invokeLater(() -> this.parent.setCursor(StoreParams.normalCursor));
        }
    }

    public class LocationDetails {
        private String city;
        private String state;
        private String postcode;

        public LocationDetails(String city, String state, String postcode) {
            this.city = city;
            this.state = state;
            this.postcode = postcode;
        }

        @JsAccessible
        public String getCity() {
            return this.city;
        }

        @JsAccessible
        public String getState() {
            return this.state;
        }

        @JsAccessible
        public String getPostcode() {
            return this.postcode;
        }
    }

    public class ListValue {
        private String id;
        private String value;
        private String displayValue;

        public ListValue(String id, String value, String displayValue) {
            this.id = StringUtils.nullToEmpty(id);
            this.value = StringUtils.nullToEmpty(value);
            this.displayValue = StringUtils.nullToEmpty(displayValue);
        }

        @JsAccessible
        public String getId() {
            return this.id;
        }

        @JsAccessible
        public String getValue() {
            return this.value;
        }

        @JsAccessible
        public String getDisplayValue() {
            return this.displayValue.isEmpty() ? this.value : this.displayValue;
        }
    }

    private abstract class ResultRunnable<T>
    implements Runnable {
        private T result;

        private ResultRunnable() {
        }

        public abstract T execute();

        @Override
        public void run() {
            this.result = this.execute();
        }

        public T getResult() {
            return this.result;
        }
    }

    private class JSAddress {
        String addressLine1;
        String addressLine2;
        String city;
        String state;
        String postcode;
        boolean fromKleber;
        Country country = new Country();

        public JSAddress(JsObject deliveryInfo) {
            this.addressLine1 = deliveryInfo.property("addressLine1").orElse("").trim();
            this.addressLine2 = deliveryInfo.property("addressLine2").orElse("").trim();
            this.city = deliveryInfo.property("city").orElse("").trim();
            this.state = deliveryInfo.property("state").orElse("").trim();
            this.postcode = deliveryInfo.property("postcode").orElse("").trim();
            Optional<Country> opt = DeliveryInfoInterface.this.countryList.stream().filter(x -> x.getName().equalsIgnoreCase(deliveryInfo.property("country").orElse("").trim())).findFirst();
            if (opt.isPresent()) {
                this.country = opt.get();
            }
            this.fromKleber = deliveryInfo.property("fromKleber").orElse(false);
        }
    }

    @JsAccessible
    public class DeliveryInfoContext {
        public String name;
        public String company;
        public String addressLine1;
        public String addressLine2;
        public String city;
        public String state;
        public String postcode;
        public String country;
        public String phone;
        public String email;
        public String deliveryInstructions;
        public String heading;
        public String deliveryMethod;
        public long unattendedDeliveryOption;
        public boolean enforcePhoneValidation;

        public DeliveryInfoContext(DeliveryInfo deliveryInfo, String heading) {
            this.name = deliveryInfo.getContactName();
            this.company = deliveryInfo.getCompany();
            this.addressLine1 = deliveryInfo.getAddressLine1();
            this.addressLine2 = deliveryInfo.getAddressLine2();
            this.city = deliveryInfo.getCity();
            this.state = deliveryInfo.getState();
            this.postcode = deliveryInfo.getPostcode();
            this.country = deliveryInfo.getCountry().toString();
            if (this.country.isEmpty()) {
                this.country = Settings.getCountry().getName();
            }
            this.phone = deliveryInfo.getPhone();
            this.email = deliveryInfo.getEmail();
            this.deliveryInstructions = deliveryInfo.getDeliveryInstructions();
            DeliveryMethod method = deliveryInfo.getDeliveryMethod();
            if (method != null) {
                this.deliveryMethod = Long.toString(deliveryInfo.getDeliveryMethod().getId());
            }
            this.unattendedDeliveryOption = deliveryInfo.getUnattendedDeliveryOption();
            this.heading = heading;
            this.enforcePhoneValidation = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ENFORCE_PHONE_NUM_VALIDATION);
        }
    }
}

