/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.auspost;

import java.sql.SQLException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.custorder.auspost.ShipmentLine;

public class ShipmentTableModel
extends AbstractTableModel {
    public static final int SHIPID_COLUMN = 0;
    public static final int CARRIERIDX_COLUMN = 1;
    public static final int FREIGHTOPTION_COLUMN = 2;
    public static final int CORDER_COLUMN = 3;
    public static final int CONNOTE_COLUMN = 4;
    public static final int CARRIER_NAME_COLUMN = 5;
    public static final int SHIPMENT_DATE_COLUMN = 6;
    public static final int MANIFEST_COLUMN = 7;
    private static final int COL_COUNT = 8;
    private static final String SHIPMENT_ID_HEADING = "";
    private static final String CARRIERIDX_HEADING = "";
    private static final String CORDER_HEADING = SP.getRS("Corder_Header");
    private static final String CONNOTE_HEADING = SP.getRS("Connote_Header");
    private static final String SHIPMENT_DATE_HEADING = SP.getRS("Shipdate_Header");
    private static final String CARRIER_NAME_HEADING = SP.getRS("Carrier_Name_Header");
    private static final String MANIFEST_HEADING = "";
    private Vector<ShipmentLine> data = new Vector();

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 2: {
                return false;
            }
            case 1: {
                return false;
            }
            case 4: {
                return false;
            }
            case 3: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.data.size() || row < 0) {
            return "";
        }
        switch (col) {
            case 0: {
                return this.data.elementAt(row).getShipmentId();
            }
            case 1: {
                return this.data.elementAt(row).getCarrierIdx();
            }
            case 2: {
                return this.data.elementAt(row).getFreightOptionIdx();
            }
            case 4: {
                return this.data.elementAt(row).getConnoteNumber();
            }
            case 3: {
                return this.data.elementAt(row).getCorderNumber();
            }
            case 5: {
                return this.data.elementAt(row).getCarrierName();
            }
            case 6: {
                return this.data.elementAt(row).getShipmentDate();
            }
            case 7: {
                return this.data.elementAt(row).isManifested();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row >= this.data.size() || row < 0 || value == null) {
            return;
        }
        switch (col) {
            case 7: {
                this.data.get(row).setIsManifested((Boolean)value);
                this.fireTableCellUpdated(row, col);
                break;
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "";
            }
            case 1: {
                return "";
            }
            case 4: {
                return CONNOTE_HEADING;
            }
            case 3: {
                return CORDER_HEADING;
            }
            case 6: {
                return SHIPMENT_DATE_HEADING;
            }
            case 5: {
                return CARRIER_NAME_HEADING;
            }
            case 7: {
                return "";
            }
        }
        return "";
    }

    public void populate() {
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT * FROM AUSPOST_MANIFEST WHERE MANIFESTED = 0 ORDER BY SHIPMENT_DATE DESC");){
            while (qry.next()) {
                ShipmentLine line = new ShipmentLine();
                line.setShipmentId(qry.getString("shipment_id"));
                line.setCarrierIdx(qry.getString("carrierIdx"));
                line.setConnoteNumber(qry.getString("connote"));
                line.setFreightOptionIdx(qry.getString("freight_option"));
                line.setCorderNumber(qry.getString("corder_num"));
                line.setShipmentDate(qry.getString("shipment_date"));
                line.setCarrierName(qry.getString("carrier_name"));
                this.data.add(line);
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public void selectAll() {
        boolean hasChanged = false;
        for (ShipmentLine line : this.data) {
            if (line.isManifested()) continue;
            line.setIsManifested(true);
            hasChanged = true;
        }
        if (hasChanged) {
            this.fireTableDataChanged();
        }
    }

    public void unselectAll() {
        boolean hasChanged = false;
        for (ShipmentLine line : this.data) {
            if (!line.isManifested()) continue;
            line.setIsManifested(false);
            hasChanged = true;
        }
        if (hasChanged) {
            this.fireTableDataChanged();
        }
    }
}

