/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.outstanding;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import jpos.PosDateFormatter;
import jpos.SP;
import jpos.StringUtils;
import jpos.Urgency;
import jpos.XMLUtils;
import jpos.custorder.ServiceLevelAgreement;
import jpos.custorder.outstanding.OrderStatus;
import jpos.custorder.outstanding.OrderType;
import jpos.custorder.outstanding.TranType;
import org.jdom.Element;

public class CustomerOrder {
    public static final String NOT_APPLICABLE = SP.getRS("not_applicable");
    public static final String DUE_IN = SP.getRS("CustOrder_Due_In");
    public static final String OVERDUE_FOR = SP.getRS("CustOrder_Overdue_For");
    public static final String OPEN_FOR = SP.getRS("CustOrder_Open_For");
    public static final String DAY_FORMAT = SP.getRS("Day_Format");
    public static final String DAYS_FORMAT = SP.getRS("Days_Format");
    public static final String HOUR_FORMAT = SP.getRS("Hour_Format");
    public static final String HOURS_FORMAT = SP.getRS("Hours_Format");
    public static final String MINUTE_FORMAT = SP.getRS("Minute_Format");
    public static final String MINUTES_FORMAT = SP.getRS("Minutes_Format");
    public static final int MAX_DISPLAY_UNITS = 2;
    public static final int DAYS_ROUND_THRESHOLD = 2;
    public static final int HOURS_ROUND_THRESHOLD = 10;
    public static final int MINUTES_PER_DAY = 1440;
    public static final int MINUTES_PER_HOUR = 60;
    private static final DateTimeFormatter INSTANT_CREATOR = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneOffset.UTC);
    private PosDateFormatter dateFormatter;
    private PosDateFormatter dateOnlyFormatter;
    private long vhIdx;
    private OrderType orderType;
    private OrderStatus orderStatus;
    private String transNum;
    private String custOrderNum;
    private String docketNum;
    private Instant orderDate;
    private String orderDateString = null;
    private String customer;
    private String phone;
    private String mobile;
    private String email;
    private String address;
    private String carrier;
    private String serviceType;
    private String sla;
    private boolean priority;
    private long outstPackQty;
    private long totalOutstQty;
    private boolean onHold;
    private LocalDate expectedDeliveryDate;
    private LocalDate despatchCutoffDate;
    private ServiceLevelAgreement serviceLevelAgreement = null;
    private TranType tranType;
    private long originStoreIdx;
    private String thirdPartyCouponCode;
    private String thirdPartyCouponSource;
    private Instant warningDate;
    private Instant criticalDate;
    private Instant dueDate;
    private String remainingString = "";
    private Instant refreshRemainingTime = Instant.now().minus(1L, ChronoUnit.MINUTES);
    private Urgency urgency = Urgency.NONE;
    private String queryString;

    public CustomerOrder(Element order, PosDateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter != null ? dateFormatter : new PosDateFormatter(null, 3, 3, 2);
        this.dateOnlyFormatter = new PosDateFormatter(null, 3, 3, 0);
        this.vhIdx = XMLUtils.getLongValue(order, "vhidx");
        this.orderType = XMLUtils.getLongValue(order, "despatch_type") == 2L ? OrderType.StoreDespatch : OrderType.CustomerPickup;
        this.tranType = TranType.values()[(int)XMLUtils.getLongValue(order, "trantype")];
        this.originStoreIdx = XMLUtils.getLongValue(order, "origin_storeidx");
        if (this.originStoreIdx == SP.sParams.getStoreIdx() && this.orderType == OrderType.StoreDespatch && this.tranType == TranType.FloorToDoor) {
            this.orderType = OrderType.CurrentStoreDespatch;
        }
        this.transNum = XMLUtils.getValue(order, "trans_num");
        this.custOrderNum = XMLUtils.getValue(order, "order_num");
        String docket = XMLUtils.getValue(order, "docket_num");
        if (!docket.isEmpty()) {
            docket = MessageFormat.format("D{0}{1}", SP.sParams.getStore().getStoreNo(), docket);
        }
        this.docketNum = docket;
        this.customer = XMLUtils.getValue(order, "customer");
        this.phone = XMLUtils.getValue(order, "phone");
        this.mobile = XMLUtils.getValue(order, "mobile");
        this.email = XMLUtils.getValue(order, "email");
        this.address = this.orderType == OrderType.StoreDespatch || this.orderType == OrderType.CurrentStoreDespatch ? CustomerOrder.generateAddress(XMLUtils.getValue(order, "company"), XMLUtils.getValue(order, "address1"), XMLUtils.getValue(order, "address2"), XMLUtils.getValue(order, "city"), XMLUtils.getValue(order, "state"), XMLUtils.getValue(order, "postcode"), XMLUtils.getValue(order, "country")) : "";
        this.carrier = XMLUtils.getValue(order, "carrier");
        this.serviceType = XMLUtils.getValue(order, "service_type");
        this.sla = XMLUtils.getValue(order, "sla");
        this.priority = XMLUtils.getLongValue(order, "priority_flag") == 1L;
        this.outstPackQty = XMLUtils.getLongValue(order, "outst_pack_qty");
        this.totalOutstQty = XMLUtils.getLongValue(order, "total_outst_qty");
        this.onHold = XMLUtils.getLongValue(order, "on_hold") == 1L;
        this.orderStatus = CustomerOrder.getStatus(this.orderType, this.outstPackQty);
        this.orderDate = CustomerOrder.getInstant(XMLUtils.getValue(order, "order_utc_date"));
        this.warningDate = CustomerOrder.getInstant(XMLUtils.getValue(order, "warning_utc_date"));
        this.criticalDate = CustomerOrder.getInstant(XMLUtils.getValue(order, "critical_utc_date"));
        this.dueDate = CustomerOrder.getInstant(XMLUtils.getValue(order, "due_utc_date"));
        this.expectedDeliveryDate = XMLUtils.getDate(order, "expected_delivery_date");
        if (XMLUtils.getLongValue(order, "sla_idx") > 0L) {
            this.serviceLevelAgreement = new ServiceLevelAgreement(XMLUtils.getLongValue(order, "sla_idx"));
            this.despatchCutoffDate = this.serviceLevelAgreement.getDespatchCutoffDate(this.expectedDeliveryDate);
        }
        this.refreshQueryString();
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public String getOrderTypeString() {
        return this.orderType != null ? this.orderType.getName() : "";
    }

    public OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public String getOrderStatusString() {
        String ret;
        String string = ret = this.orderStatus != null ? this.orderStatus.getName() : "";
        if (this.onHold) {
            ret = ret + " - " + SP.getRS("Order_On_Hold");
        }
        return ret;
    }

    public boolean getOnHold() {
        return this.onHold;
    }

    public String getTransNum() {
        return this.transNum;
    }

    public String getCustOrderNum() {
        return this.custOrderNum;
    }

    public String getDocketNum() {
        return this.docketNum;
    }

    public Instant getOrderDate() {
        return this.orderDate;
    }

    public String getOrderDateString() {
        if (this.orderDate == null) {
            return "";
        }
        if (this.orderDateString == null) {
            this.dateFormatter.setTimestamp(Timestamp.from(this.orderDate));
            this.orderDateString = this.dateFormatter.toString();
        }
        return this.orderDateString;
    }

    public String getCustomer() {
        return this.customer;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getSLA() {
        return this.sla;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public long getQtyToPack() {
        return this.outstPackQty;
    }

    public long getTotalOutstandingQty() {
        return this.totalOutstQty;
    }

    public Instant getWarningDate() {
        return this.warningDate;
    }

    public Instant getCriticalDate() {
        return this.criticalDate;
    }

    public Instant getDueDate() {
        return this.dueDate;
    }

    public LocalDate getExpectedDeliveryDate() {
        return this.expectedDeliveryDate;
    }

    public String getExpectedDeliveryDateString() {
        if (this.expectedDeliveryDate == null) {
            return "";
        }
        this.dateOnlyFormatter.setTimestamp(Timestamp.valueOf(this.expectedDeliveryDate.atStartOfDay()));
        return this.dateOnlyFormatter.toString();
    }

    public Duration getRemainingTime() {
        if (this.dueDate == null) {
            return null;
        }
        return Duration.between(Instant.now(), this.dueDate);
    }

    public Duration getOutstandingTime() {
        if (this.orderDate == null) {
            return null;
        }
        return Duration.between(Instant.now(), this.orderDate);
    }

    public String getTimerString() {
        this.refreshTimerIfRequired();
        return this.remainingString;
    }

    public Urgency getUrgency() {
        this.refreshTimerIfRequired();
        return this.urgency;
    }

    private void refreshTimerIfRequired() {
        Instant now = Instant.now();
        if (now.isAfter(this.refreshRemainingTime)) {
            this.refreshRemainingTime = now.plus(1L, ChronoUnit.MINUTES);
            this.refreshUrgency(now, this.refreshRemainingTime());
        }
    }

    private Duration refreshRemainingTime() {
        if (this.outstPackQty > 0L && this.dueDate != null) {
            Duration remainingTime = this.getRemainingTime();
            this.remainingString = remainingTime != null ? (remainingTime.isNegative() ? MessageFormat.format(OVERDUE_FOR, CustomerOrder.getDurationString(remainingTime)) : MessageFormat.format(DUE_IN, CustomerOrder.getDurationString(remainingTime))) : NOT_APPLICABLE;
            return remainingTime;
        }
        Duration time = this.getOutstandingTime();
        this.remainingString = time != null ? MessageFormat.format(OPEN_FOR, CustomerOrder.getDurationString(time)) : NOT_APPLICABLE;
        return null;
    }

    private void refreshUrgency(Instant now, Duration remainingTime) {
        if (this.outstPackQty > 0L) {
            if (remainingTime != null && remainingTime.isNegative()) {
                this.urgency = Urgency.OVERDUE;
            }
            this.urgency = this.criticalDate != null && now.isAfter(this.criticalDate) ? Urgency.CRITICAL : (this.warningDate != null && now.isAfter(this.warningDate) ? Urgency.ALERT : (remainingTime != null || this.warningDate != null || this.criticalDate != null ? Urgency.NORMAL : Urgency.NONE));
        } else {
            this.urgency = Urgency.NONE;
        }
    }

    public void refreshQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getOrderTypeString().toUpperCase());
        builder.append('\n');
        builder.append(this.getOrderStatusString().toUpperCase());
        builder.append('\n');
        builder.append(this.getTransNum().toUpperCase());
        builder.append('\n');
        builder.append(this.getCustOrderNum().toUpperCase());
        builder.append('\n');
        builder.append(this.getDocketNum().toUpperCase());
        builder.append('\n');
        builder.append(this.getOrderDateString().toUpperCase());
        builder.append('\n');
        builder.append(this.getCustomer().toUpperCase());
        builder.append('\n');
        builder.append(this.getPhone().toUpperCase());
        builder.append('\n');
        builder.append(this.getMobile().toUpperCase());
        builder.append('\n');
        builder.append(this.getEmail().toUpperCase());
        builder.append('\n');
        builder.append(this.getAddress().toUpperCase());
        builder.append('\n');
        builder.append(this.getCarrier().toUpperCase());
        builder.append('\n');
        builder.append(this.getServiceType().toUpperCase());
        builder.append('\n');
        builder.append(this.getSLA().toUpperCase());
        builder.append('\n');
        this.queryString = builder.toString();
    }

    public boolean search(String text) {
        String[] words;
        boolean found = false;
        for (String word : words = text.trim().toUpperCase().split("\\s+")) {
            if (word.length() <= 0 || (found = this.queryString.contains(word))) continue;
            return false;
        }
        return found;
    }

    private static String generateAddress(String company, String address1, String address2, String city, String state, String postcode, String country) {
        StringBuilder builder = new StringBuilder();
        if (!StringUtils.isNullOrEmpty(company)) {
            builder.append(company);
        }
        if (!StringUtils.isNullOrEmpty(address1)) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(address1);
        }
        if (!StringUtils.isNullOrEmpty(address2)) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(address2);
        }
        if (!StringUtils.isNullOrEmpty(city)) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(city);
        }
        if (!StringUtils.isNullOrEmpty(state)) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(state);
        }
        if (!StringUtils.isNullOrEmpty(postcode)) {
            if (!StringUtils.isNullOrEmpty(state)) {
                builder.append(' ');
            } else if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(postcode);
        }
        if (!StringUtils.isNullOrEmpty(country)) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(country);
        }
        return builder.toString();
    }

    private static OrderStatus getStatus(OrderType type, long qtyToPack) {
        if (type == OrderType.CustomerPickup && qtyToPack <= 0L) {
            return OrderStatus.WaitingForCollection;
        }
        return OrderStatus.ReadyToPack;
    }

    private static String getDurationString(Duration duration) {
        long minutes = Math.abs(duration.toMinutes());
        StringBuilder result = new StringBuilder();
        int units = 0;
        if (units < 2 && minutes >= 1440L) {
            long days = minutes / 1440L;
            if (units > 0) {
                result.append(' ');
            }
            result.append(MessageFormat.format(days == 1L ? DAY_FORMAT : DAYS_FORMAT, days));
            minutes %= 1440L;
            ++units;
            if (days >= 2L) {
                return result.toString();
            }
        }
        if (units < 2 && minutes > 60L) {
            long hours = minutes / 60L;
            if (units > 0) {
                result.append(' ');
            }
            result.append(MessageFormat.format(hours == 1L ? HOUR_FORMAT : HOURS_FORMAT, hours));
            minutes %= 60L;
            ++units;
            if (hours >= 10L) {
                return result.toString();
            }
        }
        if (units < 2 && (units == 0 || minutes > 0L)) {
            if (units > 0) {
                result.append(' ');
            }
            result.append(MessageFormat.format(minutes == 1L ? MINUTE_FORMAT : MINUTES_FORMAT, minutes));
        }
        return result.toString();
    }

    public static Instant getInstant(String dateString) {
        if (dateString.isEmpty()) {
            return null;
        }
        try {
            return INSTANT_CREATOR.parse((CharSequence)dateString, Instant::from);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean needPromptSLASoftCutoffWarning() {
        return this.serviceLevelAgreement != null && this.serviceLevelAgreement.getSoftCufoffHour() >= 0 && this.despatchCutoffDate.equals(LocalDate.now()) && LocalDateTime.now().getHour() >= this.serviceLevelAgreement.getSoftCufoffHour() && this.serviceLevelAgreement.getCutoffWarningMessage() != null && !this.serviceLevelAgreement.getCutoffWarningMessage().isEmpty();
    }

    public boolean hasPassedSLAHardCutoff() {
        return this.serviceLevelAgreement != null && this.despatchCutoffDate != null && (this.despatchCutoffDate.equals(LocalDate.now()) && this.serviceLevelAgreement.getHardCutoffHour() > 0 && LocalDateTime.now().getHour() >= this.serviceLevelAgreement.getHardCutoffHour() || this.despatchCutoffDate.isBefore(LocalDate.now()));
    }

    public boolean getRejectOrderOnMissedPickup() {
        return this.serviceLevelAgreement != null && this.serviceLevelAgreement.getRejectOrderOnMissedPickup();
    }

    public ServiceLevelAgreement getServiceLevelAgreement() {
        return this.serviceLevelAgreement;
    }

    public long getVhIdx() {
        return this.vhIdx;
    }

    public long getOriginStoreIdx() {
        return this.originStoreIdx;
    }
}

