/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.scanpack;

import java.util.List;
import java.util.Vector;
import jpos.PosUtils;
import jpos.StringUtils;
import jpos.StyleLine;

public class ScanPackLine {
    private StyleLine styleLine;
    private boolean packed;
    private boolean pickup;
    private String productDescription;
    private boolean previouslyPacked;
    private boolean stocked;
    private boolean cancelled;
    private String pickSlipRun;

    public ScanPackLine(StyleLine styleLine, boolean packed, boolean pickup) {
        this.styleLine = styleLine;
        this.packed = packed;
        this.pickup = pickup;
        this.previouslyPacked = packed;
        this.cancelled = false;
        this.productDescription = styleLine.getLongSkuDescription();
        this.stocked = styleLine.getStkFlag() == 1;
        this.pickSlipRun = styleLine.getPickSlipRun();
    }

    public ScanPackLine(StyleLine styleLine, boolean cancelled) {
        this.styleLine = styleLine;
        this.packed = false;
        this.pickup = false;
        this.previouslyPacked = false;
        this.cancelled = cancelled;
        this.productDescription = styleLine.getLongSkuDescription();
        this.stocked = styleLine.getStkFlag() == 1;
        this.pickSlipRun = styleLine.getPickSlipRun();
    }

    public String toString() {
        return StringUtils.nullToEmpty(this.productDescription);
    }

    public long getSkuidx() {
        return this.styleLine.getSkuidx();
    }

    public boolean isPacked() {
        return this.packed;
    }

    public String getPickSlipRun() {
        return this.pickSlipRun;
    }

    public boolean ignoreManualPackingSecurity() {
        return this.previouslyPacked || !this.stocked;
    }

    public void setPacked(boolean packed) {
        if (packed != this.packed) {
            double packedQty = PosUtils.scale(this.styleLine.getPackedQty() + (double)(packed ? 1 : -1), 4);
            double packLimit = PosUtils.scale(this.styleLine.getOutstandingQty() + this.styleLine.getTakenQty(), 4);
            if (packedQty < 0.0) {
                packedQty = 0.0;
            } else if (packedQty > packLimit) {
                packedQty = packLimit;
            }
            this.styleLine.setPackedQty(packedQty);
            this.packed = packed;
            if (packed) {
                this.previouslyPacked = true;
            } else {
                this.setPickup(false);
            }
        }
    }

    public boolean isPickup() {
        return this.pickup;
    }

    public void setPickup(boolean pickup) {
        if (pickup != this.pickup) {
            if (pickup && !this.packed) {
                return;
            }
            double pickupQty = PosUtils.scale(this.styleLine.getPickUpQty() + (double)(pickup ? 1 : -1), 4);
            if (pickupQty < 0.0) {
                pickupQty = 0.0;
            } else if (pickupQty > this.styleLine.getOutstandingPackedQty()) {
                pickupQty = this.styleLine.getOutstandingPackedQty();
            }
            this.styleLine.setPickUpQty(pickupQty);
            this.pickup = pickup;
        }
    }

    public static List<ScanPackLine> createScanPackLines(StyleLine styleLine) {
        Vector<ScanPackLine> lines = new Vector<ScanPackLine>();
        long outstanding = (long)Math.ceil(styleLine.getOutstandingQty());
        int i = 0;
        while ((long)i < outstanding) {
            boolean packed = (double)i < styleLine.getOutstandingPackedQty();
            boolean pickup = (double)i < styleLine.getPickUpQty();
            lines.add(new ScanPackLine(styleLine, packed, pickup));
            ++i;
        }
        return lines;
    }

    public static List<ScanPackLine> createCancelItemLines(StyleLine styleLine) {
        long diff;
        Vector<ScanPackLine> lines = new Vector<ScanPackLine>();
        long outstanding = (long)Math.ceil(styleLine.getOutstandingQty());
        for (long i = diff = (long)Math.ceil(styleLine.getQty(3)); i < 0L; ++i) {
            lines.add(new ScanPackLine(styleLine, true));
        }
        int i = 0;
        while ((long)i < outstanding) {
            lines.add(new ScanPackLine(styleLine, false));
            ++i;
        }
        return lines;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        if (cancelled != this.cancelled) {
            double outstandingQty = PosUtils.scale(this.styleLine.getQty() + (double)(cancelled ? -1 : 1), 4);
            if (outstandingQty < 0.0) {
                outstandingQty = 0.0;
            }
            this.styleLine.setQty(outstandingQty);
            this.cancelled = cancelled;
        }
    }

    public boolean hasCustomisation() {
        return !StringUtils.isNullOrEmpty(this.styleLine.getCustomisation());
    }
}

