/*
 * Decompiled with CFR 0.152.
 */
package jpos.display.device;

import JCP.JcpApi;
import JCP.JcpObject;
import JCP.JcpRequestResult;
import java.io.Reader;
import java.io.StringReader;
import jpos.ErrorHandler;
import jpos.PosUtils;
import jpos.display.device.DisplayDeviceCaps;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class DisplayDeviceProvider
extends JcpObject {
    private int externalDisplayProviderID = -1;
    private String deviceName;

    public DisplayDeviceProvider(String deviceName) {
        this.deviceName = deviceName;
    }

    private int getPosSaleDisplayProviderInstance() {
        if (this.externalDisplayProviderID == -1) {
            try {
                JcpRequestResult result = JcpApi.CreateObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (String)"Bass.Ap21.Pos.PosPlatformExchange.ExternalDisplayProvider", (Object[])new Object[]{this.deviceName});
                if (result.getSuccess()) {
                    this.externalDisplayProviderID = result.getRequestResultAsInt();
                } else {
                    ErrorHandler.logMessage(result.getCustomMessage() + "\r\n" + result.getErrorMessage());
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
                this.externalDisplayProviderID = -1;
            }
        }
        return this.externalDisplayProviderID;
    }

    public boolean displayMessage(String message, boolean scroll) throws Exception {
        if (this.getPosSaleDisplayProviderInstance() > 0) {
            Element element;
            JcpRequestResult result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.externalDisplayProviderID, (String)"DisplayMessage", (Object[])new Object[]{message, scroll});
            if (result.getSuccess() && (element = this.processResult(result)) != null && element.getName().equalsIgnoreCase("OK")) {
                return true;
            }
            throw new Exception(result.getErrorMessage());
        }
        return false;
    }

    public DisplayDeviceCaps getDeviceCaps() throws Exception {
        if (this.getPosSaleDisplayProviderInstance() > 0) {
            Element element;
            JcpRequestResult result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.externalDisplayProviderID, (String)"GetDisplayDeviceCaps", (Object[])new Object[0]);
            if (result.getSuccess() && (element = this.processResult(result)) != null && element.getName().equalsIgnoreCase("Result")) {
                DisplayDeviceCaps caps = new DisplayDeviceCaps();
                caps.characterCount = new Integer(element.getAttribute("character_count").getValue());
                caps.lineCount = new Integer(element.getAttribute("line_count").getValue());
                return caps;
            }
            throw new Exception(result.getErrorMessage());
        }
        return null;
    }

    private Element processResult(JcpRequestResult result) {
        try {
            String resultString = result.getRequestResultAsXmlString();
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(resultString));
            Element returnXml = doc.getRootElement();
            if (returnXml.getName().equalsIgnoreCase("Error")) {
                this.HandleException(returnXml);
            }
            return returnXml;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return null;
        }
    }

    private void HandleException(Element returnXml) throws Exception {
        if (!(returnXml = returnXml.getChild("Exceptions").getChild("Exception")).getAttribute("type").getValue().equalsIgnoreCase("InstanceNotFoundException")) {
            throw new Exception(String.format("Unexpected exception returned, %s: %s\n%s", returnXml.getAttribute("type").getValue(), returnXml.getAttribute("message").getValue(), returnXml.getAttribute("stack_trace").getValue()));
        }
        ErrorHandler.logMessage(returnXml.getAttribute("message").getValue());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.externalDisplayProviderID > 0) {
            JcpApi.ReleaseObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.externalDisplayProviderID);
            this.externalDisplayProviderID = -1;
        }
    }
}

