/*
 * Decompiled with CFR 0.152.
 */
package jpos.kleber;

import jpos.SP;
import jpos.StringUtils;
import jpos.kleber.KleberModels;

public class KleberApiException
extends Exception {
    private KleberModels.ErrorResponse apiError;

    public KleberApiException(String message, KleberModels.ErrorResponse apiError) {
        super(message);
        this.apiError = apiError;
    }

    public KleberApiException(String message, Exception e) {
        super(message, e);
    }

    public KleberApiException(String message) {
        super(message);
    }

    public String getErrorCode() {
        return this.apiError != null ? this.apiError.errorCode : "";
    }

    public String getErrorId() {
        return this.apiError != null ? this.apiError.errorId : "";
    }

    public int getHttpStatusCode() {
        return this.apiError != null ? this.apiError.httpStatusCode : -1;
    }

    public String getErrorMessage() {
        if (this.apiError != null) {
            if (!StringUtils.isNullOrEmpty(this.apiError.message)) {
                return this.apiError.message;
            }
            return SP.getRS("afterpay_missing_error", "\n", this.apiError.errorCode, this.apiError.httpStatusCode);
        }
        return this.getCause() != null ? this.getCause().getMessage() : this.getMessage();
    }
}

