/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.util.Vector;
import jpos.Reference;
import jpos.SP;
import jpos.StringUtils;
import jpos.labelprinting.LabelWriter;
import jpos.labelprinting.PrinterLabel;

public class HeaderLabel
extends PrinterLabel {
    private Vector<Reference> referenceList;

    public HeaderLabel(Vector<Reference> referenceList) {
        this.referenceList = referenceList;
    }

    @Override
    public boolean writeLabelToFile() {
        if (this.getLabelFormat().hasHeaderTemplate()) {
            LabelWriter writer = new LabelWriter(this.getLabelFormat().getHeaderTemplate());
            writer.setEscapeStrings(SP.sParams.getEscapeLabelPrintStrings());
            for (int i = 0; i < this.referenceList.size(); ++i) {
                writer.addValue("GROUP_" + (i + 1) + "_NAME", StringUtils.nullToEmpty(this.referenceList.get(i).getGroupName()));
                writer.addValue("GROUP_" + (i + 1) + "_VALUE", StringUtils.nullToEmpty(this.referenceList.get(i).getName()));
            }
            return writer.sendLabelToDestination(this.getPrintQuantity());
        }
        return true;
    }

    @Override
    public int getPrintQuantity() {
        return 1;
    }

    @Override
    public boolean isCounted() {
        return false;
    }
}

