/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class PcxImage {
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private int pcxVersion;
    private int bitsPerPixel;
    private int xMin;
    private int yMin;
    private int xMax;
    private int yMax;
    private int hDpi;
    private int vDpi;
    private byte[] colourMap = new byte[48];
    private int noOfColourPlanes;
    private int bytesPerLine;
    private int paletteInfo;
    private int horizontalScreenSize;
    private int verticalScreenSize;
    private byte[] imageData;

    public PcxImage(String pcxImageFileName) throws Exception, IOException {
        File file = new File(pcxImageFileName);
        if (!file.exists()) {
            throw new FileNotFoundException(pcxImageFileName);
        }
        try (FileInputStream input = new FileInputStream(pcxImageFileName);){
            this.loadAndValidatePcxFileHeader(input);
            this.imageData = new byte[(int)(file.length() - 128L)];
            ((InputStream)input).read(this.imageData);
        }
    }

    private void loadAndValidatePcxFileHeader(InputStream input) throws Exception, IOException {
        if (input.read() != 10) {
            throw new Exception("File format is not PCX.");
        }
        this.pcxVersion = input.read();
        if (input.read() != 0) {
            throw new Exception("The compressed PCX file format is not supported.");
        }
        this.bitsPerPixel = input.read();
        this.xMin = this.readInt16(input);
        this.yMin = this.readInt16(input);
        this.xMax = this.readInt16(input);
        this.yMax = this.readInt16(input);
        this.hDpi = this.readInt16(input);
        this.vDpi = this.readInt16(input);
        input.read(this.colourMap);
        input.read();
        this.noOfColourPlanes = input.read();
        if (this.noOfColourPlanes != 1) {
            throw new Exception("The PCX image can only contain 1 colour.");
        }
        this.bytesPerLine = this.readInt16(input);
        this.paletteInfo = this.readInt16(input);
        this.horizontalScreenSize = this.readInt16(input);
        this.verticalScreenSize = this.readInt16(input);
        input.skip(54L);
    }

    private int readInt16(InputStream input) throws IOException {
        return input.read() | input.read() << 8;
    }

    public int getWidth() {
        return this.xMax - this.xMin + 1;
    }

    public int getHeight() {
        return this.yMax - this.yMin + 1;
    }

    public int getTotalBytesPerLine() {
        return this.noOfColourPlanes * this.bytesPerLine;
    }

    public int getTotalByteCount() {
        return this.imageData.length;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public static String getByteArrayAsHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

