/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import jpos.DlgMessage;
import jpos.PosComboBox;
import jpos.PosDateField;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.labelprinting.ILabelDialog;
import jpos.labelprinting.LabelDialogType;
import jpos.labelprinting.LabelFormat;
import jpos.labelprinting.LabelFormats;
import jpos.labelprinting.PrinterLabelFactory;
import jpos.labelprinting.SkuLabel;
import jpos.searchfields.ProductClrSizeSearch;
import jpos.searchfields.SearchButton;
import jpos.searchfields.SearchPanel;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import jpos.ui.UIConstants;

public class ScanLabelPrintDlg
extends PosDialog
implements ILabelDialog {
    private static final int DISPLAY_ROWS = 5;
    private LabelSubHeading labelHeading;
    private LabelNormal labelFormat;
    private LabelNormal labelPriceDate;
    private PosComboBox<LabelFormat> cmbFormat = new PosComboBox<LabelFormat>(new LabelFormats());
    private PosDateField priceDate;
    private BlockingQueue<SkuLabel> labelQueue = new LinkedBlockingQueue<SkuLabel>();
    private QueueTableModel tableModel = new QueueTableModel();
    private QueueWorker worker = null;
    private PosScrollPane selectionsScroll = new PosScrollPane();
    private PosTable queueTable = new PosTable(this, this.tableModel);
    private ProductClrSizeSearch barcodeField = new ProductClrSizeSearch(this, TouchTextField.FontSize.LARGE){

        @Override
        public boolean processSku(long skuidx, String barcode) {
            ScanLabelPrintDlg.this.printSku(skuidx);
            return true;
        }
    };
    private DialogButton singleButton;
    private DialogButton closeButton;
    private LabelDialogType nextDialog = LabelDialogType.NONE;

    public ScanLabelPrintDlg(PosFrame parentFrame) {
        super(parentFrame, SP.getRS("Label_Print_Scan"), true);
        try {
            this.initialiseScreen();
            this.pack();
            this.setMinimumSize(this.getSize());
            PosUtils.centreWindow(this);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.worker = new QueueWorker();
        this.worker.execute();
    }

    private void initialiseScreen() {
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelContent = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        this.labelHeading = new LabelSubHeading(this.getTitle());
        this.labelFormat = new LabelNormal(SP.getRS("Label_Print_Format"));
        if (this.cmbFormat.getItemCount() > 0) {
            this.cmbFormat.setSelectedIndex(0);
        }
        if (this.cmbFormat.getItemCount() <= 1) {
            this.labelFormat.setVisible(false);
            this.cmbFormat.setVisible(false);
        }
        this.cmbFormat.setFieldWidth(140);
        this.labelPriceDate = new LabelNormal(SP.getRS("Label_Print_Price_Date"));
        this.priceDate = new PosDateField(this);
        this.priceDate.setFieldWidth(100);
        SearchPanel priceDateSearchPanel = new SearchPanel(this.priceDate, SearchButton.SearchIcon.CALENDAR);
        this.priceDate.setValue(new Timestamp(new Date().getTime()));
        this.singleButton = new DialogButton("");
        this.singleButton.setText(StoreParams.res.getString("Label_Print_Single_Button"));
        this.singleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanLabelPrintDlg.this.nextDialog = LabelDialogType.SINGLE;
                ScanLabelPrintDlg.this.cancelDialog();
            }
        });
        this.closeButton = new DialogButton("");
        this.closeButton.setText(StoreParams.res.getString("Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanLabelPrintDlg.this.cancelDialog();
            }
        });
        this.queueTable.setFocusable(false);
        this.queueTable.setEnabled(false);
        this.tableModel.setTable(this.queueTable);
        this.queueTable.getColumnModel().getColumn(0).setMaxWidth(45);
        this.queueTable.getColumnModel().getColumn(4).setMaxWidth(60);
        this.selectionsScroll.getViewport().add((Component)this.queueTable, null);
        this.selectionsScroll.setPreferredSize(new Dimension(450, UIConstants.TABLE_ROW_HEIGHT * 6 + 2));
        panelMain.add((Component)panelContent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 0, 20), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(10, 20, 10, 20), 0, 0));
        this.getContentPane().add(panelMain);
        panelContent.add((Component)this.labelHeading, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add((Component)this.singleButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        panelContent.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 5, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add((Component)this.labelFormat, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add(this.cmbFormat, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        panelContent.add((Component)new JLabel(), new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 0), 0, 0));
        panelContent.add((Component)this.labelPriceDate, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add((Component)priceDateSearchPanel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        panelContent.add((Component)this.barcodeField.getBarcodeSearchField(), new GridBagConstraints(0, 3, 5, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add((Component)this.selectionsScroll, new GridBagConstraints(0, 4, 5, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        panelFooter.add((Component)this.closeButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.barcodeField.getBarcodeSearchField());
        tabOrder.add(this.closeButton);
        tabOrder.add(this.singleButton);
        tabOrder.add(this.cmbFormat);
        tabOrder.add(this.priceDate);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
    }

    private void printSku(long skuIdx) {
        SkuLabel skuLabel = PrinterLabelFactory.createSkuLabel(skuIdx, this.priceDate.getValue());
        if (skuLabel != null) {
            skuLabel.setLabelFormat((LabelFormat)this.cmbFormat.getSelectedItem());
            if (this.labelQueue.offer(skuLabel)) {
                this.tableModel.add(skuLabel);
            } else {
                DlgMessage.showMessage(this, SP.getRS("Label_Print_Scan_Error_Queue"), this.getTitle(), 0);
            }
        }
    }

    @Override
    public void cancelDialog() {
        this.worker.cancel(false);
        this.dispose();
    }

    @Override
    public void okDialog() {
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public LabelDialogType getNextDialogType() {
        return this.nextDialog;
    }

    @Override
    public void showDialog() {
        this.setVisible(true);
    }

    private class QueueWorker
    extends SwingWorker<Void, SkuLabelResult> {
        private Exception exception = null;

        private QueueWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            try {
                while (!this.isCancelled()) {
                    SkuLabel label = (SkuLabel)ScanLabelPrintDlg.this.labelQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (label == null) continue;
                    ResultState resultState = label.writeLabelToFile() ? ResultState.SUCCESS : ResultState.FAILURE;
                    SkuLabelResult result = new SkuLabelResult(label, resultState);
                    if (resultState == ResultState.FAILURE && !this.isCancelled()) {
                        SwingUtilities.invokeAndWait(() -> DlgMessage.showMessage(ScanLabelPrintDlg.this, SP.getRS("Label_Print_Failed_to_Print"), ScanLabelPrintDlg.this.getTitle(), 0));
                    }
                    this.publish(result);
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
            return null;
        }

        @Override
        protected void process(List<SkuLabelResult> labelResults) {
            ScanLabelPrintDlg.this.tableModel.update(labelResults);
        }

        @Override
        public void done() {
            if (this.exception != null) {
                PosUtils.logError(this.exception);
            }
        }
    }

    private class QueueTableModel
    extends AbstractTableModel {
        private List<SkuLabel> labelList = new ArrayList<SkuLabel>();
        private List<ResultState> resultList = new ArrayList<ResultState>();
        private int removedCount = 0;
        private PosTable table;

        private QueueTableModel() {
        }

        private void refreshTable() {
            int nextQueued = -1;
            int remainingRecent = 4;
            for (int i = this.resultList.size() - 1; i >= 0; --i) {
                if (this.resultList.get(i) == ResultState.NOT_STARTED) {
                    nextQueued = i;
                    continue;
                }
                if (remainingRecent > 0) {
                    --remainingRecent;
                    continue;
                }
                this.labelList.remove(i);
                this.resultList.remove(i);
                ++this.removedCount;
                if (nextQueued <= -1) continue;
                --nextQueued;
            }
            this.fireTableDataChanged();
            if (this.table != null) {
                this.table.selectRow(nextQueued);
            }
        }

        public void add(SkuLabel label) {
            this.labelList.add(label);
            this.resultList.add(ResultState.NOT_STARTED);
            this.refreshTable();
        }

        public void update(List<SkuLabelResult> labelResults) {
            block0: for (SkuLabelResult labelResult : labelResults) {
                for (int i = 0; i < this.labelList.size(); ++i) {
                    if (labelResult.label != this.labelList.get(i)) continue;
                    this.resultList.set(i, labelResult.result);
                    continue block0;
                }
            }
            this.refreshTable();
        }

        public void setTable(PosTable table) {
            this.table = table;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "#";
                }
                case 1: {
                    return "Code";
                }
                case 2: {
                    return "Colour";
                }
                case 3: {
                    return "Size";
                }
                case 4: {
                    return "Printed";
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 4) {
                return Icon.class;
            }
            return Object.class;
        }

        @Override
        public int getRowCount() {
            return this.labelList != null ? this.labelList.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.labelList == null || this.labelList.size() <= rowIndex) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return rowIndex + this.removedCount + 1;
                }
                case 1: {
                    return this.labelList.get(rowIndex).getStyleCode();
                }
                case 2: {
                    return this.labelList.get(rowIndex).getColourCode();
                }
                case 3: {
                    return this.labelList.get(rowIndex).getSizeValue();
                }
                case 4: {
                    return this.resultList.get(rowIndex).getIcon();
                }
            }
            return null;
        }
    }

    private class SkuLabelResult {
        SkuLabel label;
        ResultState result;

        public SkuLabelResult(SkuLabel label, ResultState result) {
            this.label = label;
            this.result = result;
        }
    }

    private static enum ResultState {
        NOT_STARTED(new ImageIcon(SP.sParams.imagepath + "unchecked.png")),
        SUCCESS(new ImageIcon(SP.sParams.imagepath + "tick32x32.png")),
        FAILURE(new ImageIcon(SP.sParams.imagepath + "abort20x20.png"));

        private ImageIcon icon;

        private ResultState(ImageIcon icon) {
            this.icon = icon;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }
    }
}

