/*
 * Decompiled with CFR 0.152.
 */
package jpos.omneo;

import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;

class OmneoDataTransaction {
    private static int MAX_REVERSAL_ATTEMPTS = 14;
    private long redemptionId = 0L;
    private String cardNumber;
    private String omneoTransactionId;
    private double amount;

    protected OmneoDataTransaction() {
        this(0L);
    }

    private OmneoDataTransaction(long redemptionId) {
        this.redemptionId = redemptionId;
        if (this.redemptionId > 0L) {
            this.loadFromDatabase();
        }
    }

    private void loadFromDatabase() {
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT CARD_NUMBER, AMOUNT, OMNEO_TRANSACTION_ID FROM OMNEO_TRANSACTION WHERE TRANSIDX = " + this.redemptionId);){
            if (query.next()) {
                this.cardNumber = query.getString("CARD_NUMBER");
                this.amount = query.getDouble("AMOUNT");
                this.omneoTransactionId = query.getString("OMNEO_TRANSACTION_ID");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    protected boolean saveRedeption(String omneoTransactionId, long memidx) {
        Timestamp redemptionDate = new Timestamp(new Date().getTime());
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("INSERT INTO OMNEO_TRANSACTION (TRANSIDX, CARD_NUMBER, AMOUNT, TILL_NAME, MEMIDX, REDEMPTION_DATE, OMNEO_TRANSACTION_ID) VALUES(?, ?, ?, ?, ?, ?, ?)");){
            this.redemptionId = SP.sParams.nextVal("XOMNEO_TRANSACTION");
            stmt.setLong(1, this.redemptionId);
            stmt.setString(2, this.cardNumber);
            stmt.setDouble(3, this.amount);
            stmt.setString(4, SP.sParams.tillnum);
            stmt.setDouble(5, memidx);
            stmt.setTimestamp(6, redemptionDate);
            stmt.setString(7, omneoTransactionId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        this.omneoTransactionId = omneoTransactionId;
        return true;
    }

    protected boolean finishRedeption(long ap21TransactionId) {
        Throwable throwable;
        PreparedStatement stmt;
        if (this.redemptionId == 0L) {
            return false;
        }
        Timestamp committedDate = new Timestamp(new Date().getTime());
        try {
            stmt = SP.sParams.conn.prepareStatement("UPDATE OMNEO_TRANSACTION SET AP21_TRANSACTION_ID = ?, COMMITTED_DATE = ? WHERE TRANSIDX = ?");
            throwable = null;
            try {
                stmt.setLong(1, ap21TransactionId);
                stmt.setTimestamp(2, committedDate);
                stmt.setLong(3, this.redemptionId);
                stmt.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        try {
            stmt = SP.sParams.conn.prepareStatement("UPDATE RET_TRANH SET OMNEO_TRANSACTION_ID = ?, OMNEO_REDEMPTION_VALUE = ? WHERE VHIDX = ?");
            throwable = null;
            try {
                stmt.setString(1, this.omneoTransactionId);
                stmt.setDouble(2, this.amount);
                stmt.setLong(3, ap21TransactionId);
                stmt.executeUpdate();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return false;
    }

    protected boolean reverseRedeption() {
        if (this.redemptionId == 0L) {
            return false;
        }
        Timestamp reversalDate = new Timestamp(new Date().getTime());
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE OMNEO_TRANSACTION SET REVERSAL_DATE = ?, REVERSAL_ATTEMPT_COUNT = COALESCE(REVERSAL_ATTEMPT_COUNT,0) + 1 WHERE TRANSIDX = ?");){
            stmt.setTimestamp(1, reversalDate);
            stmt.setLong(2, this.redemptionId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return false;
    }

    protected boolean logFailedReversal() {
        if (this.redemptionId == 0L) {
            return false;
        }
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE OMNEO_TRANSACTION SET REVERSAL_ATTEMPT_COUNT = COALESCE(REVERSAL_ATTEMPT_COUNT,0) + 1 WHERE TRANSIDX = ?");){
            stmt.setLong(1, this.redemptionId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return false;
    }

    protected static ArrayList<OmneoDataTransaction> getAllTransactionsToReverse() {
        ArrayList<OmneoDataTransaction> list = new ArrayList<OmneoDataTransaction>();
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT TRANSIDX, REDEMPTION_DATE, REVERSAL_ATTEMPT_COUNT FROM OMNEO_TRANSACTION WHERE AP21_TRANSACTION_ID IS NULL AND REVERSAL_DATE IS NULL  AND COALESCE(REVERSAL_ATTEMPT_COUNT,0) <= " + MAX_REVERSAL_ATTEMPTS + " AND TILL_NAME = " + PosUtils.StringToSqlString(SP.sParams.tillnum));){
            while (query.next()) {
                int retryCount;
                Timestamp redemptionDate = query.getTimestamp("REDEMPTION_DATE");
                if (!OmneoDataTransaction.canRetryReversal(redemptionDate, retryCount = query.getInt("REVERSAL_ATTEMPT_COUNT"))) continue;
                list.add(new OmneoDataTransaction(query.getLong("TRANSIDX")));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return list;
    }

    protected void setCardNumber(String cardNo) {
        this.cardNumber = cardNo;
    }

    protected String getCardNumber() {
        return this.cardNumber;
    }

    protected String getOmneoTransactionId() {
        return this.omneoTransactionId;
    }

    protected double getAmount() {
        return this.amount;
    }

    protected void setAmount(double amount) {
        this.amount = amount;
    }

    protected static boolean canRetryReversal(Timestamp redemptionTime, int retryCount) {
        long retryMiliSeconds = OmneoDataTransaction.calculateRetryMiliSeconds(retryCount);
        Date now = new Date();
        return redemptionTime.getTime() + retryMiliSeconds < now.getTime();
    }

    protected static long calculateRetryMiliSeconds(int retryCount) {
        if (retryCount == 0) {
            return 0L;
        }
        long minutes = 0L;
        for (int i = 0; i < retryCount; ++i) {
            minutes = (long)((double)minutes + Math.pow(2.0, i));
        }
        return minutes * 60L * 1000L;
    }
}

