/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JDialog;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.DlgOfflineCredCheck;
import jpos.FrSales;
import jpos.PaSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.basscom.DecBuffer;
import jpos.pay.PayDialog;
import jpos.pay.PayUtils;
import jpos.pay.RetTranP;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import org.jdom.Element;

public class AccountPaymentDlg
extends PayDialog {
    private LabelNormal lBalance = new LabelNormal();
    private TouchTextField dfBalance = new TouchTextField();
    private LabelSubHeading lAmount = new LabelSubHeading();
    private DecimalField dfAmount;
    private DialogButton bOk;
    private DialogButton bCancel;
    private GridBagLayout gridBagLayout1;
    private RetTranP retTranP;
    private double maxAmount;

    public AccountPaymentDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfAmount = new DecimalField(SP.sParams.storeCurrency);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        this.gridBagLayout1 = new GridBagLayout();
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayout1);
        this.lBalance.setText(SP.getRS("current_account_balance"));
        this.dfBalance.setDisabledTextColor(Colours.BLACK);
        this.dfBalance.setEnabled(false);
        this.dfBalance.setHorizontalAlignment(4);
        this.dfBalance.setFieldWidth(137);
        this.lAmount.setText(SP.getRS("enter_amount_to_pay"));
        this.dfAmount.setFieldWidth(137);
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.dfAmount.setText("");
        this.getContentPane().add(this.panelAll);
        this.panelAll.add((Component)this.lBalance, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelAll.add((Component)this.dfBalance, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(20, 10, 10, 20), 0, 0));
        this.panelAll.add((Component)this.lAmount, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.dfAmount, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.bOk, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelAll.add((Component)this.bCancel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfAmount);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    public void setRetTranP(RetTranP pRetTranP) {
        this.retTranP = pRetTranP;
    }

    public void setMaxAmt(double pMaxAmount) {
        this.maxAmount = pMaxAmount;
    }

    @Override
    public boolean initDialog() {
        this.dfAmount.setText(this.retTranP.getAmount());
        Object[] objs = new Object[]{this.retTranP.getPayType().code};
        this.lAmount.setText(MessageFormat.format(SP.getRS("enter_amt_to_pay"), objs));
        DecBuffer custBalance = PayUtils.getBalance(this, this.frSales);
        boolean bShowAccountBalance = false;
        this.lBalance.setVisible(bShowAccountBalance);
        this.dfBalance.setVisible(bShowAccountBalance);
        if (custBalance.isNull() || !bShowAccountBalance) {
            this.dfBalance.setText(SP.getRS("not_available"));
        } else {
            this.dfBalance.setText(SP.sParams.storeCurrency.formatDetailNoScale(custBalance.doubleValue()));
        }
        this.pack();
        return super.initDialog();
    }

    @Override
    public void okDialog() {
        double amountRnd = this.retTranP.getPayType().roundAmt(this.dfAmount.getDouble());
        if (amountRnd != this.dfAmount.getDouble()) {
            this.dfAmount.setText(amountRnd);
        } else if (amountRnd > this.maxAmount) {
            DlgMessage.showMessage(this, SP.getRS("max_account_amount"), SP.getRS("Error"), 0);
            this.dfAmount.setText(this.maxAmount);
            this.dfAmount.selectAll();
        } else {
            this.retTranP.setAmount(amountRnd);
            if (AccountPaymentDlg.creditCheck(this, this.frSales, this.retTranP)) {
                super.okDialog();
            }
        }
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public static boolean creditCheck(JDialog dlgParent, FrSales frSales, RetTranP retTranP) {
        boolean bRetVal = false;
        Element person = frSales.getPerson();
        if (person.getAttribute("custidx") != null) {
            SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("cust", person.getAttribute("custidx").getValue()).getXML();
            if (SP.sParams.root == null) {
                StringBuffer sbResult = new StringBuffer();
                DlgOfflineCredCheck dlgOffline = new DlgOfflineCredCheck((PosFrame)frSales, dlgParent, SP.getRS("offline_credit_check"), true, sbResult);
                dlgOffline.setVisible(true);
                if (sbResult.toString().equals("<CANCEL>")) {
                    bRetVal = false;
                } else {
                    retTranP.setAuthorisedBy(sbResult.toString());
                    bRetVal = true;
                }
            } else {
                Element cust = (Element)SP.sParams.root.clone();
                if (cust.getAttribute("custidx") == null) {
                    DlgMessage.showMessage(dlgParent, SP.getRS("no_cust_dets"), SP.getRS("Error"), 0);
                    bRetVal = false;
                } else {
                    bRetVal = ((PaSales)frSales.paBody).creditCheck(dlgParent, cust, false, false, true, retTranP.getAmount());
                }
            }
        } else {
            bRetVal = false;
        }
        return bRetVal;
    }
}

