/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jpos.DecimalField;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.ChangeTM;
import jpos.pay.ChangeTbl;
import jpos.pay.PayDialog;
import jpos.pay.PayType;
import jpos.pay.PayTypeFilter;
import jpos.pay.PayTypes;
import jpos.pay.RetTranP;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class ChangeDlg
extends PayDialog {
    private GridBagLayout gridBagLayoutAll = new GridBagLayout();
    private LabelSubHeading lDocketNumber = new LabelSubHeading();
    private GridBagLayout gridBagLayoutDets = new GridBagLayout();
    private JPanel panelDets = new JPanel(this.gridBagLayoutDets);
    LabelSubHeading lRequiredChangeTotal = new LabelSubHeading();
    private DecimalField dfRequiredChangeTotal;
    private double requiredChangeTotal;
    private LabelSubHeading lTotalPaid;
    private DecimalField dfTotalPaid;
    private double totalPaid;
    private ChangeTM tmChange;
    private ChangeTbl tblChange;
    private PosScrollPane spChange;
    private LabelSubHeading lOutstanding;
    private DecimalField dfOutstanding;
    private double outstanding;
    private boolean isRefund;
    private PayTypeFilter payTypeFilter;
    private Vector<RetTranP> vPayments;
    private GridBagLayout gridBagLayoutFooter;
    private JPanel panelFooter;
    private DialogButton bChangeOverride;
    private DialogButton bOk;
    private DialogButton bCancel;

    public ChangeDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfRequiredChangeTotal = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.lTotalPaid = new LabelSubHeading();
        this.dfTotalPaid = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.tmChange = new ChangeTM(this);
        this.tblChange = new ChangeTbl(this.tmChange);
        this.spChange = new PosScrollPane(this.tblChange);
        this.lOutstanding = new LabelSubHeading();
        this.dfOutstanding = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.gridBagLayoutFooter = new GridBagLayout();
        this.panelFooter = new JPanel(this.gridBagLayoutFooter);
        this.bChangeOverride = new DialogButton("", this);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.initPanelDetails();
        this.initPanelFooter();
        this.panelAll.add((Component)this.lDocketNumber, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(20, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelDets, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelFooter, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(this.panelAll);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tblChange);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.tmChange.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ChangeDlg.this.revalidateChange();
            }
        });
    }

    private void initPanelDetails() {
        this.lRequiredChangeTotal.setText(SP.getRS("change_total"));
        this.dfRequiredChangeTotal.setEnabled(false);
        this.tblChange.revalidate();
        this.spChange.setPreferredSize(new Dimension(100, 11 * this.tblChange.getRowHeight()));
        this.lTotalPaid.setText(SP.getRS("total_paid"));
        this.dfTotalPaid.setEnabled(false);
        this.lOutstanding.setText(SP.getRS("outstanding"));
        this.dfOutstanding.setEnabled(false);
        this.dfRequiredChangeTotal.setFieldWidth(160);
        this.dfTotalPaid.setFieldWidth(160);
        this.dfOutstanding.setFieldWidth(160);
        this.panelDets.setBorder(BorderFactory.createEtchedBorder());
        this.panelDets.add((Component)new LabelNormal(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.lRequiredChangeTotal, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfRequiredChangeTotal, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 10, 10, 20), 0, 0));
        this.panelDets.add((Component)this.spChange, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.panelDets.add((Component)this.lTotalPaid, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfTotalPaid, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.panelDets.add((Component)this.lOutstanding, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfOutstanding, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.dfRequiredChangeTotal.setText("");
        this.dfTotalPaid.setText("");
        this.dfOutstanding.setText("");
    }

    private void initPanelFooter() {
        this.bChangeOverride.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!ChangeDlg.this.isRunning && ChangeDlg.this.isVisible()) {
                        ChangeDlg.this.isRunning = true;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ChangeDlg.this.changeOverride();
                                ChangeDlg.this.isRunning = false;
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.panelFooter.add((Component)this.bChangeOverride, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 5, 10), 0, 0));
        this.panelFooter.add((Component)this.bOk, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        this.panelFooter.add((Component)this.bCancel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 10, 10), 0, 0));
        this.panelFooter.setLayout(this.gridBagLayoutFooter);
    }

    public void getChange(Vector<RetTranP> vRetTranPs) {
        for (int i = 0; i < this.tmChange.vRetTranPs.size(); ++i) {
            RetTranP retTranP = this.tmChange.vRetTranPs.get(i);
            if (retTranP.getAmount() == 0.0) continue;
            vRetTranPs.add(retTranP);
        }
    }

    @Override
    public boolean initDialog() {
        boolean hasAfterpay = false;
        boolean hasZip = false;
        for (RetTranP pay : this.vPayments) {
            if (pay.getPayType().idx == 776L) {
                hasAfterpay = true;
                break;
            }
            if (pay.getPayType().idx != 795L) continue;
            hasZip = true;
            break;
        }
        this.bChangeOverride.setEnabled(this.frSales.hasSecurity(11128L, 0) && !hasAfterpay && !hasZip);
        if (this.isRefund) {
            this.setTitle(SP.getRS("set_refund"));
            this.lRequiredChangeTotal.setText(SP.getRS("refund_total"));
            this.bChangeOverride.setText(SP.getRS("F4_refund_override"));
        } else {
            this.setTitle(SP.getRS("set_change"));
            this.lRequiredChangeTotal.setText(SP.getRS("change_total"));
            this.bChangeOverride.setText(SP.getRS("F4_change_override"));
        }
        this.revalidateChange();
        this.spChange.setPreferredSize(new Dimension(100, 7 * this.tblChange.getRowHeight()));
        this.tblChange.setInitialFocus();
        this.pack();
        return super.initDialog();
    }

    public void revalidateChange() {
        this.totalPaid = PayType.roundDec(-this.tmChange.getTotal());
        this.outstanding = this.requiredChangeTotal - this.totalPaid;
        this.dfRequiredChangeTotal.setText(this.requiredChangeTotal);
        this.dfTotalPaid.setText(this.totalPaid);
        this.dfOutstanding.setText(this.outstanding);
    }

    @Override
    public void okDialog() {
        if (this.tblChange.getCellEditor() != null) {
            this.tblChange.getCellEditor().stopCellEditing();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangeDlg.this.revalidateChange();
                if (ChangeDlg.this.outstanding == 0.0) {
                    ChangeDlg.super.okDialog();
                } else {
                    ChangeDlg.this.tblChange.setFocusLastEdited();
                }
            }
        });
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        if (k.getKeyCode() == 115) {
            this.bChangeOverride.doClick();
            return true;
        }
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public void setRefundDets(double pTotalDue, double pRefund, Vector<RetTranP> pVPayments, PayTypeFilter pPayTypeFilter) {
        this.isRefund = true;
        this.requiredChangeTotal = pRefund;
        this.vPayments = pVPayments;
        this.payTypeFilter = pPayTypeFilter;
        this.totalPaid = 0.0;
        Vector<RetTranP> vRefundRetTranPs = PayTypes.getRefundRetTranPs(this.requiredChangeTotal, this.vPayments, this.payTypeFilter, false);
        this.tblChange.tblModel.vRetTranPs = vRefundRetTranPs;
        this.tblChange.tblModel.setRequiredChangeTotal(pRefund);
        this.tblChange.tblModel.setTotalDue(pTotalDue);
    }

    public void setChangeDets(double pTotalDue, double pRequiredChangeTotal, Vector<RetTranP> pVPayments, PayTypeFilter pPayTypeFilter) {
        this.isRefund = false;
        this.requiredChangeTotal = pRequiredChangeTotal;
        this.vPayments = pVPayments;
        this.payTypeFilter = pPayTypeFilter;
        this.totalPaid = 0.0;
        Vector<RetTranP> vChangeRetTranPs = PayTypes.getChangeRetTranPs(this.requiredChangeTotal, this.vPayments, this.payTypeFilter, false);
        this.tblChange.tblModel.vRetTranPs = vChangeRetTranPs;
        this.tblChange.tblModel.setRequiredChangeTotal(pRequiredChangeTotal);
        this.tblChange.tblModel.setTotalDue(pTotalDue);
    }

    private void changeOverride() {
        this.bChangeOverride.setEnabled(false);
        if (this.isRefund) {
            Vector<RetTranP> vRefundRetTranPs = PayTypes.getRefundRetTranPs(this.requiredChangeTotal, this.vPayments, this.payTypeFilter, true);
            this.tblChange.tblModel.vRetTranPs = vRefundRetTranPs;
            this.tblChange.tblModel.fireTableDataChanged();
        } else {
            Vector<RetTranP> vChangeRetTranPs = PayTypes.getChangeRetTranPs(this.requiredChangeTotal, this.vPayments, this.payTypeFilter, true);
            this.tblChange.tblModel.vRetTranPs = vChangeRetTranPs;
            this.tblChange.tblModel.fireTableDataChanged();
        }
    }
}

