/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jpos.DecimalField;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.PayType;
import jpos.pay.PayUtils;
import jpos.pay.RetTranP;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;

public class LaybyCancelDlg
extends PayDialog {
    private boolean isLayby = true;
    private GridBagLayout gridBagLayoutAll = new GridBagLayout();
    private GridBagLayout gridBagLayoutDets = new GridBagLayout();
    private JPanel panelDets = new JPanel(this.gridBagLayoutDets);
    private LabelNormal lTotalPayments = new LabelNormal();
    private DecimalField dfTotalPayments;
    private double totalPayments;
    private LabelNormal lLaybyFee;
    private DecimalField dfLaybyFee;
    private double laybyFee;
    private double origLaybyFee;
    private boolean bAllowDelFee;
    private DialogButton bDelFee;
    private LabelNormal lRefund;
    private DecimalField dfRefund;
    private double refund;
    private GridBagLayout gridBagLayoutFooter;
    private JPanel panelFooter;
    private DialogButton bOk;
    private DialogButton bCancel;

    public LaybyCancelDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfTotalPayments = new DecimalField(SP.sParams.storeCurrency);
        this.lLaybyFee = new LabelNormal();
        this.dfLaybyFee = new DecimalField(SP.sParams.storeCurrency);
        this.bAllowDelFee = false;
        this.bDelFee = new DialogButton("", this);
        this.lRefund = new LabelNormal();
        this.dfRefund = new DecimalField(SP.sParams.storeCurrency);
        this.gridBagLayoutFooter = new GridBagLayout();
        this.panelFooter = new JPanel(this.gridBagLayoutFooter);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.lTotalPayments.setText(SP.getRS("total_payments"));
        this.dfTotalPayments.setEnabled(false);
        this.lLaybyFee.setText(SP.getRS("cancel_fee"));
        this.bDelFee.setText(SP.getRS("F2_delete_fee"));
        this.bDelFee.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LaybyCancelDlg.this.isRunning && LaybyCancelDlg.this.isVisible()) {
                    LaybyCancelDlg.this.isRunning = true;
                    LaybyCancelDlg.this.deleteFee();
                    LaybyCancelDlg.this.isRunning = false;
                }
            }
        });
        this.dfLaybyFee.setEnabled(false);
        this.lRefund.setText(SP.getRS("refund"));
        this.dfRefund.setEnabled(false);
        this.panelDets.setBorder(BorderFactory.createEtchedBorder());
        this.panelDets.add((Component)this.lTotalPayments, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 50, 0));
        this.panelDets.add((Component)this.dfTotalPayments, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 10, 10, 20), 160, 0));
        if (!SP.sParams.bUsingExtendedTax) {
            this.panelDets.add((Component)this.lLaybyFee, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 10), 50, 0));
            this.panelDets.add((Component)this.dfLaybyFee, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 20), 160, 0));
            this.panelDets.add((Component)this.bDelFee, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 20), 50, 0));
        }
        this.panelDets.add((Component)this.lRefund, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 50, 0));
        this.panelDets.add((Component)this.dfRefund, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 160, 0));
        this.dfTotalPayments.setText("");
        this.dfLaybyFee.setText("");
        this.dfRefund.setText("");
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.panelFooter.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.setLayout(this.gridBagLayoutFooter);
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.panelAll.add((Component)this.panelDets, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 10, 20), 1, 1));
        this.panelAll.add((Component)this.panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 1, 1));
        this.getContentPane().add(this.panelAll);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.bOk);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    public void deleteFee() {
        if (SP.sParams.bUsingExtendedTax) {
            return;
        }
        if (this.bAllowDelFee) {
            this.laybyFee = this.laybyFee != 0.0 ? 0.0 : this.origLaybyFee;
            this.refund = PayType.roundDec(this.totalPayments - this.laybyFee);
            this.populateFields();
        }
    }

    @Override
    public boolean initDialog() {
        this.bAllowDelFee = this.frSales.hasSecurity(11129L, 0);
        this.populateFields();
        return super.initDialog();
    }

    private void populateFields() {
        if (this.laybyFee == 0.0) {
            this.bDelFee.setText(SP.getRS("F2_add_fee"));
        } else {
            this.bDelFee.setText(SP.getRS("F2_delete_fee"));
        }
        this.dfTotalPayments.setText(this.totalPayments);
        this.dfLaybyFee.setText(this.laybyFee);
        this.dfRefund.setText(this.refund);
        this.bDelFee.setEnabled(this.bAllowDelFee);
    }

    public double getRefundAmt() {
        return this.refund;
    }

    public double getLaybyFee() {
        return this.laybyFee;
    }

    @Override
    public void okDialog() {
        this.laybyFee = this.dfLaybyFee.getDouble();
        this.refund = this.dfRefund.getDouble();
        this.frSales.setCompletingOrder(true);
        super.okDialog();
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        if (k.getKeyCode() == 113) {
            this.bDelFee.doClick();
            return true;
        }
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public void setLaybyDets(boolean pIsLayby, double pLaybyFee, List<?> pOldTendersXML) {
        Vector<RetTranP> vOldRetTranPs = new Vector<RetTranP>();
        this.totalPayments = PayUtils.tendersXMLToVRetTranPs(pOldTendersXML, vOldRetTranPs);
        this.setLaybyDets(pIsLayby, pLaybyFee, this.totalPayments);
    }

    public void setLaybyDets(boolean pIsLayby, double pLaybyFee, double pTotalPayments) {
        this.isLayby = pIsLayby;
        this.laybyFee = pLaybyFee;
        this.origLaybyFee = pLaybyFee;
        this.totalPayments = pTotalPayments;
        this.refund = PayType.roundDec(this.totalPayments - this.laybyFee);
        if (this.isLayby) {
            this.lTotalPayments.setText(SP.getRS("total_payments"));
            this.setTitle(SP.getRS("cancel_layby"));
        } else {
            this.lTotalPayments.setText(SP.getRS("special_order_total"));
            this.setTitle(SP.getRS("cancel_special_order"));
        }
    }
}

